/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.TaskTypes;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.View;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class TaskConfigurator
extends View {
    private static final long serialVersionUID = 1L;
    private static PrefName TASKCONFVIEWSIZE = new PrefName("taskconfviewsize", "-1,-1,-1,-1,N");
    private static ListCellRenderer<Object> defaultRenderer = new DefaultListCellRenderer();
    private static TaskConfigurator singleton = null;
    private JPopupMenu subTaskMenu = null;
    private JList<String> nextStateList = null;
    private JPopupMenu nextStateMenu = null;
    private JList<String> stateList = null;
    private JPopupMenu stateMenu = null;
    private JList<String> subTaskList = null;
    private TaskTypes taskTypes;
    private JList<String> typeList = null;
    private JPopupMenu typeMenu = null;

    public static TaskConfigurator getReference() throws Exception {
        if (singleton == null || !singleton.isShowing()) {
            singleton = new TaskConfigurator();
        }
        return singleton;
    }

    private TaskConfigurator() throws Exception {
        this.initialize();
        this.taskTypes = TaskModel.getReference().getTaskTypes().copy();
        this.refresh();
        this.manageMySize(TASKCONFVIEWSIZE);
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    private JPopupMenu getSubTaskMenu() {
        if (this.subTaskMenu == null) {
            this.subTaskMenu = new JPopupMenu();
            JMenuItem addItem = new JMenuItem();
            addItem.setText(Resource.getResourceString("Add"));
            addItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.typeList.getSelectedValue() == null) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("Please_select_a_type"));
                        return;
                    }
                    String subtask = JOptionPane.showInputDialog(Resource.getResourceString("New_Subtask_Value"));
                    if (subtask == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.addSubtask((String)TaskConfigurator.this.typeList.getSelectedValue(), subtask);
                    TaskConfigurator.this.refresh();
                }
            });
            this.subTaskMenu.add(addItem);
            JMenuItem changeSubtaskItem = new JMenuItem();
            changeSubtaskItem.setText(Resource.getResourceString("Change"));
            changeSubtaskItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String subtask = JOptionPane.showInputDialog(Resource.getResourceString("New_Subtask_Value"));
                    if (subtask == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.deleteSubtask((String)TaskConfigurator.this.typeList.getSelectedValue(), (String)TaskConfigurator.this.subTaskList.getSelectedValue());
                    TaskConfigurator.this.taskTypes.addSubtask((String)TaskConfigurator.this.typeList.getSelectedValue(), subtask);
                    TaskConfigurator.this.refresh();
                }
            });
            this.subTaskMenu.add(changeSubtaskItem);
            JMenuItem deleteItem = new JMenuItem();
            deleteItem.setText(Resource.getResourceString("Delete"));
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.subTaskList.getSelectedIndex() < 0) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.deleteSubtask((String)TaskConfigurator.this.typeList.getSelectedValue(), (String)TaskConfigurator.this.subTaskList.getSelectedValue());
                    TaskConfigurator.this.refresh();
                }
            });
            this.subTaskMenu.add(deleteItem);
        }
        return this.subTaskMenu;
    }

    private JPopupMenu getNextStateMenu() {
        if (this.nextStateMenu == null) {
            this.nextStateMenu = new JPopupMenu();
            JMenuItem addItem = new JMenuItem();
            addItem.setText(Resource.getResourceString("Add"));
            addItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.stateList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_state"));
                        return;
                    }
                    Collection states = TaskConfigurator.this.taskTypes.getStates((String)TaskConfigurator.this.typeList.getSelectedValue());
                    Object[] sarray = states.toArray();
                    String ns = (String)JOptionPane.showInputDialog(null, Resource.getResourceString("Select_next_state"), Resource.getResourceString("Select_next_state"), 3, null, sarray, sarray[0]);
                    if (ns == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.addNextState((String)TaskConfigurator.this.typeList.getSelectedValue(), (String)TaskConfigurator.this.stateList.getSelectedValue(), ns);
                    TaskConfigurator.this.refresh();
                }
            });
            this.nextStateMenu.add(addItem);
            JMenuItem deleteItem = new JMenuItem();
            deleteItem.setText(Resource.getResourceString("Delete"));
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.nextStateList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_state"));
                        return;
                    }
                    String ns = (String)TaskConfigurator.this.nextStateList.getSelectedValue();
                    TaskConfigurator.this.taskTypes.deleteNextState((String)TaskConfigurator.this.typeList.getSelectedValue(), (String)TaskConfigurator.this.stateList.getSelectedValue(), ns);
                    TaskConfigurator.this.refresh();
                }
            });
            this.nextStateMenu.add(deleteItem);
        }
        return this.nextStateMenu;
    }

    private JPopupMenu getStateMenu() {
        if (this.stateMenu == null) {
            this.stateMenu = new JPopupMenu();
            JMenuItem addItem = new JMenuItem();
            addItem.setText(Resource.getResourceString("Add_State"));
            addItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.typeList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_type"));
                        return;
                    }
                    String newstate = JOptionPane.showInputDialog(Resource.getResourceString("New_State"));
                    if (newstate == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.addState((String)TaskConfigurator.this.typeList.getSelectedValue(), newstate);
                    TaskConfigurator.this.refresh();
                }
            });
            this.stateMenu.add(addItem);
            JMenuItem renameItem = new JMenuItem();
            renameItem.setText(Resource.getResourceString("Rename_State"));
            renameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.stateList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_state"));
                        return;
                    }
                    String newstate = JOptionPane.showInputDialog(Resource.getResourceString("New_State"));
                    if (newstate == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.changeState((String)TaskConfigurator.this.typeList.getSelectedValue(), (String)TaskConfigurator.this.stateList.getSelectedValue(), newstate);
                    TaskConfigurator.this.refresh();
                }
            });
            this.stateMenu.add(renameItem);
            JMenuItem deleteItem = new JMenuItem();
            deleteItem.setText(Resource.getResourceString("Delete_State"));
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.stateList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_state"));
                        return;
                    }
                    int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_") + " " + (String)TaskConfigurator.this.stateList.getSelectedValue(), Resource.getResourceString("Confirm_Delete"), 2);
                    if (ret != 0) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.deleteState((String)TaskConfigurator.this.typeList.getSelectedValue(), (String)TaskConfigurator.this.stateList.getSelectedValue());
                    TaskConfigurator.this.refresh();
                }
            });
            this.stateMenu.add(deleteItem);
        }
        return this.stateMenu;
    }

    private JPopupMenu getTypeMenu() {
        if (this.typeMenu == null) {
            this.typeMenu = new JPopupMenu();
            JMenuItem addItem = new JMenuItem();
            addItem.setText(Resource.getResourceString("Add_Type"));
            addItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newtype = JOptionPane.showInputDialog(Resource.getResourceString("New_Task_Type"));
                    if (newtype == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.addType(newtype);
                    TaskConfigurator.this.refresh();
                }
            });
            this.typeMenu.add(addItem);
            JMenuItem renameItem = new JMenuItem();
            renameItem.setText(Resource.getResourceString("Rename_Type"));
            renameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.typeList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_type"));
                        return;
                    }
                    String newtype = JOptionPane.showInputDialog(Resource.getResourceString("New_Task_Type"));
                    if (newtype == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.changeType((String)TaskConfigurator.this.typeList.getSelectedValue(), newtype);
                    TaskConfigurator.this.refresh();
                }
            });
            this.typeMenu.add(renameItem);
            JMenuItem deleteItem = new JMenuItem();
            deleteItem.setText(Resource.getResourceString("Delete_Type"));
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.typeList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_type"));
                        return;
                    }
                    int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_") + " " + (String)TaskConfigurator.this.typeList.getSelectedValue(), Resource.getResourceString("Confirm_Delete"), 2);
                    if (ret != 0) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.deleteType((String)TaskConfigurator.this.typeList.getSelectedValue());
                    TaskConfigurator.this.refresh();
                }
            });
            this.typeMenu.add(deleteItem);
            JMenuItem initialStateItem = new JMenuItem();
            initialStateItem.setText(Resource.getResourceString("Set_Initial_State"));
            initialStateItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TaskConfigurator.this.typeList.getSelectedIndex() < 0) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Please_select_a_type"));
                        return;
                    }
                    Collection states = TaskConfigurator.this.taskTypes.getStates((String)TaskConfigurator.this.typeList.getSelectedValue());
                    Object[] sarray = states.toArray();
                    String ns = (String)JOptionPane.showInputDialog(null, Resource.getResourceString("Select_initial_state"), Resource.getResourceString("Select_initial_state"), 3, null, sarray, sarray[0]);
                    if (ns == null) {
                        return;
                    }
                    TaskConfigurator.this.taskTypes.setInitialState((String)TaskConfigurator.this.typeList.getSelectedValue(), ns);
                    TaskConfigurator.this.refresh();
                }
            });
            this.typeMenu.add(initialStateItem);
        }
        return this.typeMenu;
    }

    private void initialize() {
        this.setTitle(Resource.getResourceString("Task_State_Editor"));
        this.setSize(564, 219);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(1);
        JPanel listContainerPanel = new JPanel();
        listContainerPanel.setLayout(gridLayout);
        GridLayout gridLayout9 = new GridLayout();
        JPanel taskTypePanel = new JPanel();
        taskTypePanel.setLayout(gridLayout9);
        taskTypePanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getResourceString("Task_Types"), 0, 0, null, null));
        gridLayout9.setRows(1);
        JScrollPane taskTypeScroll = new JScrollPane();
        this.typeList = new JList();
        this.typeList.setSelectionMode(0);
        this.typeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    TaskConfigurator.this.getTypeMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.typeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TaskConfigurator.this.typeSelectHandler();
            }
        });
        taskTypeScroll.setViewportView(this.typeList);
        taskTypeScroll.setHorizontalScrollBarPolicy(31);
        taskTypeScroll.setVerticalScrollBarPolicy(22);
        taskTypePanel.add((Component)taskTypeScroll, null);
        listContainerPanel.add((Component)taskTypePanel, null);
        GridLayout gridLayout10 = new GridLayout();
        JPanel taskStatesPanel = new JPanel();
        taskStatesPanel.setLayout(gridLayout10);
        taskStatesPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getResourceString("States"), 0, 0, null, null));
        gridLayout10.setRows(1);
        JScrollPane stateScroll = new JScrollPane();
        this.stateList = new JList();
        this.stateList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    TaskConfigurator.this.getStateMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.stateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TaskConfigurator.this.stateSelectHandler();
            }
        });
        this.stateList.setCellRenderer(new TypeListRenderer());
        stateScroll.setViewportView(this.stateList);
        stateScroll.setHorizontalScrollBarPolicy(31);
        stateScroll.setVerticalScrollBarPolicy(22);
        taskStatesPanel.add((Component)stateScroll, null);
        listContainerPanel.add((Component)taskStatesPanel, null);
        GridLayout gridLayout8 = new GridLayout();
        JPanel nextStatePanel = new JPanel();
        nextStatePanel.setLayout(gridLayout8);
        nextStatePanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getResourceString("Next_States"), 0, 0, null, null));
        gridLayout8.setRows(1);
        JScrollPane nextStateScroll = new JScrollPane();
        this.nextStateList = new JList();
        this.nextStateList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    TaskConfigurator.this.getNextStateMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        nextStateScroll.setViewportView(this.nextStateList);
        nextStateScroll.setVerticalScrollBarPolicy(22);
        nextStateScroll.setHorizontalScrollBarPolicy(31);
        nextStatePanel.add((Component)nextStateScroll, null);
        listContainerPanel.add((Component)nextStatePanel, null);
        GridLayout gridLayout7 = new GridLayout();
        JPanel subTaskPanel = new JPanel();
        subTaskPanel.setLayout(gridLayout7);
        subTaskPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getResourceString("SubTasks"), 0, 0, null, null));
        gridLayout7.setRows(1);
        this.subTaskList = new JList();
        this.subTaskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    TaskConfigurator.this.getSubTaskMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JScrollPane subTaskScroll = new JScrollPane();
        subTaskScroll.setViewportView(this.subTaskList);
        subTaskScroll.setVerticalScrollBarPolicy(22);
        subTaskScroll.setHorizontalScrollBarPolicy(31);
        subTaskPanel.add((Component)subTaskScroll, null);
        listContainerPanel.add((Component)subTaskPanel, null);
        topPanel.add((Component)listContainerPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton saveButton = new JButton();
        ResourceHelper.setText(saveButton, "Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TaskModel.getReference().saveTaskTypes(TaskConfigurator.this.taskTypes);
                    TaskConfigurator.getReference().dispose();
                }
                catch (Exception ex) {
                    Errmsg.getErrorHandler().errmsg(ex);
                }
            }
        });
        buttonPanel.add((Component)saveButton, null);
        JButton dismissButton = new JButton();
        ResourceHelper.setText(dismissButton, "Dismiss");
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TaskConfigurator.getReference().dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.setDismissButton(dismissButton);
        buttonPanel.add((Component)dismissButton, null);
        topPanel.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 1, 0, 0.0, 0.0));
        this.setContentPane(topPanel);
    }

    @Override
    public void refresh() {
        String typesel = this.typeList.getSelectedValue();
        Vector types = this.taskTypes.getTaskTypes();
        this.typeList.setListData(types);
        if (typesel != null) {
            this.typeList.setSelectedValue(typesel, true);
        }
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    private void stateSelectHandler() {
        String type = this.typeList.getSelectedValue();
        String state = this.stateList.getSelectedValue();
        if (state == null) {
            return;
        }
        Collection states = this.taskTypes.nextStates(type, state);
        states.remove(state);
        this.nextStateList.setListData((String[])states.toArray(new String[0]));
    }

    private void typeSelectHandler() {
        String type = this.typeList.getSelectedValue();
        if (type == null) {
            return;
        }
        Collection states = this.taskTypes.getStates(type);
        this.stateList.setListData((String[])states.toArray(new String[0]));
        String[] cbs = this.taskTypes.getSubTasks(type);
        this.subTaskList.setListData((String[])cbs);
        this.nextStateList.setListData(new Vector());
    }

    private class TypeListRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        public TypeListRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            String init = "";
            if (TaskConfigurator.this.typeList.getSelectedValue() != null) {
                init = TaskConfigurator.this.taskTypes.getInitialState(((String)TaskConfigurator.this.typeList.getSelectedValue()).toString());
            }
            if (!value.toString().equals(init)) {
                return defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            this.setBackground(isSelected ? Color.red : Color.white);
            this.setForeground(isSelected ? Color.white : Color.red);
            return this;
        }
    }
}

