/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.TaskTypes;
import net.sf.borg.model.entity.Project;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.task.TaskListPanel;
import net.sf.borg.ui.task.TaskView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class TaskFilterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox caseSensitiveBox = null;
    private JTextField filterString;
    private JComboBox<String> projectSelector = null;
    private JComboBox<String> statusSelector = null;
    private TaskListPanel taskList = null;

    public TaskFilterPanel() {
        try {
            this.initComponents();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    private void initComponents() throws Exception {
        JButton filterButton = new JButton();
        this.filterString = new JTextField();
        this.setLayout(new GridBagLayout());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel comboBoxPanel = new JPanel();
        comboBoxPanel.setLayout(flowLayout);
        JLabel statusLabel = new JLabel();
        statusLabel.setText(Resource.getResourceString("Status") + ":");
        comboBoxPanel.add((Component)statusLabel, null);
        this.statusSelector = new JComboBox();
        this.setStatuses();
        this.statusSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskFilterPanel.this.refresh();
            }
        });
        comboBoxPanel.add(this.statusSelector, null);
        JLabel projectLabel = new JLabel(Resource.getResourceString("project") + ":");
        JLabel spacer = new JLabel("           ");
        comboBoxPanel.add((Component)spacer, null);
        comboBoxPanel.add((Component)projectLabel, null);
        this.projectSelector = new JComboBox();
        this.loadProjectBox();
        this.projectSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskFilterPanel.this.refresh();
            }
        });
        comboBoxPanel.add(this.projectSelector);
        GridBagConstraints gridBagConstraints15 = GridBagConstraintsFactory.create(0, 0, 2);
        gridBagConstraints15.gridwidth = 3;
        this.add((Component)comboBoxPanel, gridBagConstraints15);
        filterButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Find16.gif")));
        ResourceHelper.setText(filterButton, "Filter:");
        filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskFilterPanel.this.refresh();
            }
        });
        this.add((Component)filterButton, GridBagConstraintsFactory.create(0, 1, 2));
        this.add((Component)this.filterString, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        this.caseSensitiveBox = new JCheckBox();
        this.caseSensitiveBox.setText(Resource.getResourceString("case_sensitive"));
        this.add((Component)this.caseSensitiveBox, GridBagConstraintsFactory.create(2, 1));
        this.taskList = new TaskListPanel();
        JScrollPane taskListScroll = new JScrollPane();
        taskListScroll.setViewportView(this.taskList);
        GridBagConstraints gridBagConstraints11 = GridBagConstraintsFactory.create(0, 2, 1, 1.0, 1.0);
        gridBagConstraints11.gridwidth = 3;
        this.add((Component)taskListScroll, gridBagConstraints11);
        this.refresh();
    }

    private void loadProjectBox() throws Exception {
        this.projectSelector.removeAllItems();
        this.projectSelector.addItem(Resource.getResourceString("All"));
        try {
            Collection projects = TaskModel.getReference().getProjects();
            for (Project p : projects) {
                this.projectSelector.addItem(TaskView.getProjectString(p));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void print() {
        try {
            this.taskList.print();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void refresh() {
        Object o = this.projectSelector.getSelectedItem();
        try {
            this.loadProjectBox();
        }
        catch (Exception e1) {
            Errmsg.getErrorHandler().errmsg(e1);
            return;
        }
        if (o != null) {
            this.projectSelector.setSelectedItem(o);
        }
        String filt = this.filterString.getText();
        String statfilt = (String)this.statusSelector.getSelectedItem();
        String projfilt = (String)this.projectSelector.getSelectedItem();
        this.taskList.setFilterCriteria(projfilt, statfilt, filt, this.caseSensitiveBox.isSelected());
        this.taskList.refresh();
    }

    private void setStatuses() {
        this.statusSelector.addItem(Resource.getResourceString("All_Open"));
        this.statusSelector.addItem(Resource.getResourceString("All"));
        TaskTypes t = TaskModel.getReference().getTaskTypes();
        TreeSet<String> statusSet = new TreeSet<String>();
        Vector types = t.getTaskTypes();
        for (String taskType : types) {
            Collection states = t.getStates(taskType);
            for (String status : states) {
                statusSet.add(status);
            }
        }
        for (String status : statusSet) {
            this.statusSelector.addItem(status);
        }
    }
}

