/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.sf.borg.common.Errmsg;
import net.sf.borg.ui.util.HTMLHyperlinkRange;

public class HTMLDocumentListener
implements DocumentListener {
    private boolean initializingDoc;
    private JEditorPane textPane;
    private List<HTMLHyperlinkRange> hyperlinkList = new ArrayList<HTMLHyperlinkRange>();
    public static final String linkRegex = "\\b(((ht|f)tp(s?)\\:\\/\\/|~\\/|\\/))(\\w+:\\w+@)?(([-\\w]+\\.)+(com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|museum|edu|travel|[a-z]{2}))(:[\\d]{1,5})?(((\\/([-\\w~!$+|.,=]|%[a-f\\d]{2})+)+|\\/)+|\\?|#)?((\\?([-\\w~!$+|.,*:]|%[a-f\\d{2}])+=?([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)(&(?:[-\\w~!$+|.,*:]|%[a-f\\d{2}])+=?([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)*)*(#([-\\w~!$+|.,*:=]|%[a-f\\d]{2})*)?\\b";

    public HTMLDocumentListener(JEditorPane newTextPane) {
        this.textPane = newTextPane;
        this.initializingDoc = false;
    }

    private boolean isExistingLink(int offset) {
        for (HTMLHyperlinkRange hl : this.hyperlinkList) {
            if (hl.getStart() != offset) continue;
            return true;
        }
        return false;
    }

    private boolean isChangeInHyperlink(DocumentEvent evt) {
        for (HTMLHyperlinkRange hl : this.hyperlinkList) {
            if (hl.isInRange(evt.getOffset()) && hl.isInRange(this.textPane.getCaretPosition())) {
                return true;
            }
            if (evt.getType() != DocumentEvent.EventType.INSERT || evt.getOffset() != hl.getEnd()) continue;
            return true;
        }
        return false;
    }

    private void addToHyperlinkList(HTMLHyperlinkRange link) {
        this.hyperlinkList.add(link);
    }

    private void removeFromHyperlinkList(HTMLHyperlinkRange linkRange) {
        this.hyperlinkList.remove(linkRange);
    }

    private void updateHyperlinkList(int offset, int len) {
        for (HTMLHyperlinkRange hl : this.hyperlinkList) {
            if (hl.getStart() < offset) continue;
            hl.setStart(hl.getStart() + len);
        }
    }

    public void resetHyperlinkList(HTMLDocument doc) {
        this.hyperlinkList.clear();
        this.checkForHyperlinks(doc);
    }

    private HTMLHyperlinkRange getHyperlinkRange(int start) {
        for (HTMLHyperlinkRange hl : this.hyperlinkList) {
            if (start < hl.getStart() || start > hl.getEnd()) continue;
            return hl;
        }
        return null;
    }

    private void createHyperlink(HTMLDocument doc, int offset, String url) {
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute("DUMMY_ATTRIBUTE_NAME", "DUMMY_ATTRIBUTE_VALUE");
        doc.setCharacterAttributes(offset, url.length(), a, false);
        Element elem = doc.getCharacterElement(offset);
        String html = "<a href='" + url + "'>" + url + "</a>";
        try {
            doc.setOuterHTML(elem, html);
            this.addToHyperlinkList(new HTMLHyperlinkRange(offset, url.length()));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void invalidateHyperlink(HTMLDocument doc, DocumentEvent evt, boolean wasEnter) {
        HTMLHyperlinkRange linkRange = this.getHyperlinkRange(evt.getOffset());
        Element element = doc.getCharacterElement(linkRange.getStart());
        HTMLDocumentListener.replaceLinkElementWithText(doc, element);
        if (wasEnter) {
            HTMLDocumentListener.replaceLinkElementWithText(doc, doc.getCharacterElement(this.textPane.getCaretPosition()));
        }
        this.removeFromHyperlinkList(linkRange);
    }

    private void checkForHyperlinks(HTMLDocument doc) {
        try {
            Matcher matcher = Pattern.compile(linkRegex).matcher(doc.getText(0, doc.getLength()));
            while (matcher.find()) {
                if (this.isExistingLink(matcher.start())) continue;
                this.createHyperlink(doc, matcher.start(), matcher.group());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setInitializingDoc(boolean newState) {
        this.initializingDoc = newState;
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        final DocumentEvent e = evt;
        this.updateHyperlinkList(e.getOffset(), e.getLength());
        if (this.initializingDoc) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e.getDocument() instanceof HTMLDocument && e.getType() != DocumentEvent.EventType.CHANGE) {
                    HTMLDocument doc = (HTMLDocument)e.getDocument();
                    String text = "";
                    try {
                        text = doc.getText(e.getOffset(), e.getLength());
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    if (HTMLDocumentListener.this.isChangeInHyperlink(e)) {
                        HTMLDocumentListener.this.invalidateHyperlink(doc, e, text.charAt(0) == '\n');
                    } else if (e.getLength() == 1 && (text.charAt(0) == ' ' || text.charAt(0) == '\n' || text.charAt(0) == '\t')) {
                        HTMLDocumentListener.this.checkForHyperlinks(doc);
                    }
                }
            }
        });
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        final DocumentEvent e = evt;
        this.updateHyperlinkList(e.getOffset(), -e.getLength());
        if (this.initializingDoc) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e.getDocument() instanceof HTMLDocument) {
                    HTMLDocument doc = (HTMLDocument)e.getDocument();
                    if (HTMLDocumentListener.this.isChangeInHyperlink(e)) {
                        HTMLDocumentListener.this.invalidateHyperlink(doc, e, false);
                    }
                }
            }
        });
    }

    private static void replaceLinkElementWithText(HTMLDocument doc, Element element) {
        String plaintext = null;
        try {
            Object tag = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (tag != null && tag == HTML.Tag.CONTENT) {
                int startOffset = element.getStartOffset();
                int endOffset = element.getEndOffset();
                int length = endOffset - startOffset;
                plaintext = doc.getText(startOffset, length).trim();
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
        if (plaintext != null) {
            try {
                doc.setOuterHTML(element, plaintext);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }
}

