/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import net.sf.borg.ui.util.DynamicHTMLEditorKit;
import net.sf.borg.ui.util.HTMLDocumentListener;

public class HTMLTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private DynamicHTMLEditorKit kit;
    private HTMLDocumentListener docListener;

    public HTMLTextPane() {
        this.initComponent();
    }

    public HTMLTextPane(Document doc) {
        this.setDocument(doc);
        this.initComponent();
    }

    public void initComponent() {
        this.kit = new DynamicHTMLEditorKit();
        this.docListener = new HTMLDocumentListener(this);
        this.setEditorKit(this.kit);
        this.setContentType("text/html");
        this.setTrueFont(UIManager.getFont("Label.font"));
        this.getDocument().addDocumentListener(this.docListener);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = evt.getURL().toString();
                    try {
                        Desktop.getDesktop().browse(URI.create(url));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    HTMLTextPane.this.setCaretPosition(HTMLTextPane.this.viewToModel(evt.getPoint()));
                }
            }
        });
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.kit != null && this.kit.getHTMLLinkcontroller().getNeedsCursorChange()) {
            super.setCursor(cursor);
        }
    }

    public void setTrueFont(Font font) {
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(bodyRule);
        this.setFont(font);
    }

    public String getPlainText() {
        try {
            return this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setText(String text) {
        try {
            this.docListener.setInitializingDoc(true);
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, text, null);
            if (doc instanceof HTMLDocument) {
                this.docListener.resetHyperlinkList((HTMLDocument)doc);
            }
            this.docListener.setInitializingDoc(false);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

