/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import net.sf.borg.ui.DockableView;

public class JTabbedPaneWithCloseIcons
extends JTabbedPane
implements MouseListener,
MouseMotionListener {
    private static final int ICON_WIDTH = 16;
    private static final long serialVersionUID = 1L;
    private MouseEvent lastMouseEvent;

    public JTabbedPaneWithCloseIcons() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void addTab(String title, Component component) {
        if (component instanceof DockableView) {
            super.addTab(title, new CloseTabIcon(true), component);
        } else {
            super.addTab(title, new CloseTabIcon(false), component);
        }
        this.repaint();
    }

    public void closeClosableTabs() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            Icon icon = this.getIconAt(i);
            if (icon == null) {
                return;
            }
            this.closeTabCommon(i);
        }
    }

    public void closeSelectedTab() {
        int i = this.getSelectedIndex();
        this.closeTabCommon(i);
    }

    private void closeTabCommon(int i) {
        Component c = this.getComponentAt(i);
        if (c instanceof DockableView) {
            ((DockableView)c).close();
        } else {
            this.removeTabAt(i);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabNumber < 0) {
            return;
        }
        CloseTabIcon icon = (CloseTabIcon)this.getIconAt(tabNumber);
        if (icon == null) {
            return;
        }
        if (icon.isMouseOnDelete(e.getX(), e.getY())) {
            this.closeTabCommon(tabNumber);
        } else if (icon.isMouseOnUndock(e.getX(), e.getY())) {
            this.undock();
        }
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseMoved(e);
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (int tabNumber = 0; tabNumber < this.getComponentCount(); ++tabNumber) {
            CloseTabIcon icon = (CloseTabIcon)this.getIconAt(tabNumber);
            if (icon == null) {
                return;
            }
            icon.paintHighlight(e);
        }
        this.lastMouseEvent = e;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastMouseEvent = e;
    }

    public void undock() {
        Component c = this.getSelectedComponent();
        if (c != null && c instanceof DockableView) {
            DockableView dv = (DockableView)c;
            dv.openInFrame();
        }
    }

    private class CloseTabIcon
    implements Icon {
        private Component component;
        private boolean undock;
        private int width;
        private int x_pos;
        private int y_pos;
        private boolean isHighlighted = false;

        public CloseTabIcon(boolean ud) {
            this.undock = ud;
            this.width = this.undock ? 32 : 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        public boolean isMouseOnDelete(int x, int y) {
            Rectangle rect = new Rectangle(this.x_pos + 2, this.y_pos + 2, 12, 12);
            return rect.contains(x, y);
        }

        public boolean contains(int x, int y) {
            Rectangle rect = new Rectangle(this.x_pos, this.y_pos, this.getIconWidth(), this.getIconHeight());
            return rect.contains(x, y);
        }

        public boolean isMouseOnUndock(int x, int y) {
            if (!this.undock) {
                return false;
            }
            Rectangle rect = new Rectangle(this.x_pos + 16 + 2, this.y_pos + 2, 12, 12);
            return rect.contains(x, y);
        }

        private void paintHighlight(boolean highlightDelete, boolean highlightUndock, Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.black);
            this.isHighlighted = false;
            if (highlightDelete) {
                g2.setColor(Color.red);
                this.isHighlighted = true;
            }
            g2.drawLine(this.x_pos + 4, this.y_pos + 5, this.x_pos + 16 - 5, this.y_pos + 16 - 4);
            g2.drawLine(this.x_pos + 4, this.y_pos + 4, this.x_pos + 16 - 4, this.y_pos + 16 - 4);
            g2.drawLine(this.x_pos + 5, this.y_pos + 4, this.x_pos + 16 - 4, this.y_pos + 16 - 5);
            g2.drawLine(this.x_pos + 16 - 4, this.y_pos + 5, this.x_pos + 5, this.y_pos + 16 - 4);
            g2.drawLine(this.x_pos + 16 - 4, this.y_pos + 4, this.x_pos + 4, this.y_pos + 16 - 4);
            g2.drawLine(this.x_pos + 16 - 5, this.y_pos + 4, this.x_pos + 4, this.y_pos + 16 - 5);
            if (this.undock) {
                g2.setColor(Color.black);
                if (highlightUndock) {
                    g2.setColor(Color.red);
                    this.isHighlighted = true;
                }
                g2.drawRect(this.x_pos + 16 + 4, this.y_pos + 4, 8, 8);
                g2.drawRect(this.x_pos + 16 + 5, this.y_pos + 5, 6, 6);
            }
        }

        public void paintHighlight(MouseEvent e) {
            if (this.component == null) {
                return;
            }
            if (!this.contains(e.getX(), e.getY())) {
                if (this.isHighlighted) {
                    this.paintHighlight(false, false, this.component.getGraphics());
                }
                return;
            }
            this.paintHighlight(this.isMouseOnDelete(e.getX(), e.getY()), this.isMouseOnUndock(e.getX(), e.getY()), this.component.getGraphics());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.x_pos = x;
            this.y_pos = y;
            this.component = c;
            if (JTabbedPaneWithCloseIcons.this.lastMouseEvent != null) {
                this.paintHighlight(this.isMouseOnDelete(JTabbedPaneWithCloseIcons.this.lastMouseEvent.getX(), JTabbedPaneWithCloseIcons.this.lastMouseEvent.getY()), this.isMouseOnUndock(JTabbedPaneWithCloseIcons.this.lastMouseEvent.getX(), JTabbedPaneWithCloseIcons.this.lastMouseEvent.getY()), g);
            } else {
                this.paintHighlight(false, false, g);
            }
        }
    }
}

