/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.FontUIResource;
import net.sf.borg.common.Resource;

public class NwFontChooserS
extends JDialog {
    private static final long serialVersionUID = 1L;
    String[] styleList = new String[]{"Plain", "Bold", "Italic"};
    String[] sizeList = new String[]{"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "27", "30", "34", "39", "45", "51", "60"};
    NwList StyleList;
    NwList FontList;
    NwList SizeList;
    static JLabel Sample = new JLabel();
    boolean ob = false;

    private NwFontChooserS(Frame parent, boolean modal, Font fontIn) {
        super(parent, modal);
        Font font = fontIn;
        this.initAll();
        this.setTitle(Resource.getResourceString("font_chooser"));
        if (font == null) {
            font = Sample.getFont();
        }
        this.FontList.setSelectedItem(font.getName());
        this.SizeList.setSelectedItem(font.getSize() + "");
        this.StyleList.setSelectedItem(this.styleList[font.getStyle()]);
    }

    public static Font showDialog(Frame parent, String s, Font font) {
        NwFontChooserS fd = new NwFontChooserS(parent, true, font);
        if (s != null) {
            fd.setTitle(s);
        }
        fd.setResizable(false);
        fd.setVisible(true);
        Font fo = null;
        if (fd.ob) {
            fo = Sample.getFont();
        }
        fd.dispose();
        return fo;
    }

    private void initAll() {
        this.getContentPane().setLayout(null);
        this.setBounds(50, 50, 450, 450);
        this.addLists();
        this.addButtons();
        Sample.setBounds(10, 320, 415, 25);
        Sample.setForeground(Color.black);
        this.getContentPane().add(Sample);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NwFontChooserS.this.setVisible(false);
            }
        });
    }

    private void addLists() {
        this.FontList = new NwList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.StyleList = new NwList(this.styleList);
        this.SizeList = new NwList(this.sizeList);
        this.FontList.setBounds(10, 10, 260, 295);
        this.StyleList.setBounds(280, 10, 80, 295);
        this.SizeList.setBounds(370, 10, 40, 295);
        this.getContentPane().add(this.FontList);
        this.getContentPane().add(this.StyleList);
        this.getContentPane().add(this.SizeList);
    }

    private void addButtons() {
        JButton ok = new JButton(Resource.getResourceString("OK"));
        ok.setMargin(new Insets(0, 0, 0, 0));
        JButton ca = new JButton(Resource.getResourceString("Cancel"));
        ca.setMargin(new Insets(0, 0, 0, 0));
        ok.setBounds(260, 350, 70, 20);
        ok.setFont(new Font(" ", 1, 11));
        ca.setBounds(340, 350, 70, 20);
        ca.setFont(new Font(" ", 1, 12));
        this.getContentPane().add(ok);
        this.getContentPane().add(ca);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NwFontChooserS.this.setVisible(false);
                NwFontChooserS.this.ob = true;
            }
        });
        ca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NwFontChooserS.this.setVisible(false);
                NwFontChooserS.this.ob = false;
            }
        });
    }

    private void showSample() {
        int g = 0;
        try {
            g = Integer.parseInt(this.SizeList.getSelectedValue());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String st = this.StyleList.getSelectedValue();
        int s = 0;
        if (st.equalsIgnoreCase("Bold")) {
            s = 1;
        }
        if (st.equalsIgnoreCase("Italic")) {
            s = 2;
        }
        Sample.setFont(new Font(this.FontList.getSelectedValue(), s, g));
        Sample.setText("The quick brown fox jumped over the lazy dog.");
    }

    public static String fontString(Font font) {
        String fs = font.getFamily();
        if (!font.isPlain()) {
            fs = fs + "-";
            if (font.isBold()) {
                fs = fs + "BOLD";
            }
            if (font.isItalic()) {
                fs = fs + "ITALIC";
            }
        }
        fs = fs + "-" + font.getSize();
        return fs;
    }

    public static void setDefaultFont(Font f) {
        FontUIResource fui = new FontUIResource(f);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, fui);
        }
    }

    public static void main(String[] args) {
        Font font = null;
        font = NwFontChooserS.showDialog(null, null, null);
        System.out.println(NwFontChooserS.fontString(font));
    }

    private class NwList
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JList<String> jl;
        JScrollPane sp;
        JLabel jt;
        String si = " ";

        public NwList(String[] values) {
            this.setLayout(null);
            this.jl = new JList<String>(values);
            this.sp = new JScrollPane(this.jl);
            this.jt = new JLabel();
            this.jt.setBackground(Color.white);
            this.jt.setForeground(Color.black);
            this.jt.setOpaque(true);
            this.jt.setBorder(new JTextField().getBorder());
            this.jt.setFont(this.getFont());
            this.jl.setBounds(0, 0, 100, 1000);
            this.jl.setBackground(Color.white);
            this.jl.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    NwList.this.jt.setText(NwList.this.jl.getSelectedValue());
                    NwList.this.si = NwList.this.jl.getSelectedValue();
                    NwFontChooserS.this.showSample();
                }
            });
            this.add(this.sp);
            this.add(this.jt);
        }

        public String getSelectedValue() {
            return this.si;
        }

        public void setSelectedItem(String s) {
            this.jl.setSelectedValue(s, true);
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.sp.setBounds(0, y + 12, w, h - 23);
            this.sp.revalidate();
            this.jt.setBounds(0, 0, w, 20);
        }
    }
}

