/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import net.sf.borg.common.EncryptionHelper;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;

public class PasswordHelper {
    private static PasswordHelper singleton = null;
    private String password = null;
    private Date creationDate = new Date();

    public static PasswordHelper getReference() {
        if (singleton == null) {
            singleton = new PasswordHelper();
        }
        return singleton;
    }

    public String getPassword() throws Exception {
        int pw_ttl = Prefs.getIntPref(PrefName.PASSWORD_TTL);
        Date expirationDate = new Date();
        expirationDate.setTime(this.creationDate.getTime() + (long)(1000 * pw_ttl));
        if (this.password == null || expirationDate.before(new Date())) {
            JPasswordField jpf;
            JLabel label = new JLabel(Resource.getResourceString("EnterPasswordToDecrypt"));
            int result = JOptionPane.showConfirmDialog(null, new Object[]{label, jpf = new JPasswordField()}, Resource.getResourceString("Password"), 2);
            if (result == 2 || result == -1) {
                this.password = null;
            } else {
                this.password = new String(jpf.getPassword());
                try {
                    new EncryptionHelper(Prefs.getPref(PrefName.KEYSTORE), this.password);
                    this.creationDate = new Date();
                }
                catch (Exception e) {
                    this.password = null;
                    throw e;
                }
            }
        }
        return this.password;
    }
}

