/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import net.sf.borg.common.Resource;

public class PopupMenuHelper {
    private JPopupMenu popup;
    private JComponent component;

    public static JPopupMenu createPopupMenu(Entry[] entries) {
        JPopupMenu p = new JPopupMenu();
        for (int i = 0; i < entries.length; ++i) {
            Entry entry = entries[i];
            JMenuItem mnuitm = new JMenuItem();
            p.add(mnuitm);
            mnuitm.setText(Resource.getResourceString(entry.getResourceKey()));
            mnuitm.addActionListener(entry.getListener());
        }
        return p;
    }

    public PopupMenuHelper(final JComponent c, Entry[] entries) {
        this.component = c;
        this.popup = PopupMenuHelper.createPopupMenu(entries);
        c.addMouseListener(new MyPopupListener());
        c.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 525: {
                        if (PopupMenuHelper.this.component instanceof JTable) {
                            JTable table = (JTable)PopupMenuHelper.this.component;
                            int[] selIndices = table.getSelectedRows();
                            if (selIndices.length == 0) {
                                return;
                            }
                            int rowIndex = selIndices[0];
                            Rectangle rct = table.getCellRect(rowIndex, 0, false);
                            PopupMenuHelper.this.popup.show(c, rct.x, rct.y + rct.height);
                            break;
                        }
                        if (!(PopupMenuHelper.this.component instanceof JList)) break;
                        JList t = (JList)PopupMenuHelper.this.component;
                        int index = t.getSelectedIndex();
                        if (index == -1) {
                            return;
                        }
                        Rectangle rct = t.getCellBounds(index, index);
                        PopupMenuHelper.this.popup.show(c, rct.x, rct.y + rct.height);
                    }
                }
            }
        });
    }

    private class MyPopupListener
    extends MouseAdapter {
        private MyPopupListener() {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int index;
                JComponent t;
                int row;
                if (PopupMenuHelper.this.component instanceof JTable && (row = ((JTable)(t = (JTable)PopupMenuHelper.this.component)).rowAtPoint(e.getPoint())) != -1 && !((JTable)t).isRowSelected(row)) {
                    ((JTable)t).getSelectionModel().setSelectionInterval(row, row);
                }
                if (PopupMenuHelper.this.component instanceof JList && (index = ((JList)(t = (JList)PopupMenuHelper.this.component)).locationToIndex(e.getPoint())) != -1 && !((JList)t).isSelectedIndex(index)) {
                    ((JList)t).setSelectedIndex(index);
                }
                PopupMenuHelper.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }
    }

    public static class Entry {
        private ActionListener listener;
        private String resourceKey;

        public Entry(ActionListener listener, String resourceKey) {
            this.listener = listener;
            this.resourceKey = resourceKey;
        }

        public final ActionListener getListener() {
            return this.listener;
        }

        public final String getResourceKey() {
            return this.resourceKey;
        }
    }
}

