/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.CalendarStore;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectStore;
import net.fortuna.ical4j.connector.dav.CalDavCalendarCollection;
import net.fortuna.ical4j.connector.dav.CalDavConstants;
import net.fortuna.ical4j.connector.dav.DavConstants;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.connector.dav.ScheduleResponse;
import net.fortuna.ical4j.connector.dav.method.PrincipalPropertySearchInfo;
import net.fortuna.ical4j.connector.dav.method.PrincipalPropertySearchMethod;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.UidGenerator;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.report.ExpandPropertyReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CalDavCalendarStore
extends AbstractDavObjectStore<CalDavCalendarCollection>
implements CalendarStore<CalDavCalendarCollection> {
    private final String prodId;
    private String displayName;

    public CalDavCalendarStore(String prodId, URL url, PathResolver pathResolver) {
        super(url, pathResolver);
        this.prodId = prodId;
    }

    @Override
    public CalDavCalendarCollection addCollection(String id) throws ObjectStoreException {
        CalDavCalendarCollection collection = new CalDavCalendarCollection(this, id);
        try {
            collection.create();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return collection;
    }

    @Override
    public CalDavCalendarCollection addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        CalDavCalendarCollection collection = new CalDavCalendarCollection(this, id, displayName, description);
        try {
            collection.create();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return collection;
    }

    public CalDavCalendarCollection addCollection(String id, DavPropertySet properties) throws ObjectStoreException {
        CalDavCalendarCollection collection = new CalDavCalendarCollection(this, id, properties);
        try {
            collection.create();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return collection;
    }

    @Override
    public CalDavCalendarCollection getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        try {
            DavPropertyNameSet principalsProps = CalDavCalendarCollection.propertiesForFetch();
            PropFindMethod getMethod = new PropFindMethod(id, principalsProps, 0);
            this.getClient().execute((HttpMethodBase)getMethod);
            MultiStatus multiStatus = getMethod.getResponseBodyAsMultiStatus();
            MultiStatusResponse[] responses = multiStatus.getResponses();
            return CalDavCalendarCollection.collectionsFromResponse(this, responses).get(0);
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DavException e) {
            e.printStackTrace();
        }
        throw new ObjectNotFoundException("Collection with id: [" + id + "] not found");
    }

    public CalendarCollection merge(String id, CalendarCollection calendar) {
        return null;
    }

    public String findCalendarHomeSet() throws ParserConfigurationException, IOException, DavException {
        String propfindUri = this.getHostURL() + this.pathResolver.getPrincipalPath(this.getUserName());
        return this.findCalendarHomeSet(propfindUri);
    }

    protected String findCalendarHomeSet(String propfindUri) throws ParserConfigurationException, IOException, DavException {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(CalDavPropertyName.CALENDAR_HOME_SET);
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        PropFindMethod method = new PropFindMethod(propfindUri, principalsProps, 0);
        this.getClient().execute((HttpMethodBase)method);
        MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] responses = multiStatus.getResponses();
        int i = 0;
        while (i < responses.length) {
            int j = 0;
            while (j < responses[i].getStatus().length) {
                Status status = responses[i].getStatus()[j];
                DavPropertyIterator iNames = responses[i].getProperties(status.getStatusCode()).iterator();
                while (iNames.hasNext()) {
                    Node child;
                    DavProperty name = iNames.nextProperty();
                    if (!name.getName().getName().equals("calendar-home-set") || !CalDavConstants.CALDAV_NAMESPACE.isSame(name.getName().getNamespace().getURI())) continue;
                    if (name.getValue() instanceof ArrayList) {
                        for (Object child2 : (ArrayList)name.getValue()) {
                            if (!(child2 instanceof Element)) continue;
                            String calendarHomeSetUri = ((Element)child2).getTextContent();
                            if (!calendarHomeSetUri.endsWith("/")) {
                                calendarHomeSetUri = String.valueOf(calendarHomeSetUri) + "/";
                            }
                            return calendarHomeSetUri;
                        }
                    }
                    if (!(name.getValue() instanceof Node) || !((child = (Node)name.getValue()) instanceof Element)) continue;
                    String calendarHomeSetUri = ((Element)child).getTextContent();
                    if (!calendarHomeSetUri.endsWith("/")) {
                        calendarHomeSetUri = String.valueOf(calendarHomeSetUri) + "/";
                    }
                    return calendarHomeSetUri;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<CalDavCalendarCollection> getCollections() throws ObjectStoreException, ObjectNotFoundException {
        try {
            String calHomeSetUri = this.findCalendarHomeSet();
            if (calHomeSetUri == null) {
                throw new ObjectNotFoundException("No calendar-home-set attribute found for the user");
            }
            String urlForcalendarHomeSet = this.getHostURL() + calHomeSetUri;
            return this.getCollectionsForHomeSet(this, urlForcalendarHomeSet);
        }
        catch (DavException de) {
            throw new ObjectStoreException(de);
        }
        catch (IOException ioe) {
            throw new ObjectStoreException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new ObjectStoreException(pce);
        }
    }

    protected List<CalDavCalendarCollection> getCollectionsForHomeSet(CalDavCalendarStore store, String urlForcalendarHomeSet) throws IOException, DavException {
        new ArrayList();
        DavPropertyNameSet principalsProps = CalDavCalendarCollection.propertiesForFetch();
        PropFindMethod method = new PropFindMethod(urlForcalendarHomeSet, principalsProps, 1);
        this.getClient().execute((HttpMethodBase)method);
        MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] responses = multiStatus.getResponses();
        return CalDavCalendarCollection.collectionsFromResponse(store, responses);
    }

    protected List<CalDavCalendarCollection> getDelegateCollections(DavProperty<?> proxyDavProperty) throws ParserConfigurationException, IOException, DavException {
        ArrayList response;
        Object propertyValue;
        ArrayList<CalDavCalendarCollection> delegatedCollections = new ArrayList<CalDavCalendarCollection>();
        if (proxyDavProperty != null && (propertyValue = proxyDavProperty.getValue()) instanceof ArrayList && (response = (ArrayList)proxyDavProperty.getValue()) != null) {
            for (Node objectInArray : response) {
                DefaultDavProperty newProperty;
                if (!(objectInArray instanceof Element) || !(newProperty = DefaultDavProperty.createFromXml((Element)((Element)objectInArray))).getName().getName().equals("response") || !newProperty.getName().getNamespace().equals((Object)DavConstants.NAMESPACE)) continue;
                ArrayList responseChilds = (ArrayList)newProperty.getValue();
                for (Node responseChild : responseChilds) {
                    DefaultDavProperty responseChildElement;
                    if (!(responseChild instanceof Element) || !(responseChildElement = DefaultDavProperty.createFromXml((Element)((Element)responseChild))).getName().getName().equals("propstat")) continue;
                    ArrayList propStatChilds = (ArrayList)responseChildElement.getValue();
                    for (Node propStatChild : propStatChilds) {
                        DefaultDavProperty propStatChildElement;
                        if (!(propStatChild instanceof Element) || !(propStatChildElement = DefaultDavProperty.createFromXml((Element)((Element)propStatChild))).getName().getName().equals("prop")) continue;
                        ArrayList propChilds = (ArrayList)propStatChildElement.getValue();
                        for (Node propChild : propChilds) {
                            DefaultDavProperty propChildElement;
                            if (!(propChild instanceof Element) || !(propChildElement = DefaultDavProperty.createFromXml((Element)((Element)propChild))).getName().equals((Object)SecurityConstants.PRINCIPAL_URL)) continue;
                            ArrayList principalUrlChilds = (ArrayList)propChildElement.getValue();
                            for (Node principalUrlChild : principalUrlChilds) {
                                DefaultDavProperty principalUrlElement;
                                if (!(principalUrlChild instanceof Element) || !(principalUrlElement = DefaultDavProperty.createFromXml((Element)((Element)principalUrlChild))).getName().getName().equals("href")) continue;
                                String principalsUri = (String)principalUrlElement.getValue();
                                String urlForcalendarHomeSet = this.findCalendarHomeSet(this.getHostURL() + principalsUri);
                                delegatedCollections.addAll(this.getCollectionsForHomeSet(this, urlForcalendarHomeSet));
                            }
                        }
                    }
                }
            }
        }
        return delegatedCollections;
    }

    public List<CalDavCalendarCollection> getDelegatedCollections() throws Exception {
        ArrayList<CalDavCalendarCollection> collections = new ArrayList<CalDavCalendarCollection>();
        collections.addAll(this.getWriteDelegatedCollections());
        collections.addAll(this.getReadOnlyDelegatedCollections());
        return collections;
    }

    protected List<CalDavCalendarCollection> getDelegatedCollections(String type) throws Exception {
        ArrayList<CalDavCalendarCollection> collections = new ArrayList<CalDavCalendarCollection>();
        String methodUri = this.pathResolver.getPrincipalPath(this.getUserName());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element writeDisplayNameProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        writeDisplayNameProperty.setAttribute("name", "displayname");
        Element writePrincipalUrlProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        writePrincipalUrlProperty.setAttribute("name", SecurityConstants.PRINCIPAL_URL.getName());
        Element writeUserAddressSetProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        writeUserAddressSetProperty.setAttribute("name", "calendar-user-address-set");
        writeUserAddressSetProperty.setAttribute("namespace", CalDavConstants.CALDAV_NAMESPACE.getURI());
        Element proxyWriteForElement = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        proxyWriteForElement.setAttribute("name", type);
        proxyWriteForElement.setAttribute("namespace", CalDavConstants.CS_NAMESPACE.getURI());
        proxyWriteForElement.appendChild(writeDisplayNameProperty);
        proxyWriteForElement.appendChild(writePrincipalUrlProperty);
        proxyWriteForElement.appendChild(writeUserAddressSetProperty);
        ReportInfo rinfo = new ReportInfo(ReportType.register((String)"expand-property", (Namespace)DeltaVConstants.NAMESPACE, ExpandPropertyReport.class), 0);
        rinfo.setContentElement(proxyWriteForElement);
        ReportMethod method = new ReportMethod(methodUri, rinfo);
        this.getClient().execute(this.getClient().hostConfiguration, (DavMethodBase)method);
        if (method.getStatusCode() == 207) {
            MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
            MultiStatusResponse[] responses = multiStatus.getResponses();
            int i = 0;
            while (i < responses.length) {
                DavPropertySet properties = responses[i].getProperties(200);
                DavProperty writeForProperty = properties.get("calendar-proxy-write-for", CalDavConstants.CS_NAMESPACE);
                List<CalDavCalendarCollection> writeCollections = this.getDelegateCollections(writeForProperty);
                for (CalDavCalendarCollection writeCollection : writeCollections) {
                    writeCollection.setReadOnly(false);
                    collections.add(writeCollection);
                }
                DavProperty readForProperty = properties.get("calendar-proxy-read-for", CalDavConstants.CS_NAMESPACE);
                List<CalDavCalendarCollection> readCollections = this.getDelegateCollections(readForProperty);
                for (CalDavCalendarCollection readCollection : readCollections) {
                    readCollection.setReadOnly(true);
                    collections.add(readCollection);
                }
                ++i;
            }
        }
        return collections;
    }

    public List<CalDavCalendarCollection> getWriteDelegatedCollections() throws Exception {
        List<CalDavCalendarCollection> collections = this.getDelegatedCollections("calendar-proxy-write-for");
        return collections;
    }

    public List<CalDavCalendarCollection> getReadOnlyDelegatedCollections() throws Exception {
        List<CalDavCalendarCollection> collections = this.getDelegatedCollections("calendar-proxy-read-for");
        return collections;
    }

    @Override
    public CalDavCalendarCollection removeCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        CalDavCalendarCollection collection = this.getCollection(id);
        try {
            collection.delete();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return collection;
    }

    final String getProdId() {
        return this.prodId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String findScheduleOutbox() throws ParserConfigurationException, IOException, DavException {
        return this.findInboxOrOutbox(CalDavPropertyName.SCHEDULE_OUTBOX_URL);
    }

    public String findScheduleInbox() throws ParserConfigurationException, IOException, DavException {
        return this.findInboxOrOutbox(CalDavPropertyName.SCHEDULE_INBOX_URL);
    }

    protected String findInboxOrOutbox(DavPropertyName type) throws ParserConfigurationException, IOException, DavException {
        String propfindUri = String.valueOf(this.getClient().hostConfiguration.getHostURL()) + this.pathResolver.getPrincipalPath(this.getUserName());
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(type);
        PropFindMethod method = new PropFindMethod(propfindUri, principalsProps, 0);
        method.setDoAuthentication(true);
        this.getClient().execute(this.getClient().hostConfiguration, (DavMethodBase)method);
        MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] responses = multiStatus.getResponses();
        int i = 0;
        while (i < responses.length) {
            int j = 0;
            while (j < responses[i].getStatus().length) {
                Status status = responses[i].getStatus()[j];
                DavPropertyIterator iNames = responses[i].getProperties(status.getStatusCode()).iterator();
                while (iNames.hasNext()) {
                    Node child;
                    DavProperty name = iNames.nextProperty();
                    if (!name.getName().getName().equals(type.getName()) || !type.getNamespace().isSame(name.getName().getNamespace().getURI())) continue;
                    if (name.getValue() instanceof ArrayList) {
                        for (Object child2 : (ArrayList)name.getValue()) {
                            if (!(child2 instanceof Element)) continue;
                            String calendarHomeSetUri = ((Element)child2).getTextContent();
                            if (!calendarHomeSetUri.endsWith("/")) {
                                calendarHomeSetUri = String.valueOf(calendarHomeSetUri) + "/";
                            }
                            return calendarHomeSetUri;
                        }
                    }
                    if (name.getValue() instanceof Node && (child = (Node)name.getValue()) instanceof Element) {
                        String calendarHomeSetUri = ((Element)child).getTextContent();
                        if (!calendarHomeSetUri.endsWith("/")) {
                            calendarHomeSetUri = String.valueOf(calendarHomeSetUri) + "/";
                        }
                        return calendarHomeSetUri;
                    }
                    if (!(name.getValue() instanceof String)) continue;
                    String calendarHomeSetUri = (String)name.getValue();
                    if (!calendarHomeSetUri.endsWith("/")) {
                        calendarHomeSetUri = String.valueOf(calendarHomeSetUri) + "/";
                    }
                    return calendarHomeSetUri;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<ScheduleResponse> findFreeBusyInfoForAttendees(Organizer organizer, ArrayList<Attendee> attendees, DtStart startTime, DtEnd endTime) throws ParserConfigurationException, IOException, DavException, ParseException, ParserException, SAXException {
        ArrayList<ScheduleResponse> responses;
        block6: {
            Random ramdomizer = new Random();
            responses = new ArrayList<ScheduleResponse>();
            PostMethod postMethod = new PostMethod(this.findScheduleOutbox());
            postMethod.addRequestHeader(new Header("Content-Type", "text/calendar; charset=utf-8"));
            Calendar calendar = new Calendar();
            calendar.getProperties().add((Property)new ProdId(this.getProdId()));
            calendar.getProperties().add((Property)Version.VERSION_2_0);
            calendar.getProperties().add((Property)CalScale.GREGORIAN);
            calendar.getProperties().add((Property)Method.REQUEST);
            VFreeBusy fbComponent = new VFreeBusy();
            fbComponent.getProperties().add((Property)organizer);
            postMethod.addRequestHeader(new Header("Originator", organizer.getValue()));
            fbComponent.getProperties().add((Property)startTime);
            fbComponent.getProperties().add((Property)endTime);
            String strAttendee = "";
            if (attendees != null) {
                for (Attendee attendee : attendees) {
                    fbComponent.getProperties().add((Property)attendee);
                    strAttendee = String.valueOf(strAttendee) + attendee.getValue() + ",";
                }
                strAttendee = strAttendee.substring(0, strAttendee.length() - 1);
                postMethod.addRequestHeader(new Header("Recipient", strAttendee));
            }
            UidGenerator ug = new UidGenerator(String.valueOf(ramdomizer.nextInt()));
            fbComponent.getProperties().add((Property)ug.generateUid());
            calendar.getComponents().add((Component)fbComponent);
            postMethod.setRequestBody(calendar.toString());
            int httpCode = this.getClient().execute((HttpMethodBase)postMethod);
            if (httpCode >= 300) break block6;
            if (postMethod.getResponseContentLength() < 0L && "chunked".equals(postMethod.getResponseHeader("Transfer-Encoding"))) {
                int c;
                ChunkedInputStream chunkedIS = new ChunkedInputStream(postMethod.getResponseBodyAsStream(), (HttpMethod)postMethod);
                while ((c = chunkedIS.read()) != -1) {
                    System.out.println(c);
                }
            } else {
                DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
                xmlFactory.setNamespaceAware(true);
                DocumentBuilder xmlBuilder = xmlFactory.newDocumentBuilder();
                Document xmlDoc = xmlBuilder.parse(postMethod.getResponseBodyAsStream());
                NodeList nodes = xmlDoc.getElementsByTagNameNS(CalDavConstants.CALDAV_NAMESPACE.getURI(), "response");
                int nodeItr = 0;
                while (nodeItr < nodes.getLength()) {
                    responses.add(new ScheduleResponse((Element)nodes.item(nodeItr)));
                    ++nodeItr;
                }
            }
        }
        return responses;
    }

    public List<Attendee> getIndividuals(String nameToSearch) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getUserTypes(CuType.INDIVIDUAL, nameToSearch);
    }

    public List<Attendee> getRooms(String nameToSearch) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getUserTypes(CuType.ROOM, nameToSearch);
    }

    public List<Attendee> getAllRooms() throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getAllPrincipalsForType(CuType.ROOM);
    }

    public List<Attendee> getAllResources() throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getAllPrincipalsForType(CuType.RESOURCE);
    }

    protected Element propertiesForPropSearch(Document document) {
        Element firstNameProperty = DomUtil.createElement((Document)document, (String)"first-name", (Namespace)CalDavConstants.CS_NAMESPACE);
        Element recordTypeProperty = DomUtil.createElement((Document)document, (String)"record-type", (Namespace)CalDavConstants.CS_NAMESPACE);
        Element calUserAddressSetProperty = DomUtil.createElement((Document)document, (String)"calendar-user-address-set", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        Element lastNameProperty = DomUtil.createElement((Document)document, (String)"last-name", (Namespace)CalDavConstants.CS_NAMESPACE);
        Element principalUrlProperty = DomUtil.createElement((Document)document, (String)"principal-URL", (Namespace)CalDavConstants.NAMESPACE);
        Element calUserTypeProperty = DomUtil.createElement((Document)document, (String)"calendar-user-type", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        Element displayNameForProperty = DomUtil.createElement((Document)document, (String)"displayname", (Namespace)CalDavConstants.NAMESPACE);
        Element emailAddressSetProperty = DomUtil.createElement((Document)document, (String)"email-address-set", (Namespace)CalDavConstants.CS_NAMESPACE);
        Element properties = DomUtil.createElement((Document)document, (String)"prop", (Namespace)DavConstants.NAMESPACE);
        properties.appendChild(firstNameProperty);
        properties.appendChild(recordTypeProperty);
        properties.appendChild(calUserAddressSetProperty);
        properties.appendChild(lastNameProperty);
        properties.appendChild(principalUrlProperty);
        properties.appendChild(calUserTypeProperty);
        properties.appendChild(displayNameForProperty);
        properties.appendChild(emailAddressSetProperty);
        return properties;
    }

    public List<Attendee> getAllPrincipalsForType(CuType type) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element displayName = DomUtil.createElement((Document)document, (String)"calendar-user-type", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        Element displayNameProperty = DomUtil.createElement((Document)document, (String)"prop", (Namespace)DavConstants.NAMESPACE);
        displayNameProperty.appendChild(displayName);
        Element containsMatch = DomUtil.createElement((Document)document, (String)"match", (Namespace)DavConstants.NAMESPACE);
        containsMatch.setAttribute("match-type", "equals");
        containsMatch.setTextContent(type.getValue());
        Element propertySearchDisplayName = DomUtil.createElement((Document)document, (String)"property-search", (Namespace)DavConstants.NAMESPACE);
        propertySearchDisplayName.appendChild(displayNameProperty);
        propertySearchDisplayName.appendChild(containsMatch);
        Element properties = this.propertiesForPropSearch(document);
        Element principalPropSearch = DomUtil.createElement((Document)document, (String)"principal-property-search", (Namespace)DavConstants.NAMESPACE);
        principalPropSearch.setAttribute("type", type.getValue());
        principalPropSearch.setAttribute("test", "anyof");
        principalPropSearch.appendChild(propertySearchDisplayName);
        principalPropSearch.appendChild(properties);
        return this.executePrincipalPropSearch(principalPropSearch);
    }

    protected List<Attendee> getUserTypes(CuType type, String nameToSearch) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element displayName = DomUtil.createElement((Document)document, (String)"displayname", (Namespace)DavConstants.NAMESPACE);
        Element displayNameProperty = DomUtil.createElement((Document)document, (String)"prop", (Namespace)DavConstants.NAMESPACE);
        displayNameProperty.appendChild(displayName);
        Element containsMatch = DomUtil.createElement((Document)document, (String)"match", (Namespace)DavConstants.NAMESPACE);
        containsMatch.setAttribute("match-type", "contains");
        containsMatch.setTextContent(nameToSearch);
        Element propertySearchDisplayName = DomUtil.createElement((Document)document, (String)"property-search", (Namespace)DavConstants.NAMESPACE);
        propertySearchDisplayName.appendChild(displayNameProperty);
        propertySearchDisplayName.appendChild(containsMatch);
        Element emailAddressSet = DomUtil.createElement((Document)document, (String)"email-address-set", (Namespace)CalDavConstants.CS_NAMESPACE);
        Element emailSetProperty = DomUtil.createElement((Document)document, (String)"prop", (Namespace)DavConstants.NAMESPACE);
        emailSetProperty.appendChild(emailAddressSet);
        Element startsWith = DomUtil.createElement((Document)document, (String)"match", (Namespace)DavConstants.NAMESPACE);
        startsWith.setAttribute("match-type", "starts-with");
        if (startsWith != null) {
            startsWith.setTextContent(nameToSearch);
        }
        Element propertySearchEmail = DomUtil.createElement((Document)document, (String)"property-search", (Namespace)DavConstants.NAMESPACE);
        propertySearchEmail.setTextContent(nameToSearch);
        propertySearchEmail.appendChild(emailSetProperty);
        propertySearchEmail.appendChild(startsWith);
        Element properties = this.propertiesForPropSearch(document);
        Element principalPropSearch = DomUtil.createElement((Document)document, (String)"principal-property-search", (Namespace)DavConstants.NAMESPACE);
        principalPropSearch.setAttribute("type", type.getValue());
        principalPropSearch.setAttribute("test", "anyof");
        principalPropSearch.appendChild(propertySearchDisplayName);
        principalPropSearch.appendChild(propertySearchEmail);
        principalPropSearch.appendChild(properties);
        return this.executePrincipalPropSearch(principalPropSearch);
    }

    protected List<Attendee> executePrincipalPropSearch(Element principalPropSearch) throws DavException, IOException, URISyntaxException {
        PrincipalPropertySearchInfo rinfo = new PrincipalPropertySearchInfo(principalPropSearch, 0);
        String methodUri = this.pathResolver.getPrincipalPath(this.getUserName());
        PrincipalPropertySearchMethod method = new PrincipalPropertySearchMethod(methodUri, rinfo);
        this.getClient().execute(this.getClient().hostConfiguration, method);
        ArrayList<Attendee> resources = new ArrayList<Attendee>();
        if (method.getStatusCode() == 207) {
            MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
            MultiStatusResponse[] responses = multiStatus.getResponses();
            int i = 0;
            while (i < responses.length) {
                DavProperty calendarUserType;
                DavProperty emailSet;
                Attendee resource = new Attendee();
                DavPropertySet propertiesInResponse = responses[i].getProperties(200);
                DavProperty displayNameFromResponse = propertiesInResponse.get("displayname", CalDavConstants.NAMESPACE);
                if (displayNameFromResponse != null && displayNameFromResponse.getValue() != null) {
                    resource.getParameters().add((Parameter)new Cn((String)displayNameFromResponse.getValue()));
                }
                if ((emailSet = propertiesInResponse.get("email-address-set", CalDavConstants.CS_NAMESPACE)) != null && emailSet.getValue() != null) {
                    Object emailSetValue = emailSet.getValue();
                    if (emailSetValue instanceof ArrayList) {
                        for (Object email : (ArrayList)emailSetValue) {
                            String emailAddress;
                            if (!(email instanceof Node) || (emailAddress = ((Node)email).getTextContent()) == null || emailAddress.trim().length() <= 0) continue;
                            if (!emailAddress.startsWith("mailto:")) {
                                emailAddress = "mailto:".concat(emailAddress);
                            }
                            resource.setCalAddress(new URI(emailAddress));
                        }
                    }
                } else {
                    Object value;
                    DavProperty calendarUserAddressSet = propertiesInResponse.get("calendar-user-address-set", CalDavConstants.CALDAV_NAMESPACE);
                    if (calendarUserAddressSet != null && calendarUserAddressSet.getValue() != null && (value = calendarUserAddressSet.getValue()) instanceof ArrayList) {
                        for (Object addressSet : (ArrayList)value) {
                            String url;
                            if (!(addressSet instanceof Node) || !(url = ((Node)addressSet).getTextContent()).startsWith("urn:uuid")) continue;
                            resource.setCalAddress(new URI(url));
                        }
                    }
                }
                if ((calendarUserType = propertiesInResponse.get("calendar-user-type", CalDavConstants.CALDAV_NAMESPACE)) != null && calendarUserType.getValue() != null) {
                    resource.getParameters().add((Parameter)new CuType((String)calendarUserType.getValue()));
                }
                resources.add(resource);
                ++i;
            }
        }
        return resources;
    }
}

