/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.enums;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MediaType {
    ICALENDAR_2_0("text/calendar", "2.0"),
    VCARD_4_0("text/vcard", "4.0");

    private String contentType;
    private String version;
    private static Set<String> index;

    static {
        index = new HashSet<String>();
        MediaType[] mediaTypeArray = MediaType.values();
        int n = mediaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType mediaType = mediaTypeArray[n2];
            index.add(mediaType.getContentType());
            ++n2;
        }
    }

    private MediaType(String contentType, String version) {
        this.contentType = contentType;
        this.version = version;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getVersion() {
        return this.version;
    }

    public static MediaType findByContentTypeAndVersion(String contentType, String version) {
        MediaType[] mediaTypeArray = MediaType.values();
        int n = mediaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType feature = mediaTypeArray[n2];
            if (feature.getContentType().equals(contentType) && feature.getVersion().equals(version)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }
}

