/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.jcr;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.enums.MediaType;
import net.fortuna.ical4j.connector.jcr.AbstractJcrObjectCollection;
import net.fortuna.ical4j.connector.jcr.JcrCalendar;
import net.fortuna.ical4j.connector.jcr.JcrCalendarCollectionDao;
import net.fortuna.ical4j.connector.jcr.JcrCalendarDao;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcrom.annotations.JcrProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrCalendarCollection
extends AbstractJcrObjectCollection<Calendar>
implements CalendarCollection {
    private static final long serialVersionUID = -3063963527215302278L;
    private static final Log LOG = LogFactory.getLog(JcrCalendarCollection.class);
    @JcrProperty
    private Integer maxAttendeesPerInstance;
    @JcrProperty
    private Date maxDateTime;
    @JcrProperty
    private Integer maxInstances;
    @JcrProperty
    private long maxResourceSize;
    @JcrProperty
    private Date minDateTime;
    private JcrCalendarDao calendarDao;
    private JcrCalendarCollectionDao collectionDao;

    private JcrCalendarDao getCalendarDao() {
        if (this.calendarDao == null) {
            this.calendarDao = new JcrCalendarDao(this.getStore().getSession(), this.getStore().getJcrom());
        }
        return this.calendarDao;
    }

    private JcrCalendarCollectionDao getCollectionDao() {
        if (this.collectionDao == null) {
            this.collectionDao = new JcrCalendarCollectionDao(this.getStore().getSession(), this.getStore().getJcrom());
        }
        return this.collectionDao;
    }

    @Override
    public void addCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        this.addCalendar(calendar, true);
    }

    private void addCalendar(Calendar calendar, boolean saveChanges) throws ObjectStoreException, ConstraintViolationException {
        List<JcrCalendar> jcrCalendars;
        try {
            try {
                this.getNode().getNode("calendars");
            }
            catch (PathNotFoundException pathNotFoundException) {
                this.getNode().addNode("calendars");
            }
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException("Unexpected error", e);
        }
        JcrCalendar jcrCal = null;
        boolean update = false;
        Uid uid = Calendars.getUid((Calendar)calendar);
        if (uid != null && !(jcrCalendars = this.getCalendarDao().findByUid(String.valueOf(this.getStore().getJcrom().getPath((Object)this)) + "/calendars", uid.getValue())).isEmpty()) {
            jcrCal = jcrCalendars.get(0);
            update = true;
        }
        if (jcrCal == null) {
            jcrCal = new JcrCalendar();
        }
        jcrCal.setCalendar(calendar);
        if (update) {
            this.getCalendarDao().update((Object)jcrCal);
        } else {
            this.getCalendarDao().create(String.valueOf(this.getStore().getJcrom().getPath((Object)this)) + "/calendars", (Object)jcrCal);
        }
        if (saveChanges) {
            this.saveChanges();
        }
    }

    @Override
    public Calendar export() throws ObjectStoreException {
        Calendar exported = new Calendar();
        List calendars = this.getCalendarDao().findAll(String.valueOf(this.getStore().getJcrom().getPath((Object)this)) + "/calendars");
        for (JcrCalendar jcrCal : calendars) {
            try {
                exported = Calendars.merge((Calendar)exported, (Calendar)jcrCal.getCalendar());
            }
            catch (Exception e) {
                throw new ObjectStoreException("Unexpected error", e);
            }
        }
        return exported;
    }

    @Override
    public Calendar getCalendar(String uid) {
        try {
            List<JcrCalendar> calendars = this.getCalendarDao().findByUid(String.valueOf(this.getStore().getJcrom().getPath((Object)this)) + "/calendars", uid);
            if (!calendars.isEmpty()) {
                return calendars.get(0).getCalendar();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return null;
    }

    public Calendar[] getComponents() throws ObjectStoreException {
        ArrayList<Calendar> retVal = new ArrayList<Calendar>();
        List calendars = this.getCalendarDao().findAll(String.valueOf(this.getStore().getJcrom().getPath((Object)this)) + "/calendars");
        for (JcrCalendar jcrCal : calendars) {
            try {
                retVal.add(jcrCal.getCalendar());
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return retVal.toArray(new Calendar[retVal.size()]);
    }

    @Override
    public Integer getMaxAttendeesPerInstance() {
        return this.maxAttendeesPerInstance;
    }

    @Override
    public String getMaxDateTime() {
        if (this.maxDateTime != null) {
            return this.maxDateTime.toString();
        }
        return null;
    }

    @Override
    public Integer getMaxInstances() {
        return this.maxInstances;
    }

    @Override
    public long getMaxResourceSize() {
        return this.maxResourceSize;
    }

    @Override
    public String getMinDateTime() {
        if (this.minDateTime != null) {
            return this.minDateTime.toString();
        }
        return null;
    }

    @Override
    public String[] getSupportedComponentTypes() {
        return new String[0];
    }

    @Override
    public MediaType[] getSupportedMediaTypes() {
        return new MediaType[0];
    }

    @Override
    public Calendar getTimeZone() {
        return null;
    }

    @Override
    public Calendar removeCalendar(String uid) throws ObjectStoreException {
        Calendar calendar = this.getCalendar(uid);
        List<JcrCalendar> calendars = this.getCalendarDao().findByUid(String.valueOf(this.getStore().getJcrom().getPath((Object)this)) + "/calendars", uid);
        if (calendars.size() > 0) {
            this.getCalendarDao().remove(this.getStore().getJcrom().getPath((Object)calendars.get(0)));
        }
        this.saveChanges();
        return calendar;
    }

    @Override
    public void merge(Calendar calendar) throws FailedOperationException, ObjectStoreException {
        try {
            Calendar[] uidCalendars = Calendars.split((Calendar)calendar);
            int i = 0;
            while (i < uidCalendars.length) {
                this.addCalendar(uidCalendars[i], false);
                ++i;
            }
            this.saveChanges();
        }
        catch (ConstraintViolationException cve) {
            throw new FailedOperationException("Invalid calendar format", cve);
        }
    }

    final void setMaxAttendeesPerInstance(Integer maxAttendeesPerInstance) {
        this.maxAttendeesPerInstance = maxAttendeesPerInstance;
    }

    final void setMaxDateTime(Date maxDateTime) {
        this.maxDateTime = maxDateTime;
    }

    final void setMaxInstances(Integer maxInstances) {
        this.maxInstances = maxInstances;
    }

    final void setMaxResourceSize(long maxResourceSize) {
        this.maxResourceSize = maxResourceSize;
    }

    final void setMinDateTime(Date minDateTime) {
        this.minDateTime = minDateTime;
    }

    private void saveChanges() throws ObjectStoreException {
        this.getCollectionDao().update(this);
    }
}

