/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.Value;
import lombok.core.AnnotationValues;
import lombok.experimental.Accessors;
import lombok.experimental.FieldDefaults;
import lombok.experimental.Wither;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationsUtil {
    public static final List<Class<? extends Annotation>> INVALID_ON_BUILDERS = Collections.unmodifiableList(Arrays.asList(Getter.class, Setter.class, Wither.class, ToString.class, EqualsAndHashCode.class, RequiredArgsConstructor.class, AllArgsConstructor.class, NoArgsConstructor.class, Data.class, Value.class, lombok.experimental.Value.class, FieldDefaults.class));
    public static final Pattern NON_NULL_PATTERN = Pattern.compile("^(?:nonnull)$", 2);
    public static final Pattern NULLABLE_PATTERN = Pattern.compile("^(?:nullable|checkfornull)$", 2);

    private TransformationsUtil() {
    }

    private static CharSequence removePrefix(CharSequence fieldName, String[] prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            return fieldName;
        }
        block0: for (String prefix : prefixes) {
            if (prefix.length() == 0) {
                return fieldName;
            }
            if (fieldName.length() <= prefix.length()) continue;
            for (int i = 0; i < prefix.length(); ++i) {
                if (fieldName.charAt(i) != prefix.charAt(i)) continue block0;
            }
            char followupChar = fieldName.charAt(prefix.length());
            if (Character.isLetter(prefix.charAt(prefix.length() - 1)) && Character.isLowerCase(followupChar)) continue;
            return "" + Character.toLowerCase(followupChar) + fieldName.subSequence(prefix.length() + 1, fieldName.length());
        }
        return null;
    }

    public static String toGetterName(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return TransformationsUtil.toAccessorName(accessors, fieldName, isBoolean, "is", "get", true);
    }

    public static String toSetterName(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return TransformationsUtil.toAccessorName(accessors, fieldName, isBoolean, "set", "set", true);
    }

    public static String toWitherName(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return TransformationsUtil.toAccessorName(accessors, fieldName, isBoolean, "with", "with", false);
    }

    private static String toAccessorName(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean, String booleanPrefix, String normalPrefix, boolean adhereToFluent) {
        if (fieldName.length() == 0) {
            return null;
        }
        Accessors ac = accessors == null ? null : accessors.getInstance();
        if ((fieldName = TransformationsUtil.removePrefix(fieldName, ac == null ? new String[]{} : ac.prefix())) == null) {
            return null;
        }
        String fName = fieldName.toString();
        if (adhereToFluent && ac != null && ac.fluent()) {
            return fName;
        }
        if (isBoolean && fName.startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
            return booleanPrefix + fName.substring(2);
        }
        return TransformationsUtil.buildName(isBoolean ? booleanPrefix : normalPrefix, fName);
    }

    public static List<String> toAllGetterNames(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return TransformationsUtil.toAllAccessorNames(accessors, fieldName, isBoolean, "is", "get", true);
    }

    public static List<String> toAllSetterNames(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return TransformationsUtil.toAllAccessorNames(accessors, fieldName, isBoolean, "set", "set", true);
    }

    public static List<String> toAllWitherNames(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean) {
        return TransformationsUtil.toAllAccessorNames(accessors, fieldName, isBoolean, "with", "with", false);
    }

    private static List<String> toAllAccessorNames(AnnotationValues<Accessors> accessors, CharSequence fieldName, boolean isBoolean, String booleanPrefix, String normalPrefix, boolean adhereToFluent) {
        if (!isBoolean) {
            String accessorName = TransformationsUtil.toAccessorName(accessors, fieldName, false, booleanPrefix, normalPrefix, adhereToFluent);
            return accessorName == null ? Collections.emptyList() : Collections.singletonList(accessorName);
        }
        Accessors acc = accessors.getInstance();
        if ((fieldName = TransformationsUtil.removePrefix(fieldName, acc.prefix())) == null) {
            return Collections.emptyList();
        }
        List<String> baseNames = TransformationsUtil.toBaseNames(fieldName, isBoolean, acc.fluent());
        HashSet<String> names = new HashSet<String>();
        for (String baseName : baseNames) {
            if (adhereToFluent && acc.fluent()) {
                names.add(baseName);
                continue;
            }
            names.add(TransformationsUtil.buildName(normalPrefix, baseName));
            if (normalPrefix.equals(booleanPrefix)) continue;
            names.add(TransformationsUtil.buildName(booleanPrefix, baseName));
        }
        return new ArrayList<String>(names);
    }

    private static List<String> toBaseNames(CharSequence fieldName, boolean isBoolean, boolean fluent) {
        ArrayList<String> baseNames = new ArrayList<String>();
        baseNames.add(fieldName.toString());
        String fName = fieldName.toString();
        if (fName.startsWith("is") && fName.length() > 2 && !Character.isLowerCase(fName.charAt(2))) {
            String baseName = fName.substring(2);
            if (fluent) {
                baseNames.add("" + Character.toLowerCase(baseName.charAt(0)) + baseName.substring(1));
            } else {
                baseNames.add(baseName);
            }
        }
        return baseNames;
    }

    private static String buildName(String prefix, String suffix) {
        if (suffix.length() == 0) {
            return prefix;
        }
        if (prefix.length() == 0) {
            return suffix;
        }
        char first = suffix.charAt(0);
        if (Character.isLowerCase(first)) {
            boolean useUpperCase = suffix.length() > 2 && (Character.isTitleCase(suffix.charAt(1)) || Character.isUpperCase(suffix.charAt(1)));
            suffix = String.format("%s%s", Character.valueOf(useUpperCase ? Character.toUpperCase(first) : Character.toTitleCase(first)), suffix.subSequence(1, suffix.length()));
        }
        return String.format("%s%s", prefix, suffix);
    }
}

