/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.AccessLevel;
import lombok.Delegate;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleGetter
extends JavacAnnotationHandler<Getter> {
    private static final String AR = "java.util.concurrent.atomic.AtomicReference";
    private static final String JLO = "java.lang.Object";
    private static final List<JCTree.JCExpression> NIL_EXPRESSION = List.nil();
    private static final Map<Integer, String> TYPE_MAP;

    public void generateGetterForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean checkForTypeLevelGetter) {
        boolean notAClass;
        if (checkForTypeLevelGetter && JavacHandlerUtil.hasAnnotation(Getter.class, typeNode)) {
            return;
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x2200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@Getter is only supported on a class, an enum, or a field.");
            return;
        }
        for (JavacNode field : typeNode.down()) {
            if (!this.fieldQualifiesForGetterGeneration(field)) continue;
            this.generateGetterForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level, false);
        }
    }

    public boolean fieldQualifiesForGetterGeneration(JavacNode field) {
        if (field.getKind() != AST.Kind.FIELD) {
            return false;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        if (fieldDecl.name.toString().startsWith("$")) {
            return false;
        }
        return (fieldDecl.mods.flags & 8L) == 0L;
    }

    public void generateGetterForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level, boolean lazy) {
        if (JavacHandlerUtil.hasAnnotation(Getter.class, fieldNode)) {
            return;
        }
        this.createGetterForField(level, fieldNode, fieldNode, false, lazy, List.<JCTree.JCAnnotation>nil());
    }

    @Override
    public void handle(AnnotationValues<Getter> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        Collection<JavacNode> fields = annotationNode.upFromAnnotationToFields();
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Getter.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        Getter annotationInstance = annotation.getInstance();
        AccessLevel level = annotationInstance.value();
        boolean lazy = annotationInstance.lazy();
        if (level == AccessLevel.NONE) {
            if (lazy) {
                annotationNode.addWarning("'lazy' does not work with AccessLevel.NONE.");
            }
            return;
        }
        if (node == null) {
            return;
        }
        List<JCTree.JCAnnotation> onMethod = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onMethod", "@Getter(onMethod=", annotationNode);
        switch (node.getKind()) {
            case FIELD: {
                this.createGetterForFields(level, fields, annotationNode, true, lazy, onMethod);
                break;
            }
            case TYPE: {
                if (!onMethod.isEmpty()) {
                    annotationNode.addError("'onMethod' is not supported for @Getter on a type.");
                }
                if (lazy) {
                    annotationNode.addError("'lazy' is not supported for @Getter on a type.");
                }
                this.generateGetterForType(node, annotationNode, level, false);
            }
        }
    }

    private void createGetterForFields(AccessLevel level, Collection<JavacNode> fieldNodes, JavacNode errorNode, boolean whineIfExists, boolean lazy, List<JCTree.JCAnnotation> onMethod) {
        for (JavacNode fieldNode : fieldNodes) {
            this.createGetterForField(level, fieldNode, errorNode, whineIfExists, lazy, onMethod);
        }
    }

    private void createGetterForField(AccessLevel level, JavacNode fieldNode, JavacNode source, boolean whineIfExists, boolean lazy, List<JCTree.JCAnnotation> onMethod) {
        String methodName;
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            source.addError("@Getter is only supported on a class or a field.");
            return;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        if (lazy) {
            if ((fieldDecl.mods.flags & 2L) == 0L || (fieldDecl.mods.flags & 0x10L) == 0L) {
                source.addError("'lazy' requires the field to be private and final.");
                return;
            }
            if (fieldDecl.init == null) {
                source.addError("'lazy' requires field initialization.");
                return;
            }
        }
        if ((methodName = JavacHandlerUtil.toGetterName(fieldNode)) == null) {
            source.addWarning("Not generating getter for this field: It does not fit your @Accessors prefix list.");
            return;
        }
        for (String altName : JavacHandlerUtil.toAllGetterNames(fieldNode)) {
            switch (JavacHandlerUtil.methodExists(altName, fieldNode, false, 0)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(methodName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        source.addWarning(String.format("Not generating %s(): A method with that name already exists%s", methodName, altNameExpl));
                    }
                    return;
                }
            }
        }
        long access = (long)JavacHandlerUtil.toJavacModifier(level) | fieldDecl.mods.flags & 8L;
        JavacHandlerUtil.injectMethod((JavacNode)fieldNode.up(), this.createGetter(access, fieldNode, fieldNode.getTreeMaker(), (JCTree)source.get(), lazy, onMethod));
    }

    private JCTree.JCMethodDecl createGetter(long access, JavacNode field, TreeMaker treeMaker, JCTree source, boolean lazy, List<JCTree.JCAnnotation> onMethod) {
        List<JCTree.JCStatement> statements;
        JCTree.JCVariableDecl fieldNode = (JCTree.JCVariableDecl)field.get();
        JCTree.JCExpression methodType = this.copyType(treeMaker, fieldNode);
        Name methodName = field.toName(JavacHandlerUtil.toGetterName(field));
        JCTree.JCExpression toClearOfMarkers = null;
        if (lazy) {
            toClearOfMarkers = fieldNode.init;
            statements = this.createLazyGetterBody(treeMaker, field, source);
        } else {
            statements = this.createSimpleGetterBody(treeMaker, field);
        }
        JCTree.JCBlock methodBody = treeMaker.Block(0L, statements);
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression annotationMethodDefaultValue = null;
        List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        List<JCTree.JCAnnotation> delegates = HandleGetter.findDelegatesAndRemoveFromField(field);
        List<JCTree.JCAnnotation> annsOnMethod = JavacHandlerUtil.copyAnnotations(onMethod).appendList(nonNulls).appendList(nullables);
        if (JavacHandlerUtil.isFieldDeprecated(field)) {
            annsOnMethod = annsOnMethod.prepend(treeMaker.Annotation(JavacHandlerUtil.chainDots(field, "java", "lang", "Deprecated"), List.<JCTree.JCExpression>nil()));
        }
        JCTree.JCMethodDecl decl = JavacHandlerUtil.recursiveSetGeneratedBy(treeMaker.MethodDef(treeMaker.Modifiers(access, annsOnMethod), methodName, methodType, methodGenericParams, parameters, throwsClauses, methodBody, annotationMethodDefaultValue), source);
        if (toClearOfMarkers != null) {
            JavacHandlerUtil.recursiveSetGeneratedBy(toClearOfMarkers, null);
        }
        decl.mods.annotations = decl.mods.annotations.appendList(delegates);
        JavacHandlerUtil.copyJavadoc(field, decl, JavacHandlerUtil.CopyJavadoc.GETTER);
        return decl;
    }

    private static List<JCTree.JCAnnotation> findDelegatesAndRemoveFromField(JavacNode field) {
        JCTree.JCVariableDecl fieldNode = (JCTree.JCVariableDecl)field.get();
        List<JCTree.JCAnnotation> delegates = List.nil();
        for (JCTree.JCAnnotation annotation : fieldNode.mods.annotations) {
            if (!JavacHandlerUtil.typeMatches(Delegate.class, field, annotation.annotationType)) continue;
            delegates = delegates.append(annotation);
        }
        if (!delegates.isEmpty()) {
            ListBuffer withoutDelegates = ListBuffer.lb();
            for (JCTree.JCAnnotation annotation : fieldNode.mods.annotations) {
                if (delegates.contains(annotation)) continue;
                withoutDelegates.append(annotation);
            }
            fieldNode.mods.annotations = withoutDelegates.toList();
            field.rebuild();
        }
        return delegates;
    }

    private List<JCTree.JCStatement> createSimpleGetterBody(TreeMaker treeMaker, JavacNode field) {
        return List.of(treeMaker.Return(JavacHandlerUtil.createFieldAccessor(treeMaker, field, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD)));
    }

    private List<JCTree.JCStatement> createLazyGetterBody(TreeMaker maker, JavacNode fieldNode, JCTree source) {
        JCTree.JCStatement statement;
        String boxed;
        ListBuffer statements = ListBuffer.lb();
        JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
        JCTree.JCExpression copyOfRawFieldType = this.copyType(maker, field);
        JCTree.JCExpression copyOfBoxedFieldType = null;
        field.type = null;
        boolean isPrimitive = false;
        if (field.vartype instanceof JCTree.JCPrimitiveTypeTree && (boxed = TYPE_MAP.get((int)((JCTree.JCPrimitiveTypeTree)field.vartype).typetag)) != null) {
            isPrimitive = true;
            field.vartype = JavacHandlerUtil.chainDotsString(fieldNode, boxed);
            copyOfBoxedFieldType = JavacHandlerUtil.chainDotsString(fieldNode, boxed);
        }
        if (copyOfBoxedFieldType == null) {
            copyOfBoxedFieldType = this.copyType(maker, field);
        }
        Name valueName = fieldNode.toName("value");
        Name actualValueName = fieldNode.toName("actualValue");
        JCTree.JCExpression valueVarType = JavacHandlerUtil.chainDotsString(fieldNode, JLO);
        statements.append(maker.VarDef(maker.Modifiers(0L), valueName, valueVarType, this.callGet(fieldNode, JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD))));
        ListBuffer synchronizedStatements = ListBuffer.lb();
        JCTree.JCExpressionStatement newAssign = maker.Exec(maker.Assign(maker.Ident(valueName), this.callGet(fieldNode, JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD))));
        synchronizedStatements.append(newAssign);
        ListBuffer innerIfStatements = ListBuffer.lb();
        innerIfStatements.append(maker.VarDef(maker.Modifiers(16L), actualValueName, copyOfRawFieldType, field.init));
        if (isPrimitive) {
            statement = maker.Exec(maker.Assign(maker.Ident(valueName), maker.Ident(actualValueName)));
            innerIfStatements.append(statement);
        }
        if (!isPrimitive) {
            JCTree.JCBinary actualValueIsNull = maker.Binary(Javac.CTC_EQUAL, maker.Ident(actualValueName), maker.Literal(Javac.CTC_BOT, null));
            JCTree.JCExpression thisDotFieldName = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD);
            JCTree.JCConditional ternary = maker.Conditional(actualValueIsNull, thisDotFieldName, maker.Ident(actualValueName));
            JCTree.JCExpressionStatement statement2 = maker.Exec(maker.Assign(maker.Ident(valueName), ternary));
            innerIfStatements.append(statement2);
        }
        statement = this.callSet(fieldNode, JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD), maker.Ident(valueName));
        innerIfStatements.append(statement);
        JCTree.JCBinary isNull = maker.Binary(Javac.CTC_EQUAL, maker.Ident(valueName), maker.Literal(Javac.CTC_BOT, null));
        JCTree.JCIf ifStatement = maker.If(isNull, maker.Block(0L, innerIfStatements.toList()), null);
        synchronizedStatements.append(ifStatement);
        JCTree.JCSynchronized synchronizedStatement = maker.Synchronized(JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD), maker.Block(0L, synchronizedStatements.toList()));
        JCTree.JCBinary isNull2 = maker.Binary(Javac.CTC_EQUAL, maker.Ident(valueName), maker.Literal(Javac.CTC_BOT, null));
        JCTree.JCIf ifStatement2 = maker.If(isNull2, maker.Block(0L, List.of(synchronizedStatement)), null);
        statements.append(ifStatement2);
        if (isPrimitive) {
            statements.append(maker.Return(maker.TypeCast(copyOfBoxedFieldType, (JCTree.JCExpression)maker.Ident(valueName))));
        }
        if (!isPrimitive) {
            JCTree.JCBinary valueEqualsSelf = maker.Binary(Javac.CTC_EQUAL, maker.Ident(valueName), JavacHandlerUtil.createFieldAccessor(maker, fieldNode, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD));
            JCTree.JCConditional ternary = maker.Conditional(valueEqualsSelf, maker.Literal(Javac.CTC_BOT, null), maker.Ident(valueName));
            JCTree.JCTypeCast typeCast = maker.TypeCast(copyOfBoxedFieldType, (JCTree.JCExpression)maker.Parens(ternary));
            statements.append(maker.Return(typeCast));
        }
        field.vartype = JavacHandlerUtil.recursiveSetGeneratedBy(maker.TypeApply(JavacHandlerUtil.chainDotsString(fieldNode, AR), List.of(JavacHandlerUtil.chainDotsString(fieldNode, JLO))), source);
        field.init = JavacHandlerUtil.recursiveSetGeneratedBy(maker.NewClass(null, NIL_EXPRESSION, this.copyType(maker, field), NIL_EXPRESSION, null), source);
        return statements.toList();
    }

    private JCTree.JCMethodInvocation callGet(JavacNode source, JCTree.JCExpression receiver) {
        TreeMaker maker = source.getTreeMaker();
        return maker.Apply(NIL_EXPRESSION, maker.Select(receiver, source.toName("get")), NIL_EXPRESSION);
    }

    private JCTree.JCStatement callSet(JavacNode source, JCTree.JCExpression receiver, JCTree.JCExpression value) {
        TreeMaker maker = source.getTreeMaker();
        return maker.Exec(maker.Apply(NIL_EXPRESSION, maker.Select(receiver, source.toName("set")), List.of(value)));
    }

    private JCTree.JCExpression copyType(TreeMaker treeMaker, JCTree.JCVariableDecl fieldNode) {
        return fieldNode.type != null ? treeMaker.Type(fieldNode.type) : fieldNode.vartype;
    }

    static {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(Javac.CTC_INT, "java.lang.Integer");
        m.put(Javac.CTC_DOUBLE, "java.lang.Double");
        m.put(Javac.CTC_FLOAT, "java.lang.Float");
        m.put(Javac.CTC_SHORT, "java.lang.Short");
        m.put(Javac.CTC_BYTE, "java.lang.Byte");
        m.put(Javac.CTC_LONG, "java.lang.Long");
        m.put(Javac.CTC_BOOLEAN, "java.lang.Boolean");
        m.put(Javac.CTC_CHAR, "java.lang.Character");
        TYPE_MAP = Collections.unmodifiableMap(m);
    }
}

