/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import lombok.NonNull;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class NonNullHandler
extends JavacAnnotationHandler<NonNull> {
    @Override
    public void handle(AnnotationValues<NonNull> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JCTree.JCMethodDecl declaration;
        if (((JavacNode)annotationNode.up()).getKind() == AST.Kind.FIELD) {
            try {
                if (Javac.isPrimitive(((JCTree.JCVariableDecl)((JavacNode)annotationNode.up()).get()).vartype)) {
                    annotationNode.addWarning("@NonNull is meaningless on a primitive.");
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return;
        }
        if (((JavacNode)annotationNode.up()).getKind() != AST.Kind.ARGUMENT) {
            return;
        }
        try {
            declaration = (JCTree.JCMethodDecl)((JavacNode)((JavacNode)annotationNode.up()).up()).get();
        }
        catch (Exception e) {
            return;
        }
        if (JavacHandlerUtil.isGenerated(declaration)) {
            return;
        }
        JCTree.JCStatement nullCheck = JavacHandlerUtil.recursiveSetGeneratedBy(JavacHandlerUtil.generateNullCheck(annotationNode.getTreeMaker(), (JavacNode)annotationNode.up()), ast);
        if (nullCheck == null) {
            annotationNode.addWarning("@NonNull is meaningless on a primitive.");
            return;
        }
        List<JCTree.JCStatement> statements = declaration.body.stats;
        String expectedName = ((JavacNode)annotationNode.up()).getName();
        for (JCTree.JCStatement stat : statements) {
            if (JavacHandlerUtil.isConstructorCall(stat)) continue;
            String varNameOfNullCheck = this.returnVarNameIfNullCheck(stat);
            if (varNameOfNullCheck == null) break;
            if (!varNameOfNullCheck.equals(expectedName)) continue;
            return;
        }
        List<JCTree.JCStatement> tail = statements;
        List<JCTree.JCStatement> head = List.nil();
        for (JCTree.JCStatement stat : statements) {
            if (!JavacHandlerUtil.isConstructorCall(stat) && !JavacHandlerUtil.isGenerated(stat)) break;
            tail = tail.tail;
            head = head.prepend(stat);
        }
        List<JCTree.JCStatement> newList = tail.prepend(nullCheck);
        for (JCTree.JCStatement stat : head) {
            newList = newList.prepend(stat);
        }
        declaration.body.stats = newList;
    }

    private String returnVarNameIfNullCheck(JCTree.JCStatement stat) {
        if (!(stat instanceof JCTree.JCIf)) {
            return null;
        }
        JCTree.JCStatement then = ((JCTree.JCIf)stat).thenpart;
        if (then instanceof JCTree.JCBlock) {
            List<JCTree.JCStatement> stats = ((JCTree.JCBlock)then).stats;
            if (stats.length() == 0) {
                return null;
            }
            then = stats.get(0);
        }
        if (!(then instanceof JCTree.JCThrow)) {
            return null;
        }
        JCTree.JCExpression cond = ((JCTree.JCIf)stat).cond;
        while (cond instanceof JCTree.JCParens) {
            cond = ((JCTree.JCParens)cond).expr;
        }
        if (!(cond instanceof JCTree.JCBinary)) {
            return null;
        }
        JCTree.JCBinary bin = (JCTree.JCBinary)cond;
        if (Javac.getTag(bin) != Javac.CTC_EQUAL) {
            return null;
        }
        if (!(bin.lhs instanceof JCTree.JCIdent)) {
            return null;
        }
        if (!(bin.rhs instanceof JCTree.JCLiteral)) {
            return null;
        }
        if (((JCTree.JCLiteral)bin.rhs).typetag != Javac.CTC_BOT) {
            return null;
        }
        return ((JCTree.JCIdent)bin.lhs).name.toString();
    }
}

