/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;

public class CategoryModel
extends Model {
    private static CategoryModel self_ = new CategoryModel();
    public static final String UNCATEGORIZED = Resource.getResourceString((String)"uncategorized");
    private Collection<String> categories_ = new TreeSet<String>(new CategoryComparator());
    private Collection<String> shownCategories_ = new TreeSet<String>(new CategoryComparator());
    Collection<CategorySource> sources = new ArrayList<CategorySource>();

    public static CategoryModel getReference() {
        return self_;
    }

    private void addAll(Collection<String> cats) {
        this.categories_.addAll(cats);
        this.shownCategories_.addAll(cats);
    }

    public void addCategory(String cat) {
        this.categories_.add(cat);
        this.refreshListeners();
    }

    public void addSource(CategorySource s) {
        this.sources.add(s);
        this.addAll(s.getCategories());
    }

    public Collection<String> getCategories() throws Exception {
        ArrayList<String> cats = new ArrayList<String>();
        cats.addAll(this.categories_);
        return cats;
    }

    public Collection<String> getShownCategories() {
        ArrayList<String> cats = new ArrayList<String>();
        cats.addAll(this.shownCategories_);
        return cats;
    }

    public boolean isShown(String cat) {
        return this.shownCategories_.contains(cat == null || cat.equals("") ? UNCATEGORIZED : cat);
    }

    @Override
    public void remove() {
    }

    public void deleteCategory(String cat) {
        this.categories_.remove(cat);
        this.shownCategories_.remove(cat);
        this.refreshListeners();
    }

    public void setShownCategories(Collection<String> cats) {
        this.shownCategories_ = cats;
        this.refreshListeners();
    }

    public void showAll() {
        this.shownCategories_.clear();
        this.shownCategories_.addAll(this.categories_);
        this.refreshListeners();
    }

    public void showCategory(String cat) {
        this.shownCategories_.add(cat);
    }

    @Override
    public void sync() {
        TreeSet<String> oldCategories = new TreeSet<String>(new CategoryComparator());
        oldCategories.addAll(this.categories_);
        this.categories_.clear();
        for (CategorySource categorySource : this.sources) {
            this.categories_.addAll(categorySource.getCategories());
        }
        for (String string : this.categories_) {
            if (oldCategories.contains(string)) continue;
            this.showCategory(string);
        }
        this.refreshListeners();
    }

    @Override
    public void export(Writer fw) throws Exception {
    }

    @Override
    public void importXml(InputStream is) throws Exception {
    }

    @Override
    public String getExportName() {
        return null;
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"Categories") + ":" + this.getCategories().size();
    }

    static class CategoryComparator
    implements Comparator<String> {
        CategoryComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.compareTo(o2) == 0) {
                return 0;
            }
            if (o1.equals(UNCATEGORIZED)) {
                return -1;
            }
            if (o2.equals(UNCATEGORIZED)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    static interface CategorySource {
        public Collection<String> getCategories();
    }
}

