/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.OptionModel;
import net.sf.borg.model.SearchCriteria;
import net.sf.borg.model.Searchable;
import net.sf.borg.model.TaskTypes;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.TaskDB;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Link;
import net.sf.borg.model.entity.Option;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.model.entity.Tasklog;
import net.sf.borg.model.undo.ProjectUndoItem;
import net.sf.borg.model.undo.SubtaskUndoItem;
import net.sf.borg.model.undo.TaskUndoItem;
import net.sf.borg.model.undo.UndoLog;

public class TaskModel
extends Model
implements Model.Listener,
CategoryModel.CategorySource,
Searchable<KeyedEntity<?>> {
    private static final String TASKTYPES_OPTION = "TASKTYPES";
    private TaskDB db_;
    private HashMap<Integer, Collection<Task>> btmap_;
    private Vector<Task> openTaskMap;
    private HashMap<Integer, Collection<Subtask>> stmap_;
    private HashMap<Integer, Collection<Project>> pmap_;
    private TaskTypes taskTypes_;
    private static TaskModel self_ = new TaskModel();
    public static final int NO_DAYS_VALUE = 9999999;

    public TaskDB getDB() {
        return this.db_;
    }

    public Collection<Task> get_tasks(Date d) {
        return this.btmap_.get(new Integer(DateUtil.dayOfEpoch((Date)d)));
    }

    public Collection<Subtask> get_subtasks(Date d) {
        return this.stmap_.get(new Integer(DateUtil.dayOfEpoch((Date)d)));
    }

    public Collection<Project> get_projects(Date d) {
        return this.pmap_.get(new Integer(DateUtil.dayOfEpoch((Date)d)));
    }

    public Vector<Task> get_tasks() {
        return this.openTaskMap;
    }

    public static TaskModel getReference() {
        return self_;
    }

    public TaskTypes getTaskTypes() {
        return this.taskTypes_;
    }

    public void saveTaskTypes(TaskTypes tt) throws Exception {
        if (tt != null) {
            tt.validate();
            this.taskTypes_ = tt.copy();
        }
        OptionModel.getReference().setOption(new Option(TASKTYPES_OPTION, this.taskTypes_.toXml()));
    }

    @Override
    public Collection<String> getCategories() {
        String cat;
        TreeSet<String> categories = new TreeSet<String>();
        try {
            for (Task task : this.db_.readAll()) {
                cat = task.getCategory();
                if (cat == null || cat.equals("")) continue;
                categories.add(cat);
            }
        }
        catch (Exception e1) {
            Errmsg.getErrorHandler().errmsg(e1);
        }
        try {
            for (Project project : this.getProjects()) {
                cat = project.getCategory();
                if (cat == null || cat.equals("")) continue;
                categories.add(cat);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return categories;
    }

    public Collection<Task> getTasks() throws Exception {
        return this.db_.readAll();
    }

    private void load_map() {
        this.btmap_.clear();
        this.openTaskMap.clear();
        this.stmap_.clear();
        this.pmap_.clear();
        try {
            Collection<KeyedEntity> o;
            int key;
            Date due;
            for (Task mr : this.getTasks()) {
                if (mr.getState().equals(this.getTaskTypes().getFinalState(mr.getType())) || !CategoryModel.getReference().isShown(mr.getCategory()) || (due = mr.getDueDate()) == null) continue;
                key = DateUtil.dayOfEpoch((Date)due);
                o = this.btmap_.get(new Integer(key));
                if (o == null) {
                    o = new LinkedList<Task>();
                    this.btmap_.put(new Integer(key), o);
                }
                o.add(mr);
                this.openTaskMap.add(mr);
            }
            for (Project pj : this.getProjects()) {
                if (pj.getDueDate() == null || pj.getStatus().equals(Resource.getResourceString((String)"CLOSED")) || !CategoryModel.getReference().isShown(pj.getCategory())) continue;
                due = pj.getDueDate();
                key = DateUtil.dayOfEpoch((Date)due);
                o = this.pmap_.get(new Integer(key));
                if (o == null) {
                    o = new LinkedList();
                    this.pmap_.put(new Integer(key), o);
                }
                o.add((Task)((Object)pj));
            }
            for (Subtask st : this.getSubTasks()) {
                if (st.getCloseDate() != null || st.getDueDate() == null) continue;
                Task mr = this.getTask(st.getTask());
                String cat = mr.getCategory();
                if (cat == null || cat.equals("")) {
                    cat = CategoryModel.UNCATEGORIZED;
                }
                if (!CategoryModel.getReference().isShown(cat)) continue;
                Date due2 = st.getDueDate();
                int key2 = DateUtil.dayOfEpoch((Date)due2);
                Collection<Subtask> o2 = this.stmap_.get(new Integer(key2));
                if (o2 == null) {
                    o2 = new LinkedList<Subtask>();
                    this.stmap_.put(new Integer(key2), o2);
                }
                o2.add(st);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    private TaskModel() {
        block6: {
            this.taskTypes_ = new TaskTypes();
            this.btmap_ = new HashMap();
            this.stmap_ = new HashMap();
            this.pmap_ = new HashMap();
            this.openTaskMap = new Vector();
            this.db_ = DBHelper.getFactory().createTaskDB();
            try {
                String tt = OptionModel.getReference().getOption(TASKTYPES_OPTION);
                if (tt == null) {
                    String sm = OptionModel.getReference().getOption("SMODEL");
                    if (sm == null) {
                        try {
                            this.taskTypes_.loadDefault();
                            sm = this.taskTypes_.toXml();
                            OptionModel.getReference().setOption(new Option(TASKTYPES_OPTION, sm));
                            break block6;
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                            return;
                        }
                    }
                    this.taskTypes_.fillFromLegacyXml(sm);
                    break block6;
                }
                this.taskTypes_.fromString(tt);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
        }
        CategoryModel.getReference().addSource(this);
        CategoryModel.getReference().addListener(this);
        OptionModel.getReference().addListener(this);
        this.load_map();
    }

    public void delete(int tasknum) throws Exception {
        this.delete(tasknum, false);
    }

    public void delete(int tasknum, boolean undo) throws Exception {
        Task tmp = new Task();
        tmp.setKey(tasknum);
        try {
            LinkModel.getReference().deleteLinksFromEntity(tmp);
            LinkModel.getReference().deleteLinksToEntity(tmp);
            if (!undo) {
                Task task = this.getTask(tasknum);
                UndoLog.getReference().addItem(TaskUndoItem.recordDelete(task));
                Collection<Subtask> coll = this.getSubTasks(task.getKey());
                if (coll != null) {
                    for (Subtask st : coll) {
                        SubtaskUndoItem.recordDelete(st);
                    }
                }
            }
            this.db_.delete(tasknum);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.load_map();
        this.refreshListeners(new Model.ChangeEvent(tmp, Model.ChangeEvent.ChangeAction.DELETE));
    }

    public void deleteProject(int id) throws Exception {
        Project tmp = new Project();
        tmp.setKey(id);
        try {
            TaskModel.beginTransaction();
            LinkModel.getReference().deleteLinksFromEntity(tmp);
            LinkModel.getReference().deleteLinksToEntity(tmp);
            this.db_.deleteProject(id);
            TaskModel.commitTransaction();
        }
        catch (Exception e) {
            TaskModel.rollbackTransaction();
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.load_map();
        this.refreshListeners(new Model.ChangeEvent(tmp, Model.ChangeEvent.ChangeAction.DELETE));
    }

    public void savetask(Task task) throws Exception {
        this.savetask(task, false);
    }

    public void savetask(Task task, boolean undo) throws Exception {
        if (task.getProject() != null) {
            Project p = TaskModel.getReference().getProject(task.getProject());
            if (p != null && task.getDueDate() != null && p.getDueDate() != null && DateUtil.isAfter((Date)task.getDueDate(), (Date)p.getDueDate())) {
                throw new Warning(Resource.getResourceString((String)"taskdd_warning"));
            }
            if (p != null && TaskModel.isClosed(p) && !TaskModel.isClosed(task)) {
                throw new Warning(Resource.getResourceString((String)"task_parent_closed"));
            }
        }
        Integer num = new Integer(task.getKey());
        Task indb = this.getTask(num);
        Model.ChangeEvent.ChangeAction action = Model.ChangeEvent.ChangeAction.ADD;
        if (num == -1 || indb == null) {
            if (!undo) {
                int newkey = this.db_.nextkey();
                task.setKey(newkey);
            }
            this.db_.addObj(task);
            if (!undo) {
                Task t = this.getTask(task.getKey());
                UndoLog.getReference().addItem(TaskUndoItem.recordAdd(t));
            }
        } else {
            if (task.getState() != null && TaskModel.isClosed(task)) {
                task.setCompletionDate(new Date());
            }
            int key = task.getKey();
            task.setKey(key);
            if (!undo) {
                Task t = this.getTask(task.getKey());
                UndoLog.getReference().addItem(TaskUndoItem.recordUpdate(t));
            }
            this.db_.updateObj(task);
            action = Model.ChangeEvent.ChangeAction.CHANGE;
        }
        this.load_map();
        this.refreshListeners(new Model.ChangeEvent(task, action));
    }

    public Task newMR() {
        return (Task)this.db_.newObj();
    }

    public Task getTask(int num) throws Exception {
        return (Task)this.db_.readObj(num);
    }

    public void close(int num) throws Exception, Warning {
        for (Subtask st : TaskModel.getReference().getSubTasks(num)) {
            if (st.getCloseDate() != null) continue;
            throw new Warning(Resource.getResourceString((String)"open_subtasks"));
        }
        Task task = this.getTask(num);
        task.setState(TaskModel.getReference().getTaskTypes().getFinalState(task.getType()));
        this.savetask(task);
    }

    public void closeProject(int num) throws Exception, Warning {
        Project p = this.getProject(num);
        p.setStatus(Resource.getResourceString((String)"CLOSED"));
        this.saveProject(p);
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.Project = this.getProjects();
        container.Task = this.getTasks();
        container.Subtask = this.getSubTasks();
        container.Tasklog = this.getLogs();
        m.marshal((Object)container, fw);
    }

    public Collection<Project> getProjects() throws Exception {
        return this.db_.getProjects();
    }

    public Project getProject(int id) throws Exception {
        return this.db_.getProject(id);
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        int nextSubTaskKey;
        boolean use_keys;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        String dbtype = Prefs.getPref((PrefName)PrefName.DBTYPE);
        if (dbtype.equals("mysql")) {
            DBHelper.getController().execSQL("SET foreign_key_checks = 0;");
        } else {
            DBHelper.getController().execSQL("SET REFERENTIAL_INTEGRITY FALSE;");
        }
        if (container.OPTION != null) {
            OptionModel.getReference().importOptions(container.OPTION);
        }
        if (container.Task != null) {
            for (Task task : container.Task) {
                if (task.getPriority() == null) {
                    task.setPriority(new Integer(3));
                }
                if (task.getStartDate() == null) {
                    task.setStartDate(new Date());
                }
                if (task.getKey() == -1) {
                    task.setKey(this.db_.nextkey());
                }
                if (task.getState() == null) {
                    task.setState(TaskModel.getReference().getTaskTypes().getInitialState(task.getType()));
                }
                this.db_.addObj(task);
            }
        }
        boolean bl = use_keys = (nextSubTaskKey = this.db_.nextSubTaskKey()) == 1;
        if (container.Subtask != null) {
            for (Subtask subtask : container.Subtask) {
                if (!use_keys) {
                    subtask.setKey(nextSubTaskKey++);
                }
                this.db_.addSubTask(subtask);
            }
        }
        if (container.Tasklog != null) {
            for (Tasklog tlog : container.Tasklog) {
                try {
                    tlog.setKey(-1);
                    this.saveLog(tlog);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        }
        if (container.Project != null) {
            for (Project p : container.Project) {
                try {
                    this.db_.addProject(p);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        }
        if (dbtype.equals("mysql")) {
            DBHelper.getController().execSQL("SET foreign_key_checks = 1;");
        } else {
            DBHelper.getController().execSQL("SET REFERENTIAL_INTEGRITY TRUE;");
        }
        this.load_map();
        this.refreshListeners();
    }

    @Override
    public void sync() {
        this.db_.sync();
        this.load_map();
        this.refreshListeners();
    }

    public void refresh() {
        try {
            this.load_map();
            this.refreshListeners();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public void update(Model.ChangeEvent event) {
        if (event.getModel() instanceof OptionModel) {
            try {
                String tt = OptionModel.getReference().getOption(TASKTYPES_OPTION);
                if (tt != null) {
                    this.taskTypes_.fromString(tt);
                }
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        } else {
            this.refresh();
        }
    }

    public Collection<Subtask> getSubTasks(int taskid) throws Exception {
        return this.db_.getSubTasks(taskid);
    }

    public Collection<Subtask> getSubTasks() throws Exception {
        return this.db_.getSubTasks();
    }

    public Subtask getSubTask(int id) throws Exception {
        return this.db_.getSubTask(id);
    }

    public Collection<Task> getTasks(int projectid) throws Exception {
        return this.db_.getTasks(projectid);
    }

    public Collection<Project> getSubProjects(int projectid) throws Exception {
        return this.db_.getSubProjects(projectid);
    }

    public Collection<Project> getAllSubProjects(int projectid) throws Exception {
        ArrayList<Project> c = new ArrayList<Project>();
        this.addSubProjectsToCollection(c, projectid);
        return c;
    }

    private void addSubProjectsToCollection(Collection<Project> c, int projectid) throws Exception {
        Collection<Project> children = this.getSubProjects(projectid);
        if (children.isEmpty()) {
            return;
        }
        c.addAll(children);
        for (Project p : children) {
            this.addSubProjectsToCollection(c, p.getKey());
        }
    }

    public void deleteSubTask(int id) throws Exception {
        this.deleteSubTask(id, false);
    }

    public void deleteSubTask(int id, boolean undo) throws Exception {
        if (!undo) {
            Subtask st = this.db_.getSubTask(id);
            SubtaskUndoItem.recordDelete(st);
        }
        this.db_.deleteSubTask(id);
        this.load_map();
        Subtask tmp = new Subtask();
        tmp.setKey(id);
        this.refreshListeners(new Model.ChangeEvent(tmp, Model.ChangeEvent.ChangeAction.DELETE));
    }

    public void saveSubTask(Subtask s) throws Exception {
        this.saveSubTask(s, false);
    }

    public void saveSubTask(Subtask s, boolean undo) throws Exception {
        Model.ChangeEvent.ChangeAction action = Model.ChangeEvent.ChangeAction.ADD;
        if (s.getKey() <= 0 || null == this.db_.getSubTask(s.getKey())) {
            if (!undo || s.getKey() == -1) {
                s.setKey(this.db_.nextSubTaskKey());
            }
            this.db_.addSubTask(s);
            if (!undo) {
                Subtask st = this.db_.getSubTask(s.getKey());
                SubtaskUndoItem.recordAdd(st);
            }
        } else {
            if (!undo) {
                Subtask st = this.db_.getSubTask(s.getKey());
                SubtaskUndoItem.recordUpdate(st);
            }
            this.db_.updateSubTask(s);
            action = Model.ChangeEvent.ChangeAction.CHANGE;
        }
        this.load_map();
        this.refreshListeners(new Model.ChangeEvent(s, action));
    }

    public void addLog(int taskid, String desc) throws Exception {
        this.db_.addLog(taskid, desc);
    }

    private void saveLog(Tasklog tlog) throws Exception {
        this.db_.saveLog(tlog);
    }

    public Collection<Tasklog> getLogs(int taskid) throws Exception {
        return this.db_.getLogs(taskid);
    }

    public Collection<Tasklog> getLogs() throws Exception {
        return this.db_.getLogs();
    }

    public static int daysLeft(Date dd) {
        if (dd == null) {
            return 0;
        }
        GregorianCalendar today = new GregorianCalendar();
        GregorianCalendar dcal = new GregorianCalendar();
        dcal.setTime(dd);
        int days = 0;
        days = dcal.get(1) == today.get(1) ? dcal.get(6) - today.get(6) : new Long((dd.getTime() - today.getTime().getTime()) / 86400000L).intValue();
        if (days < 0) {
            days = 0;
        }
        return days;
    }

    public int daysLeft(Task t) throws Exception {
        int daysLeft = 9999999;
        if (TaskModel.isClosed(t)) {
            return daysLeft;
        }
        if (t.getDueDate() != null) {
            daysLeft = TaskModel.daysLeft(t.getDueDate());
        }
        for (Subtask st : this.getSubTasks(t.getKey())) {
            if (st.getCloseDate() != null || st.getDueDate() == null) continue;
            daysLeft = Math.min(TaskModel.daysLeft(st.getDueDate()), daysLeft);
        }
        return daysLeft;
    }

    public static int daysBetween(Date start, Date dd) {
        if (dd == null) {
            return 0;
        }
        GregorianCalendar startcal = new GregorianCalendar();
        GregorianCalendar dcal = new GregorianCalendar();
        dcal.setTime(dd);
        startcal.setTime(start);
        int days = 0;
        days = dcal.get(1) == startcal.get(1) ? dcal.get(6) - startcal.get(6) : new Long((dd.getTime() - startcal.getTime().getTime()) / 86400000L).intValue();
        if (days < 0) {
            days = 0;
        }
        return days;
    }

    public static void beginTransaction() throws Exception {
        DBHelper.getController().beginTransaction();
    }

    public static void commitTransaction() throws Exception {
        DBHelper.getController().commitTransaction();
    }

    public static void rollbackTransaction() throws Exception {
        DBHelper.getController().rollbackTransaction();
    }

    public void saveProject(Project p) throws Exception {
        this.saveProject(p, false);
    }

    public void saveProject(Project p, boolean undo) throws Exception {
        Project par;
        Integer pi = p.getParent();
        while (pi != null) {
            if (pi.intValue() == p.getKey()) {
                throw new Warning(Resource.getResourceString((String)"project_cycle"));
            }
            par = TaskModel.getReference().getProject(pi);
            pi = par.getParent();
        }
        if (p.getKey() != -1) {
            for (Task task : TaskModel.getReference().getTasks(p.getKey())) {
                if (p.getDueDate() == null || task.getDueDate() == null || TaskModel.isClosed(task) || !DateUtil.isAfter((Date)task.getDueDate(), (Date)p.getDueDate())) continue;
                throw new Warning(Resource.getResourceString((String)"projdd_warning") + ": " + task.getKey());
            }
            for (Project project : TaskModel.getReference().getSubProjects(p.getKey())) {
                if (p.getDueDate() == null || project.getDueDate() == null || TaskModel.isClosed(project) || !DateUtil.isAfter((Date)project.getDueDate(), (Date)p.getDueDate())) continue;
                throw new Warning(Resource.getResourceString((String)"projchild_warning") + ": " + project.getKey());
            }
        }
        if (p.getParent() != null && (par = TaskModel.getReference().getProject(p.getParent())) != null && p.getDueDate() != null && par.getDueDate() != null && DateUtil.isAfter((Date)p.getDueDate(), (Date)par.getDueDate())) {
            throw new Warning(Resource.getResourceString((String)"projpar_warning"));
        }
        if (p.getStatus().equals(Resource.getResourceString((String)"CLOSED"))) {
            for (Task task : TaskModel.getReference().getTasks(p.getKey())) {
                if (TaskModel.isClosed(task)) continue;
                throw new Warning(Resource.getResourceString((String)"close_proj_warn"));
            }
            for (Project project : TaskModel.getReference().getProjects()) {
                if (TaskModel.isClosed(project) || project.getParent() == null || project.getParent().intValue() != p.getKey()) continue;
                throw new Warning(Resource.getResourceString((String)"close_proj_warn"));
            }
        }
        Model.ChangeEvent.ChangeAction action = Model.ChangeEvent.ChangeAction.ADD;
        if (p.getKey() <= 0) {
            if (!undo) {
                p.setKey(this.db_.nextProjectKey());
            }
            this.db_.addProject(p);
            if (!undo) {
                Project project = this.getProject(p.getKey());
                UndoLog.getReference().addItem(ProjectUndoItem.recordAdd(project));
            }
        } else {
            if (!undo) {
                Project project = this.getProject(p.getKey());
                UndoLog.getReference().addItem(ProjectUndoItem.recordUpdate(project));
            }
            this.db_.updateProject(p);
            action = Model.ChangeEvent.ChangeAction.CHANGE;
        }
        this.load_map();
        this.refreshListeners(new Model.ChangeEvent(p, action));
    }

    public static boolean isClosed(Task t) {
        String stat = t.getState();
        String type = t.getType();
        return stat.equals(TaskModel.getReference().getTaskTypes().getFinalState(type));
    }

    public static boolean isClosed(Project p) {
        String stat = p.getStatus();
        return stat.equals(Resource.getResourceString((String)"CLOSED"));
    }

    @Override
    public Collection<KeyedEntity<?>> search(SearchCriteria criteria) {
        ArrayList res = new ArrayList();
        try {
            Collection<Project> projects = this.getProjects();
            for (Project p : projects) {
                String tx;
                if (!CategoryModel.getReference().isShown(p.getCategory()) || !criteria.search(tx = p.getDescription()) || criteria.getCategory().equals(CategoryModel.UNCATEGORIZED) && p.getCategory() != null && !p.getCategory().equals(CategoryModel.UNCATEGORIZED) || !criteria.getCategory().equals("") && !criteria.getCategory().equals(CategoryModel.UNCATEGORIZED) && !criteria.getCategory().equals(p.getCategory())) continue;
                if (criteria.hasLinks()) {
                    LinkModel lm = LinkModel.getReference();
                    try {
                        Collection<Link> lnks = lm.getLinks(p);
                        if (lnks.isEmpty()) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
                res.add(p);
            }
            Collection<Task> tasks = this.getTasks();
            for (Task t : tasks) {
                if (!CategoryModel.getReference().isShown(t.getCategory())) continue;
                String tx = t.getSummary() + " " + t.getDescription() + " " + t.getResolution();
                Collection<Subtask> subtasks = this.getSubTasks(t.getKey());
                for (Subtask st : subtasks) {
                    tx = tx + " " + st.getDescription();
                }
                if (!criteria.search(tx) || criteria.getCategory().equals(CategoryModel.UNCATEGORIZED) && t.getCategory() != null && !t.getCategory().equals(CategoryModel.UNCATEGORIZED) || !criteria.getCategory().equals("") && !criteria.getCategory().equals(CategoryModel.UNCATEGORIZED) && !criteria.getCategory().equals(t.getCategory())) continue;
                if (criteria.hasLinks()) {
                    LinkModel lm = LinkModel.getReference();
                    try {
                        Collection<Link> lnks = lm.getLinks(t);
                        if (lnks.isEmpty()) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
                res.add(t);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return res;
    }

    @Override
    public String getExportName() {
        return "TASKS";
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"tasks") + ": " + this.getTasks().size() + "\n" + Resource.getResourceString((String)"SubTasks") + ": " + this.getSubTasks().size() + "\n" + Resource.getResourceString((String)"Logs") + ": " + this.getLogs().size() + "\n" + Resource.getResourceString((String)"projects") + ": " + TaskModel.getReference().getProjects().size();
    }

    @XmlRootElement(name="TASKS")
    private static class XmlContainer {
        public Collection<Option> OPTION;
        public Collection<Project> Project;
        public Collection<Task> Task;
        public Collection<Subtask> Subtask;
        public Collection<Tasklog> Tasklog;

        private XmlContainer() {
        }
    }
}

