/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db.jdbc;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.model.db.CheckListDB;
import net.sf.borg.model.db.jdbc.JdbcDB;
import net.sf.borg.model.db.jdbc.JdbcDBUpgrader;
import net.sf.borg.model.entity.CheckList;

class CheckListJdbcDB
implements CheckListDB {
    public CheckListJdbcDB() {
        new JdbcDBUpgrader("select name from checkLists", "CREATE CACHED TABLE checkLists (name varchar(50) NOT NULL,text longvarchar,PRIMARY KEY (name));").upgrade();
    }

    @Override
    public void addCheckList(CheckList m) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO checkLists ( name, text )  VALUES ( ?, ? )");
        stmt.setString(1, m.getCheckListName());
        stmt.setString(2, CheckListJdbcDB.getItemsXml(m));
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public void delete(String name) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("DELETE FROM checkLists WHERE name = ?");
        stmt.setString(1, name);
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public Collection<String> getNames() throws Exception {
        ArrayList<String> keys = new ArrayList<String>();
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT name FROM checkLists ORDER BY name");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            keys.add(rs.getString("name"));
        }
        rs.close();
        stmt.close();
        return keys;
    }

    private PreparedStatement getPSOne(String name) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM checkLists WHERE name = ?");
        stmt.setString(1, name);
        return stmt;
    }

    private PreparedStatement getPSAll() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM checkLists");
        return stmt;
    }

    private CheckList createFrom(ResultSet r) throws Exception {
        CheckList m = new CheckList();
        m.setCheckListName(r.getString("name"));
        CheckListJdbcDB.setItemsFromXml(m, r.getString("text"));
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CheckList> readAll() throws Exception {
        PreparedStatement stmt = null;
        ResultSet r = null;
        try {
            stmt = this.getPSAll();
            r = stmt.executeQuery();
            ArrayList<CheckList> lst = new ArrayList<CheckList>();
            while (r.next()) {
                CheckList bean = this.createFrom(r);
                lst.add(bean);
            }
            ArrayList<CheckList> arrayList = lst;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckList readCheckList(String name) throws Exception {
        PreparedStatement stmt = null;
        ResultSet r = null;
        try {
            CheckList m = null;
            stmt = this.getPSOne(name);
            r = stmt.executeQuery();
            if (r.next()) {
                m = this.createFrom(r);
            }
            CheckList checkList = m;
            return checkList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public void updateCheckList(CheckList m) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("UPDATE checkLists SET  text = ? WHERE name = ?");
        stmt.setString(1, CheckListJdbcDB.getItemsXml(m));
        stmt.setString(2, m.getCheckListName());
        stmt.executeUpdate();
        stmt.close();
    }

    private static String getItemsXml(CheckList cl) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.items = cl.getItems();
        StringWriter sw = new StringWriter();
        m.marshal((Object)container, (Writer)sw);
        return sw.toString();
    }

    private static void setItemsFromXml(CheckList cl, String itemXml) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal((Reader)new StringReader(itemXml));
        cl.getItems().clear();
        if (container.items != null) {
            cl.getItems().addAll(container.items);
        }
    }

    @XmlRootElement(name="ITEMS")
    private static class XmlContainer {
        public Collection<CheckList.Item> items;

        private XmlContainer() {
        }
    }
}

