/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.borg.model.db.MemoDB;
import net.sf.borg.model.db.jdbc.JdbcDB;
import net.sf.borg.model.db.jdbc.JdbcDBUpgrader;
import net.sf.borg.model.entity.Memo;

class MemoJdbcDB
implements MemoDB {
    public MemoJdbcDB() {
        new JdbcDBUpgrader("select encrypted from memos", "alter table memos add column encrypted char(1) default null").upgrade();
    }

    @Override
    public void addMemo(Memo m) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO memos ( memoname, memotext, encrypted )  VALUES ( ?, ?, ? )");
        stmt.setString(1, m.getMemoName());
        stmt.setString(2, m.getMemoText());
        if (m.isEncrypted()) {
            stmt.setString(3, "Y");
        } else {
            stmt.setString(3, "N");
        }
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public void delete(String name) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("DELETE FROM memos WHERE memoname = ?");
        stmt.setString(1, name);
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public Collection<String> getNames() throws Exception {
        ArrayList<String> keys = new ArrayList<String>();
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT memoname FROM memos ORDER BY memoname");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            keys.add(rs.getString("memoname"));
        }
        rs.close();
        stmt.close();
        return keys;
    }

    private static PreparedStatement getPSOne(String name) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM memos WHERE memoname = ?");
        stmt.setString(1, name);
        return stmt;
    }

    private static PreparedStatement getPSAll() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM memos");
        return stmt;
    }

    private static Memo createFrom(ResultSet r) throws SQLException {
        Memo m = new Memo();
        m.setMemoName(r.getString("memoname"));
        m.setMemoText(r.getString("memotext"));
        String enc = r.getString("encrypted");
        if (enc != null && enc.equals("Y")) {
            m.setEncrypted(true);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Memo> readAll() throws Exception {
        PreparedStatement stmt = null;
        ResultSet r = null;
        try {
            stmt = MemoJdbcDB.getPSAll();
            r = stmt.executeQuery();
            ArrayList<Memo> lst = new ArrayList<Memo>();
            while (r.next()) {
                Memo bean = MemoJdbcDB.createFrom(r);
                lst.add(bean);
            }
            ArrayList<Memo> arrayList = lst;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Memo readMemo(String name) throws Exception {
        PreparedStatement stmt = null;
        ResultSet r = null;
        try {
            Memo m = null;
            stmt = MemoJdbcDB.getPSOne(name);
            r = stmt.executeQuery();
            if (r.next()) {
                m = MemoJdbcDB.createFrom(r);
            }
            Memo memo = m;
            return memo;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public void updateMemo(Memo m) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("UPDATE memos SET  memotext = ?, encrypted = ? WHERE memoname = ?");
        stmt.setString(1, m.getMemoText());
        if (m.isEncrypted()) {
            stmt.setString(2, "Y");
        } else {
            stmt.setString(2, "N");
        }
        stmt.setString(3, m.getMemoName());
        stmt.executeUpdate();
        stmt.close();
    }
}

