/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import net.sf.borg.model.db.TaskDB;
import net.sf.borg.model.db.jdbc.JdbcBeanDB;
import net.sf.borg.model.db.jdbc.JdbcDB;
import net.sf.borg.model.db.jdbc.JdbcDBUpgrader;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.model.entity.Tasklog;

class TaskJdbcDB
extends JdbcBeanDB<Task>
implements TaskDB {
    public TaskJdbcDB() {
        new JdbcDBUpgrader("select summary from tasks", "alter table tasks add column summary longvarchar;alter table tasks modify column description longvarchar").upgrade();
    }

    @Override
    public void addObj(Task task) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO tasks ( tasknum, start_date, due_date, person_assigned, priority, state, type, description, resolution, category, close_date, project, summary) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setInt(1, task.getKey());
        Date sd = task.getStartDate();
        if (sd != null) {
            stmt.setDate(2, new java.sql.Date(sd.getTime()));
        } else {
            stmt.setDate(2, null);
        }
        Date dd = task.getDueDate();
        if (dd != null) {
            stmt.setDate(3, new java.sql.Date(dd.getTime()));
        } else {
            stmt.setDate(3, null);
        }
        stmt.setString(4, task.getPersonAssigned());
        if (task.getPriority() != null) {
            stmt.setInt(5, task.getPriority());
        } else {
            stmt.setInt(5, 1);
        }
        stmt.setString(6, task.getState());
        stmt.setString(7, task.getType());
        stmt.setString(8, task.getDescription());
        stmt.setString(9, task.getResolution());
        stmt.setString(10, task.getCategory());
        Date cd = task.getCompletionDate();
        if (cd != null) {
            stmt.setDate(11, new java.sql.Date(cd.getTime()));
        } else {
            stmt.setDate(11, null);
        }
        if (task.getProject() != null) {
            stmt.setInt(12, task.getProject());
        } else {
            stmt.setNull(12, 4);
        }
        stmt.setString(13, task.getSummary());
        stmt.executeUpdate();
        this.writeCache(task);
        stmt.close();
    }

    @Override
    public void delete(int key) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("DELETE FROM tasks WHERE tasknum = ?");
        stmt.setInt(1, key);
        stmt.executeUpdate();
        stmt.close();
        this.delCache(key);
    }

    public Collection<Integer> getKeys() throws Exception {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT tasknum FROM tasks");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            keys.add(new Integer(rs.getInt("tasknum")));
        }
        rs.close();
        stmt.close();
        return keys;
    }

    @Override
    public int nextkey() throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT MAX(tasknum) FROM tasks");
        ResultSet r = stmt.executeQuery();
        int maxKey = 0;
        if (r.next()) {
            maxKey = r.getInt(1);
        }
        r.close();
        stmt.close();
        return ++maxKey;
    }

    @Override
    public Task newObj() {
        return new Task();
    }

    @Override
    PreparedStatement getPSOne(int key) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM tasks WHERE tasknum = ?");
        stmt.setInt(1, key);
        return stmt;
    }

    @Override
    PreparedStatement getPSAll() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM tasks");
        return stmt;
    }

    @Override
    Task createFrom(ResultSet r) throws SQLException {
        Task task = new Task();
        task.setKey(r.getInt("tasknum"));
        task.setStartDate(r.getDate("start_date"));
        if (r.getDate("due_date") != null) {
            task.setDueDate(new Date(r.getDate("due_date").getTime()));
        }
        task.setPersonAssigned(r.getString("person_assigned"));
        task.setPriority(new Integer(r.getInt("priority")));
        task.setState(r.getString("state"));
        task.setType(r.getString("type"));
        task.setDescription(r.getString("description"));
        task.setResolution(r.getString("resolution"));
        task.setCategory(r.getString("category"));
        if (r.getDate("close_date") != null) {
            task.setCompletionDate(new Date(r.getDate("close_date").getTime()));
        }
        task.setProject((Integer)r.getObject("project"));
        task.setSummary(r.getString("summary"));
        return task;
    }

    @Override
    public void updateObj(Task task) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("UPDATE tasks SET  start_date = ?, due_date = ?, person_assigned = ?, priority = ?, state = ?, type = ?, description = ?, resolution = ?, category = ?, close_date = ?, project = ?, summary = ? WHERE tasknum = ?");
        Date sd = task.getStartDate();
        if (sd != null) {
            stmt.setDate(1, new java.sql.Date(sd.getTime()));
        } else {
            stmt.setDate(1, null);
        }
        Date dd = task.getDueDate();
        if (dd != null) {
            stmt.setDate(2, new java.sql.Date(dd.getTime()));
        } else {
            stmt.setDate(2, null);
        }
        stmt.setString(3, task.getPersonAssigned());
        stmt.setInt(4, task.getPriority());
        stmt.setString(5, task.getState());
        stmt.setString(6, task.getType());
        stmt.setString(7, task.getDescription());
        stmt.setString(8, task.getResolution());
        stmt.setString(9, task.getCategory());
        Date cd = task.getCompletionDate();
        if (cd != null) {
            stmt.setDate(10, new java.sql.Date(cd.getTime()));
        } else {
            stmt.setDate(10, null);
        }
        if (task.getProject() != null) {
            stmt.setInt(11, task.getProject());
        } else {
            stmt.setNull(11, 4);
        }
        stmt.setString(12, task.getSummary());
        stmt.setInt(13, task.getKey());
        stmt.executeUpdate();
        this.delCache(task.getKey());
        this.writeCache(task);
        stmt.close();
    }

    private static Subtask createSubtask(ResultSet r) throws SQLException {
        Subtask s = new Subtask();
        s.setKey(r.getInt("id"));
        s.setTask(new Integer(r.getInt("task")));
        if (r.getTimestamp("due_date") != null) {
            s.setDueDate(new Date(r.getTimestamp("due_date").getTime()));
        }
        if (r.getTimestamp("create_date") != null) {
            s.setStartDate(new Date(r.getTimestamp("create_date").getTime()));
        }
        if (r.getTimestamp("close_date") != null) {
            s.setCloseDate(new Date(r.getTimestamp("close_date").getTime()));
        }
        s.setDescription(r.getString("description"));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Subtask> getSubTasks(int taskid) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from subtasks where task = ?");
        ResultSet r = null;
        try {
            stmt.setInt(1, taskid);
            r = stmt.executeQuery();
            ArrayList<Subtask> lst = new ArrayList<Subtask>();
            while (r.next()) {
                Subtask s = TaskJdbcDB.createSubtask(r);
                lst.add(s);
            }
            ArrayList<Subtask> arrayList = lst;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Subtask> getSubTasks() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from subtasks");
        ResultSet r = null;
        try {
            r = stmt.executeQuery();
            ArrayList<Subtask> lst = new ArrayList<Subtask>();
            while (r.next()) {
                Subtask s = TaskJdbcDB.createSubtask(r);
                lst.add(s);
            }
            ArrayList<Subtask> arrayList = lst;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subtask getSubTask(int id) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from subtasks WHERE id = ?");
        stmt.setInt(1, id);
        Subtask p = null;
        ResultSet r = null;
        try {
            r = stmt.executeQuery();
            if (r.next()) {
                p = TaskJdbcDB.createSubtask(r);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            stmt.close();
        }
        return p;
    }

    @Override
    public void deleteSubTask(int id) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("DELETE FROM subtasks WHERE id = ?");
        stmt.setInt(1, id);
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public void addSubTask(Subtask s) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO subtasks ( id, create_date, due_date, close_date, description, task ) VALUES ( ?, ?, ?, ?, ?, ?)");
        stmt.setInt(1, s.getKey());
        Date sd = s.getStartDate();
        if (sd != null) {
            stmt.setDate(2, new java.sql.Date(sd.getTime()));
        } else {
            stmt.setDate(2, null);
        }
        Date dd = s.getDueDate();
        if (dd != null) {
            stmt.setDate(3, new java.sql.Date(dd.getTime()));
        } else {
            stmt.setDate(3, null);
        }
        Date cd = s.getCloseDate();
        if (cd != null) {
            stmt.setDate(4, new java.sql.Date(cd.getTime()));
        } else {
            stmt.setDate(4, null);
        }
        stmt.setString(5, s.getDescription());
        stmt.setInt(6, s.getTask());
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public void updateSubTask(Subtask s) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("UPDATE subtasks SET create_date = ?, due_date = ?, close_date = ?, description = ?, task = ?  WHERE id = ?");
        stmt.setInt(6, s.getKey());
        Date sd = s.getStartDate();
        if (sd != null) {
            stmt.setDate(1, new java.sql.Date(sd.getTime()));
        } else {
            stmt.setDate(1, null);
        }
        Date dd = s.getDueDate();
        if (dd != null) {
            stmt.setDate(2, new java.sql.Date(dd.getTime()));
        } else {
            stmt.setDate(2, null);
        }
        Date cd = s.getCloseDate();
        if (cd != null) {
            stmt.setDate(3, new java.sql.Date(cd.getTime()));
        } else {
            stmt.setDate(3, null);
        }
        stmt.setString(4, s.getDescription());
        stmt.setInt(5, s.getTask());
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public int nextSubTaskKey() throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT MAX(id) FROM subtasks");
        ResultSet r = stmt.executeQuery();
        int maxKey = 0;
        if (r.next()) {
            maxKey = r.getInt(1);
        }
        r.close();
        stmt.close();
        return ++maxKey;
    }

    private static int nextLogKey() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT MAX(id) FROM tasklog");
        ResultSet r = stmt.executeQuery();
        int maxKey = 0;
        if (r.next()) {
            maxKey = r.getInt(1);
        }
        r.close();
        stmt.close();
        return ++maxKey;
    }

    @Override
    public void addLog(int taskid, String desc) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO tasklog ( id, logtime, description, task ) VALUES ( ?, ?, ?, ?)");
        stmt.setInt(1, TaskJdbcDB.nextLogKey());
        Date now = new Date();
        stmt.setTimestamp(2, new Timestamp(now.getTime()), Calendar.getInstance());
        stmt.setString(3, desc);
        stmt.setInt(4, taskid);
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public void saveLog(Tasklog tlog) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO tasklog ( id, logtime, description, task ) VALUES ( ?, ?, ?, ?)");
        stmt.setInt(1, TaskJdbcDB.nextLogKey());
        Date d = tlog.getLogTime();
        stmt.setTimestamp(2, new Timestamp(d.getTime()), Calendar.getInstance());
        stmt.setString(3, tlog.getDescription());
        stmt.setInt(4, tlog.getTask());
        stmt.executeUpdate();
        stmt.close();
    }

    private static Tasklog createTasklog(ResultSet r) throws SQLException {
        Tasklog s = new Tasklog();
        s.setKey(r.getInt("id"));
        s.setTask(new Integer(r.getInt("task")));
        if (r.getTimestamp("logtime") != null) {
            s.setLogTime(new Date(r.getTimestamp("logtime").getTime()));
        }
        s.setDescription(r.getString("description"));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Tasklog> getLogs(int taskid) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from tasklog where task = ?");
        ResultSet r = null;
        ArrayList<Tasklog> lst = new ArrayList<Tasklog>();
        try {
            stmt.setInt(1, taskid);
            r = stmt.executeQuery();
            while (r.next()) {
                Tasklog s = TaskJdbcDB.createTasklog(r);
                lst.add(s);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Tasklog> getLogs() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from tasklog");
        ResultSet r = null;
        try {
            r = stmt.executeQuery();
            ArrayList<Tasklog> lst = new ArrayList<Tasklog>();
            while (r.next()) {
                Tasklog s = TaskJdbcDB.createTasklog(r);
                lst.add(s);
            }
            ArrayList<Tasklog> arrayList = lst;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public void addProject(Project p) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO projects ( id,start_date, due_date, description, category, status, parent ) VALUES ( ?, ?, ?, ?, ?, ?, ?)");
        stmt.setInt(1, p.getKey());
        Date sd = p.getStartDate();
        if (sd != null) {
            stmt.setDate(2, new java.sql.Date(sd.getTime()));
        } else {
            stmt.setDate(2, null);
        }
        Date dd = p.getDueDate();
        if (dd != null) {
            stmt.setDate(3, new java.sql.Date(dd.getTime()));
        } else {
            stmt.setDate(3, null);
        }
        stmt.setString(4, p.getDescription());
        stmt.setString(5, p.getCategory());
        stmt.setString(6, p.getStatus());
        if (p.getParent() != null) {
            stmt.setInt(7, p.getParent());
        } else {
            stmt.setNull(7, 4);
        }
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public void deleteProject(int id) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("DELETE FROM projects WHERE id = ?");
        stmt.setInt(1, id);
        stmt.executeUpdate();
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project getProject(int projectid) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM projects WHERE id = ?");
        stmt.setInt(1, projectid);
        Project p = null;
        ResultSet r = null;
        try {
            r = stmt.executeQuery();
            if (r.next()) {
                p = TaskJdbcDB.createProject(r);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            stmt.close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Project> getProjects() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from projects");
        ResultSet r = null;
        ArrayList<Project> lst = new ArrayList<Project>();
        try {
            r = stmt.executeQuery();
            while (r.next()) {
                Project s = TaskJdbcDB.createProject(r);
                lst.add(s);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Task> getTasks(int projectid) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from tasks where project = ?");
        ResultSet r = null;
        ArrayList<Task> lst = new ArrayList<Task>();
        try {
            stmt.setInt(1, projectid);
            r = stmt.executeQuery();
            while (r.next()) {
                Task s = this.createFrom(r);
                lst.add(s);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Project> getSubProjects(int projectid) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from projects where parent = ? ORDER BY start_date");
        ResultSet r = null;
        ArrayList<Project> lst = new ArrayList<Project>();
        try {
            stmt.setInt(1, projectid);
            r = stmt.executeQuery();
            while (r.next()) {
                Project s = TaskJdbcDB.createProject(r);
                lst.add(s);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return lst;
    }

    @Override
    public int nextProjectKey() throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT MAX(id) FROM projects");
        ResultSet r = stmt.executeQuery();
        int maxKey = 0;
        if (r.next()) {
            maxKey = r.getInt(1);
        }
        r.close();
        stmt.close();
        return ++maxKey;
    }

    @Override
    public void updateProject(Project s) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("UPDATE projects SET start_date = ?, due_date = ?, description = ?, category = ?, status = ?, parent = ?  WHERE id = ?");
        stmt.setInt(7, s.getKey());
        Date sd = s.getStartDate();
        if (sd != null) {
            stmt.setDate(1, new java.sql.Date(sd.getTime()));
        } else {
            stmt.setDate(1, null);
        }
        Date dd = s.getDueDate();
        if (dd != null) {
            stmt.setDate(2, new java.sql.Date(dd.getTime()));
        } else {
            stmt.setDate(2, null);
        }
        stmt.setString(3, s.getDescription());
        stmt.setString(4, s.getCategory());
        stmt.setString(5, s.getStatus());
        if (s.getParent() != null) {
            stmt.setInt(6, s.getParent());
        } else {
            stmt.setNull(6, 4);
        }
        stmt.executeUpdate();
        stmt.close();
    }

    private static Project createProject(ResultSet r) throws SQLException {
        Project s = new Project();
        s.setKey(r.getInt("id"));
        if (r.getTimestamp("due_date") != null) {
            s.setDueDate(new Date(r.getTimestamp("due_date").getTime()));
        }
        if (r.getTimestamp("start_date") != null) {
            s.setStartDate(new Date(r.getTimestamp("start_date").getTime()));
        }
        s.setDescription(r.getString("description"));
        s.setCategory(r.getString("category"));
        s.setStatus(r.getString("status"));
        int parent = r.getInt("parent");
        if (r.wasNull()) {
            s.setParent(null);
        } else {
            s.setParent(new Integer(parent));
        }
        return s;
    }
}

