/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.entity;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.EncryptionHelper;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.entity.EncryptableEntity;

@XmlRootElement(name="Memo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Memo
extends EncryptableEntity<Memo> {
    private static final long serialVersionUID = -6793670294661709573L;
    private String MemoName;
    private String MemoText;
    private Date Created;
    private Date Updated;

    @Override
    protected Memo clone() {
        Memo dst = new Memo();
        dst.setKey(this.getKey());
        dst.setMemoName(this.getMemoName());
        dst.setMemoText(this.getMemoText());
        dst.setEncrypted(this.isEncrypted());
        dst.setCreated(this.getCreated());
        dst.setUpdated(this.getUpdated());
        return dst;
    }

    @Override
    public void decrypt(String password) throws Exception {
        if (!this.isEncrypted()) {
            return;
        }
        EncryptionHelper helper = new EncryptionHelper(Prefs.getPref((PrefName)PrefName.KEYSTORE), password);
        String clearText = helper.decrypt(this.getMemoText(), Prefs.getPref((PrefName)PrefName.KEYALIAS));
        this.setMemoText(clearText);
        this.setEncrypted(false);
    }

    @Override
    public void encrypt(String password) throws Exception {
        if (this.isEncrypted()) {
            return;
        }
        EncryptionHelper helper = new EncryptionHelper(Prefs.getPref((PrefName)PrefName.KEYSTORE), password);
        String cipherText = helper.encrypt(this.getMemoText(), Prefs.getPref((PrefName)PrefName.KEYALIAS));
        this.setMemoText(cipherText);
        this.setEncrypted(true);
    }

    public String getMemoName() {
        return this.MemoName;
    }

    public String getMemoText() {
        return this.MemoText;
    }

    public Date getCreated() {
        return this.Created;
    }

    public Date getUpdated() {
        return this.Updated;
    }

    public void setMemoName(String MemoName) {
        this.MemoName = MemoName;
    }

    public void setMemoText(String MemoText) {
        this.MemoText = MemoText;
    }

    public void setCreated(Date Created) {
        this.Created = Created;
    }

    public void setUpdated(Date Updated) {
        this.Updated = Updated;
    }

    @Override
    public String toString() {
        return "Memo(MemoName=" + this.getMemoName() + ", MemoText=" + this.getMemoText() + ", Created=" + this.getCreated() + ", Updated=" + this.getUpdated() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Memo)) {
            return false;
        }
        Memo other = (Memo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$MemoName = this.getMemoName();
        String other$MemoName = other.getMemoName();
        if (this$MemoName == null ? other$MemoName != null : !this$MemoName.equals(other$MemoName)) {
            return false;
        }
        String this$MemoText = this.getMemoText();
        String other$MemoText = other.getMemoText();
        if (this$MemoText == null ? other$MemoText != null : !this$MemoText.equals(other$MemoText)) {
            return false;
        }
        Date this$Created = this.getCreated();
        Date other$Created = other.getCreated();
        if (this$Created == null ? other$Created != null : !((Object)this$Created).equals(other$Created)) {
            return false;
        }
        Date this$Updated = this.getUpdated();
        Date other$Updated = other.getUpdated();
        return !(this$Updated == null ? other$Updated != null : !((Object)this$Updated).equals(other$Updated));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof Memo;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        String $MemoName = this.getMemoName();
        result = result * 31 + ($MemoName == null ? 0 : $MemoName.hashCode());
        String $MemoText = this.getMemoText();
        result = result * 31 + ($MemoText == null ? 0 : $MemoText.hashCode());
        Date $Created = this.getCreated();
        result = result * 31 + ($Created == null ? 0 : ((Object)$Created).hashCode());
        Date $Updated = this.getUpdated();
        result = result * 31 + ($Updated == null ? 0 : ((Object)$Updated).hashCode());
        return result;
    }
}

