/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.entity;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.KeyedEntity;

@XmlRootElement(name="Project")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Project
extends KeyedEntity<Project>
implements CalendarEntity {
    private static final long serialVersionUID = -3250115693306817331L;
    private Date StartDate;
    private Date DueDate;
    private String Description;
    private String Category;
    private String Status;
    private Integer Parent;

    @Override
    protected Project clone() {
        Project dst = new Project();
        dst.setKey(this.getKey());
        dst.setStartDate(this.getStartDate());
        dst.setDueDate(this.getDueDate());
        dst.setDescription(this.getDescription());
        dst.setCategory(this.getCategory());
        dst.setStatus(this.getStatus());
        dst.setParent(this.getParent());
        return dst;
    }

    @Override
    public String getColor() {
        return "navy";
    }

    @Override
    public Integer getDuration() {
        return new Integer(0);
    }

    @Override
    public Date getDate() {
        return this.getDueDate();
    }

    @Override
    public boolean isTodo() {
        return true;
    }

    @Override
    public Date getNextTodo() {
        return null;
    }

    @Override
    public String getText() {
        String showabb = Prefs.getPref((PrefName)PrefName.TASK_SHOW_ABBREV);
        String abb = "";
        if (showabb.equals("true")) {
            abb = "PR" + this.getKey() + " ";
        }
        String de = abb + this.getDescription();
        String tx = de.replace('\n', ' ');
        return tx;
    }

    @Override
    public Integer getPriority() {
        return null;
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public Date getDueDate() {
        return this.DueDate;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getCategory() {
        return this.Category;
    }

    public String getStatus() {
        return this.Status;
    }

    public Integer getParent() {
        return this.Parent;
    }

    public void setStartDate(Date StartDate) {
        this.StartDate = StartDate;
    }

    public void setDueDate(Date DueDate) {
        this.DueDate = DueDate;
    }

    public void setDescription(String Description) {
        this.Description = Description;
    }

    public void setCategory(String Category2) {
        this.Category = Category2;
    }

    public void setStatus(String Status) {
        this.Status = Status;
    }

    public void setParent(Integer Parent) {
        this.Parent = Parent;
    }

    @Override
    public String toString() {
        return "Project(StartDate=" + this.getStartDate() + ", DueDate=" + this.getDueDate() + ", Description=" + this.getDescription() + ", Category=" + this.getCategory() + ", Status=" + this.getStatus() + ", Parent=" + this.getParent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Date this$StartDate = this.getStartDate();
        Date other$StartDate = other.getStartDate();
        if (this$StartDate == null ? other$StartDate != null : !((Object)this$StartDate).equals(other$StartDate)) {
            return false;
        }
        Date this$DueDate = this.getDueDate();
        Date other$DueDate = other.getDueDate();
        if (this$DueDate == null ? other$DueDate != null : !((Object)this$DueDate).equals(other$DueDate)) {
            return false;
        }
        String this$Description = this.getDescription();
        String other$Description = other.getDescription();
        if (this$Description == null ? other$Description != null : !this$Description.equals(other$Description)) {
            return false;
        }
        String this$Category = this.getCategory();
        String other$Category = other.getCategory();
        if (this$Category == null ? other$Category != null : !this$Category.equals(other$Category)) {
            return false;
        }
        String this$Status = this.getStatus();
        String other$Status = other.getStatus();
        if (this$Status == null ? other$Status != null : !this$Status.equals(other$Status)) {
            return false;
        }
        Integer this$Parent = this.getParent();
        Integer other$Parent = other.getParent();
        return !(this$Parent == null ? other$Parent != null : !((Object)this$Parent).equals(other$Parent));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        Date $StartDate = this.getStartDate();
        result = result * 31 + ($StartDate == null ? 0 : ((Object)$StartDate).hashCode());
        Date $DueDate = this.getDueDate();
        result = result * 31 + ($DueDate == null ? 0 : ((Object)$DueDate).hashCode());
        String $Description = this.getDescription();
        result = result * 31 + ($Description == null ? 0 : $Description.hashCode());
        String $Category = this.getCategory();
        result = result * 31 + ($Category == null ? 0 : $Category.hashCode());
        String $Status = this.getStatus();
        result = result * 31 + ($Status == null ? 0 : $Status.hashCode());
        Integer $Parent = this.getParent();
        result = result * 31 + ($Parent == null ? 0 : ((Object)$Parent).hashCode());
        return result;
    }
}

