/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.tool;

import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import net.sf.borg.common.DateUtil;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.db.AppointmentDB;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.tool.ConversionTool;

public class ApptKeyConverter
implements ConversionTool {
    public static void main(String[] args) {
        try {
            new ApptKeyConverter().convert();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void convert() throws Exception {
        String dbdir = DBHelper.getController().buildURL();
        if (dbdir.equals("not-set")) {
            return;
        }
        DBHelper.getController().connect(dbdir);
        try {
            DBHelper.getController().execSQL("ALTER table appointments drop new");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table appointments drop deleted");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table appointments drop modified");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table appointments drop alarm");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table addresses drop new");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table addresses drop deleted");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table addresses drop modified");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table memos drop new");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table memos drop deleted");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table memos drop modified");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table memos drop palmid");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DBHelper.getController().execSQL("ALTER table memos drop private");
        }
        catch (Exception e) {
            // empty catch block
        }
        AppointmentDB db = DBHelper.getFactory().createAppointmentDB();
        try {
            DBHelper.getController().beginTransaction();
            int lowestKey = 1;
            Collection appts = db.readAll();
            for (Appointment oldappt : appts) {
                Appointment ap;
                if (oldappt.getKey() < 10000000) continue;
                System.out.println("Processing appt: " + oldappt.getKey());
                while ((ap = (Appointment)db.readObj(lowestKey)) != null) {
                    ++lowestKey;
                }
                System.out.println("New Key: " + lowestKey);
                Appointment newappt = (Appointment)oldappt.copy();
                newappt.setKey(lowestKey);
                Vector<String> skipList = newappt.getSkipList();
                if (skipList != null && skipList.size() > 0) {
                    for (int i = 0; i < skipList.size(); ++i) {
                        String key = skipList.elementAt(i);
                        int val = Integer.parseInt(key);
                        if (val < 900000) continue;
                        int yr = val / 1000000 % 1000 + 1900;
                        int mo = val / 10000 % 100 - 1;
                        int day = val / 100 % 100;
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.set(yr, mo, day);
                        skipList.setElementAt(Integer.toString(DateUtil.dayOfEpoch((Date)cal.getTime())), i);
                    }
                    newappt.setSkipList(skipList);
                }
                db.addObj(newappt);
                LinkModel.getReference().moveLinks(oldappt, newappt);
                db.delete(oldappt.getKey());
                ++lowestKey;
            }
            DBHelper.getController().commitTransaction();
        }
        catch (Exception e) {
            DBHelper.getController().rollbackTransaction();
            throw e;
        }
        finally {
            DBHelper.getController().close();
        }
    }
}

