/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import java.text.DateFormat;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.undo.UndoItem;

public class AppointmentUndoItem
extends UndoItem<Appointment> {
    @Override
    public void executeUndo() {
        if (this.action == UndoItem.actionType.DELETE) {
            AppointmentModel.getReference().saveAppt((Appointment)this.item, true);
        } else if (this.action == UndoItem.actionType.UPDATE) {
            AppointmentModel.getReference().saveAppt((Appointment)this.item, true);
        } else if (this.action == UndoItem.actionType.ADD) {
            AppointmentModel.getReference().delAppt((Appointment)this.item, true);
        }
    }

    private AppointmentUndoItem() {
    }

    private static String apptString(Appointment appt) {
        String txt;
        String string = txt = appt.getText().length() < 20 ? appt.getText() : appt.getText().substring(0, 19);
        if (appt.isEncrypted()) {
            txt = Resource.getResourceString((String)"EncryptedItemShort");
        }
        return "[" + DateFormat.getDateInstance(3).format(appt.getDate()) + "] " + txt;
    }

    public static AppointmentUndoItem recordUpdate(Appointment appt) {
        AppointmentUndoItem undoItem = new AppointmentUndoItem();
        undoItem.item = appt;
        undoItem.action = UndoItem.actionType.UPDATE;
        undoItem.setDescription(Resource.getResourceString((String)"Change") + " " + Resource.getResourceString((String)"appointment") + " " + AppointmentUndoItem.apptString(appt));
        return undoItem;
    }

    public static AppointmentUndoItem recordAdd(Appointment appt) {
        AppointmentUndoItem undoItem = new AppointmentUndoItem();
        undoItem.item = appt;
        undoItem.action = UndoItem.actionType.ADD;
        undoItem.setDescription(Resource.getResourceString((String)"Add") + " " + Resource.getResourceString((String)"appointment") + " " + AppointmentUndoItem.apptString(appt));
        return undoItem;
    }

    public static AppointmentUndoItem recordDelete(Appointment appt) {
        AppointmentUndoItem undoItem = new AppointmentUndoItem();
        undoItem.item = appt;
        undoItem.action = UndoItem.actionType.DELETE;
        undoItem.setDescription(Resource.getResourceString((String)"Delete") + " " + Resource.getResourceString((String)"appointment") + " " + AppointmentUndoItem.apptString(appt));
        return undoItem;
    }
}

