/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import net.sf.borg.model.undo.UndoItem;

public class UndoLog {
    private Stack<UndoItem<?>> undoStack = new Stack();
    private static UndoLog singleton = new UndoLog();

    public static UndoLog getReference() {
        return singleton;
    }

    private UndoLog() {
    }

    public void addItem(UndoItem<?> item) {
        this.undoStack.push(item);
    }

    public final String getTopItem() {
        if (this.undoStack.empty()) {
            return null;
        }
        return this.undoStack.peek().getDescription();
    }

    public Collection<String> getItemStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        for (UndoItem undoItem : this.undoStack) {
            strings.add(0, undoItem.getDescription());
        }
        return strings;
    }

    public void executeUndo() {
        if (!this.undoStack.empty()) {
            UndoItem<?> item = this.undoStack.pop();
            item.executeUndo();
        }
    }

    public void clear() {
        this.undoStack.clear();
    }

    Stack<UndoItem<?>> getItems() {
        return this.undoStack;
    }
}

