/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import biz.source_code.base64Coder.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;

public class EncryptionHelper {
    private KeyStore keyStore;
    private String password;

    public static void createStore(String location, String password) throws Exception {
        KeyStore store = KeyStore.getInstance("JCEKS");
        store.load(null, password.toCharArray());
        FileOutputStream fos = new FileOutputStream(location);
        store.store(fos, password.toCharArray());
        fos.close();
    }

    public static void generateKey(String location, String password, String name) throws Exception {
        KeyStore store = KeyStore.getInstance("JCEKS");
        FileInputStream fis = new FileInputStream(location);
        store.load(fis, password.toCharArray());
        fis.close();
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        SecretKey key = keyGen.generateKey();
        KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(key);
        store.setEntry(name, skEntry, new KeyStore.PasswordProtection(password.toCharArray()));
        FileOutputStream fos = new FileOutputStream(location);
        store.store(fos, password.toCharArray());
        fos.close();
    }

    public EncryptionHelper(String keyStoreLocation, String keyStorePassword) throws Exception {
        this.password = keyStorePassword;
        if (keyStoreLocation == null || keyStoreLocation.equals("")) {
            throw new Warning(Resource.getResourceString("Key_Store_Not_Set"));
        }
        File f = new File(keyStoreLocation);
        if (!f.canRead()) {
            throw new Warning(Resource.getResourceString("No_Key_Store") + keyStoreLocation);
        }
        this.keyStore = KeyStore.getInstance("JCEKS");
        FileInputStream fis = new FileInputStream(keyStoreLocation);
        this.keyStore.load(fis, this.password.toCharArray());
        fis.close();
    }

    public String encrypt(String clearText, String keyAlias) throws Exception {
        Key key = this.keyStore.getKey(keyAlias, this.password.toCharArray());
        Cipher enc = Cipher.getInstance("AES");
        enc.init(1, key);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, enc);
        ((OutputStream)os).write(clearText.getBytes());
        ((OutputStream)os).close();
        byte[] ba = baos.toByteArray();
        return new String(Base64Coder.encode((byte[])ba));
    }

    public String decrypt(String cipherText, String keyAlias) throws Exception {
        Key key = this.keyStore.getKey(keyAlias, this.password.toCharArray());
        Cipher dec = Cipher.getInstance("AES");
        dec.init(2, key);
        byte[] decba = Base64Coder.decodeLines((String)cipherText);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, dec);
        ((OutputStream)os).write(decba);
        ((OutputStream)os).close();
        return baos.toString();
    }

    public String exportKey(String keyAlias, String keyStorePassword) throws Exception {
        Key key = this.keyStore.getKey(keyAlias, keyStorePassword.toCharArray());
        return new String(Base64Coder.encode((byte[])key.getEncoded()));
    }

    public static void importKey(String location, String encodedKey, String keyAlias, String password) throws Exception {
        KeyStore store = KeyStore.getInstance("JCEKS");
        FileInputStream fis = new FileInputStream(location);
        store.load(fis, password.toCharArray());
        fis.close();
        byte[] ba = Base64Coder.decode((String)encodedKey);
        SecretKeySpec key = new SecretKeySpec(ba, "AES");
        KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(key);
        store.setEntry(keyAlias, skEntry, new KeyStore.PasswordProtection(password.toCharArray()));
        FileOutputStream fos = new FileOutputStream(location);
        store.store(fos, password.toCharArray());
        fos.close();
    }
}

