/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sf.borg.common.Errmsg;

public class Resource {
    private static String version_ = null;

    public static String getRawResourceString(String key) {
        try {
            String res = ResourceBundle.getBundle("borg_resource").getString(key);
            if (res.indexOf("\\n") == -1) {
                return res;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < res.length(); ++i) {
                if (res.charAt(i) == '\\' && i < res.length() - 1 && res.charAt(i + 1) == 'n') {
                    ++i;
                    sb.append('\n');
                    continue;
                }
                sb.append(res.charAt(i));
            }
            return sb.toString();
        }
        catch (MissingResourceException m) {
            return "?" + key + "?";
        }
    }

    public static String getResourceString(String resourceKey, Object[] params) {
        return MessageFormat.format(Resource.getResourceString(resourceKey), params);
    }

    public static String getResourceString(String resourceKey) {
        return Resource.parseResourceText(Resource.getRawResourceString(resourceKey));
    }

    public static String getVersion() {
        if (version_ == null) {
            try {
                InputStream is = Resource.class.getResource("/properties").openStream();
                Properties props = new Properties();
                props.load(is);
                is.close();
                version_ = props.getProperty("borg.version");
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        return version_;
    }

    private static String parseResourceText(String s) {
        int pos = s.indexOf(124);
        if (pos != -1) {
            return s.substring(0, pos);
        }
        return s;
    }
}

