/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;
import org.mydragonfly.pj.TagSelector;
import org.mydragonfly.pj.data.Entry;
import org.mydragonfly.pj.data.Journal;
import org.mydragonfly.pj.service.TagService;

public class EntryForm
extends JPanel {
    static final Logger logger = Logger.getLogger(EntryForm.class);
    private static final long serialVersionUID = -2186454712718090348L;
    public JCheckBox private_checkBox;
    public JTextField date_textField;
    private JScrollPane jScrollPane1;
    public JTextField desc_textField;
    public JTextArea entry_textField;
    public TagSelector entryTagSelector;
    public static Format formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss", Locale.getDefault());
    private Journal currentJournal = null;
    protected JLabel journalName = new JLabel("");
    protected JLabel entryId = new JLabel("---");
    private Entry currentEntry;
    private boolean dirtyEntry = false;

    public EntryForm() {
        this.initForm();
    }

    public EntryForm(boolean bl) {
        super(bl);
        this.initForm();
    }

    private void resetFields() {
        if (this.currentJournal == null) {
            this.journalName.setText("");
        } else {
            this.journalName.setText(this.currentJournal.getTitle());
        }
        this.entryId.setText("---");
        this.private_checkBox.setSelected(false);
        this.date_textField.setText(this.getFormattedTimeStamp());
        this.desc_textField.setText("");
        this.entryTagSelector.resetAllTags(TagService.toNameArray(TagService.getAllTags()), null);
        this.entryTagSelector.setUnselectedTagDisplayCount(8);
        this.entryTagSelector.setUnselectedTagDisplayCount(8);
        this.entry_textField.setText("");
        this.entry_textField.setLineWrap(true);
        this.entry_textField.setWrapStyleWord(true);
    }

    protected void setCurrentEntry(Entry entry) {
        this.currentEntry = entry;
        if (this.currentEntry == null) {
            this.resetFields();
            this.currentEntry = new Entry();
            this.dirtyEntry = true;
            return;
        }
        this.entryId.setText(this.currentEntry.getId() + "");
        this.private_checkBox.setSelected(entry.getPrivateEntry());
        this.date_textField.setText(formatter.format(entry.getCreateDate()));
        this.desc_textField.setText(entry.getDescription());
        this.entryTagSelector.resetAllTags(TagService.toNameArray(TagService.getAllTags()), TagService.toNameArray(entry.getTags()));
        this.entry_textField.setText(entry.getContent());
        this.dirtyEntry = false;
    }

    public String getFormattedTimeStamp() {
        return formatter.format(new Date());
    }

    protected void initForm() {
        this.private_checkBox = new JCheckBox();
        this.date_textField = new JTextField(this.getFormattedTimeStamp());
        this.desc_textField = new JTextField(170);
        this.desc_textField.setText("");
        this.entryTagSelector = new TagSelector(TagService.toNameArray(TagService.getAllTags()));
        FormLayout formLayout = new FormLayout("4dlu, pref, 4dlu, 100dlu, 4dlu, 50dlu:grow(0.9), 8dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref:grow, 8dlu");
        this.setLayout((LayoutManager)formLayout);
        this.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
        CellConstraints cellConstraints = new CellConstraints();
        this.add((Component)new JLabel("Journal:"), cellConstraints.xy(2, 2));
        this.add((Component)this.journalName, new CellConstraints(4, 2, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT));
        this.add((Component)new JLabel("ID:"), cellConstraints.xy(2, 4));
        this.add((Component)this.entryId, cellConstraints.xy(4, 4));
        this.add((Component)new JLabel("Private"), cellConstraints.xy(2, 6));
        this.add((Component)this.private_checkBox, cellConstraints.xy(4, 6));
        this.add((Component)new JLabel("Date"), cellConstraints.xy(2, 8));
        this.add((Component)this.date_textField, cellConstraints.xy(4, 8));
        this.add((Component)new JLabel("Description"), cellConstraints.xy(2, 10));
        this.add((Component)this.desc_textField, new CellConstraints(4, 10, 3, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.add((Component)new JLabel("Tags"), cellConstraints.xy(2, 12));
        this.add((Component)this.entryTagSelector, new CellConstraints(4, 12, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT));
        this.add((Component)new JLabel("Entry"), new CellConstraints(2, 14, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.jScrollPane1 = new JScrollPane();
        this.add((Component)this.jScrollPane1, new CellConstraints(4, 14, 3, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.entry_textField = new JTextArea(25, 50);
        this.jScrollPane1.setViewportView(this.entry_textField);
        this.setVisible(true);
    }

    public void setCurrentJournal(Journal journal) {
        this.currentJournal = journal;
        this.resetFields();
        this.setCurrentEntry(null);
    }

    public Date getDateValue() {
        try {
            return (Date)formatter.parseObject(this.date_textField.getText());
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    public String getDescriptionValue() {
        return this.desc_textField.getText();
    }

    public boolean getPrivateValue() {
        return this.private_checkBox.isSelected();
    }

    public Set<String> getTagValues() {
        return this.entryTagSelector.getSelectedTags();
    }

    public String getEntryValue() {
        return this.entry_textField.getText();
    }

    protected boolean isDirtyEntry() {
        return this.dirtyEntry;
    }

    protected void setDirtyEntry(boolean bl) {
        this.dirtyEntry = bl;
    }

    public Entry getCurrentEntry() {
        return this.currentEntry;
    }
}

