/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.mydragonfly.pj.DragonflyJournal;
import org.mydragonfly.pj.EntryForm;
import org.mydragonfly.pj.data.Entry;
import org.mydragonfly.pj.data.EntryDateComparator;
import org.mydragonfly.pj.data.Journal;
import org.mydragonfly.pj.service.JournalService;
import org.mydragonfly.pj.service.TagService;

public class JournalView
extends JPanel {
    private static final long serialVersionUID = -8622828362417642938L;
    private static final Logger logger = Logger.getLogger(JournalView.class);
    private JLabel jLabel1;
    Format formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss", Locale.getDefault());
    private JScrollPane jScrollPane1;
    private JTable Journal_Table;
    private Journal currentJournal = null;
    private EntryViewSorter rowSorter;
    protected JLabel journalName = new JLabel("");
    private JLabel jLabel2;
    protected JTextField filterView;
    private static final String LOCK_ICON = "org/mydragonfly/pj/resources/icons/lock.png";
    private static Image lock;

    public JournalView() {
        this.initForm();
    }

    public JournalView(boolean bl) {
        super(bl);
        this.initForm();
    }

    private void initForm() {
        try {
            this.jLabel1 = new JLabel();
            this.journalName = new JLabel();
            this.add(this.jLabel1);
            this.jLabel1.setName("jLabel1");
            this.jLabel2 = new JLabel();
            this.add(this.jLabel2);
            this.jLabel2.setName("jLabel2");
            this.filterView = new JTextField(30);
            this.add(this.filterView);
            this.filterView.setName("filterView");
            this.filterView.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    JournalView.this.newFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    JournalView.this.newFilter();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    JournalView.this.newFilter();
                }
            });
            FormLayout formLayout = new FormLayout("4dlu, pref, 4dlu, 50dlu:grow(0.9),8dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref:grow(0.9), 2dlu");
            this.setLayout((LayoutManager)formLayout);
            this.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)this.jLabel1, cellConstraints.xy(2, 2, CellConstraints.RIGHT, CellConstraints.CENTER));
            this.add((Component)this.journalName, new CellConstraints(4, 2, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER));
            this.add((Component)this.jLabel2, cellConstraints.xy(2, 4, CellConstraints.RIGHT, CellConstraints.CENTER));
            this.add((Component)this.filterView, new CellConstraints(4, 4, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER));
            this.journalName.setName("journalName");
            this.jScrollPane1 = new JScrollPane();
            this.add((Component)this.jScrollPane1, new CellConstraints(4, 6, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
            this.Journal_Table = new JTable();
            this.jScrollPane1.setViewportView(this.Journal_Table);
            this.Journal_Table.setFillsViewportHeight(true);
            this.Journal_Table.setBackground(Color.WHITE);
            this.Journal_Table.doLayout();
            EntryDataModel entryDataModel = new EntryDataModel();
            this.Journal_Table.setModel(entryDataModel);
            this.Journal_Table.setColumnModel(new EntryColumnModel());
            this.Journal_Table.addMouseListener(new ClickListener());
            this.Journal_Table.setAutoCreateRowSorter(true);
            this.rowSorter = new EntryViewSorter();
            this.rowSorter.setModel(entryDataModel);
            this.Journal_Table.setRowSorter(this.rowSorter);
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Journal getCurrentJournal() {
        return this.currentJournal;
    }

    public void setCurrentJournal(Journal journal) {
        this.currentJournal = journal;
        if (this.currentJournal != null && journal.getTitle() != null) {
            this.journalName.setText(journal.getTitle());
        }
        EntryDataModel entryDataModel = (EntryDataModel)this.Journal_Table.getModel();
        entryDataModel.updateEntryData();
        entryDataModel.fireTableDataChanged();
    }

    private void newFilter() {
        RowFilter<EntryDataModel, Object> rowFilter = null;
        try {
            rowFilter = this.getEntryRowFilter();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.debug((Object)"Sentax error in expression");
            return;
        }
        try {
            this.rowSorter.setRowFilter(rowFilter);
        }
        catch (Exception exception) {
            logger.debug((Object)("bad regex" + exception));
        }
    }

    private RowFilter<EntryDataModel, Object> getEntryRowFilter() {
        RowFilter<EntryDataModel, Object> rowFilter = new RowFilter<EntryDataModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends EntryDataModel, ? extends Object> entry) {
                EntryDataModel entryDataModel = entry.getModel();
                Entry entry2 = entryDataModel.getEntry((Integer)entry.getIdentifier());
                Pattern pattern = Pattern.compile(JournalView.this.filterView.getText());
                Matcher matcher = pattern.matcher("");
                logger.debug((Object)("getting value at 4 = " + entry.getStringValue(4)));
                matcher.reset(TagService.tagSetToString(entry2.getTags()));
                if (matcher.find()) {
                    return true;
                }
                matcher.reset(entry2.getDescription());
                return matcher.find();
            }
        };
        return rowFilter;
    }

    static {
        URL uRL = ClassLoader.getSystemResource(LOCK_ICON);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        lock = toolkit.getImage(uRL);
    }

    class EntryViewSorter
    extends TableRowSorter<EntryDataModel> {
        EntryViewSorter() {
        }
    }

    class ClickListener
    extends MouseAdapter {
        ClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getClickCount() >= 2) {
                logger.debug((Object)("table.isEditing = " + jTable.isEditing()));
                int n = jTable.rowAtPoint(point);
                logger.debug((Object)("ID=" + jTable.getValueAt(n, 0)));
                try {
                    int n2 = new Integer(jTable.getValueAt(n, 0) + "");
                    Entry entry = JournalService.getEntry(JournalView.this.currentJournal, n2);
                    ((DragonflyJournal)Application.getInstance()).getEntryPanel().setCurrentEntry(entry);
                    ((DragonflyJournal)Application.getInstance()).showEntryView();
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    class EntryDataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 9237L;
        private ArrayList<Entry> entriesList = new ArrayList(0);

        public EntryDataModel() {
            this.updateEntryData();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void updateEntryData() {
            logger.debug((Object)"updating Data");
            if (JournalView.this.getCurrentJournal() != null && JournalView.this.getCurrentJournal().getEntries() != null) {
                this.entriesList = new ArrayList();
                Entry[] entryArray = JournalView.this.getCurrentJournal().getEntries().toArray(new Entry[0]);
                Arrays.sort(entryArray, new EntryDateComparator(true));
                for (Entry entry : entryArray) {
                    this.entriesList.add(entry);
                }
                logger.debug((Object)("adding entries ct=" + this.entriesList.size()));
            } else {
                this.entriesList = new ArrayList();
            }
        }

        @Override
        public int getColumnCount() {
            return columnNames.values().length;
        }

        @Override
        public int getRowCount() {
            return this.entriesList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n >= this.entriesList.size() | n2 > columnNames.values().length) {
                object = "";
            } else if (n2 == columnNames.Id.ordinal()) {
                object = this.entriesList.get(n).getId();
            } else if (n2 == columnNames.Date.ordinal()) {
                object = EntryForm.formatter.format(this.entriesList.get(n).getCreateDate());
            } else if (n2 == columnNames.Private.ordinal()) {
                object = this.entriesList.get(n).getPrivateEntry().booleanValue() ? new ImageIcon(lock) : new ImageIcon();
            } else if (n2 == columnNames.Tags.ordinal()) {
                object = TagService.tagSetToString(this.entriesList.get(n).getTags());
            } else if (n2 == columnNames.Description.ordinal()) {
                object = this.entriesList.get(n).getDescription();
            }
            return object;
        }

        public Entry getEntry(int n) {
            if (n < this.entriesList.size()) {
                return this.entriesList.get(n);
            }
            return null;
        }
    }

    class EntryColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 919L;

        public EntryColumnModel() {
            TableColumn tableColumn = new TableColumn(columnNames.Id.ordinal());
            tableColumn.setHeaderValue(columnNames.Id.name());
            tableColumn.setPreferredWidth(30);
            tableColumn.setMaxWidth(30);
            tableColumn.setResizable(true);
            tableColumn.setIdentifier("ID");
            tableColumn.setResizable(false);
            this.addColumn(tableColumn);
            TableColumn tableColumn2 = new TableColumn(columnNames.Date.ordinal());
            tableColumn2.setHeaderValue(columnNames.Date.name());
            tableColumn2.setPreferredWidth(140);
            tableColumn2.setMaxWidth(140);
            tableColumn2.setResizable(false);
            this.addColumn(tableColumn2);
            TableColumn tableColumn3 = new TableColumn(columnNames.Private.ordinal());
            tableColumn3.setPreferredWidth(20);
            tableColumn3.setMaxWidth(20);
            tableColumn3.setResizable(false);
            this.addColumn(tableColumn3);
            TableColumn tableColumn4 = new TableColumn(columnNames.Tags.ordinal());
            tableColumn4.setHeaderValue(columnNames.Tags.name());
            tableColumn4.setPreferredWidth(200);
            tableColumn4.setMaxWidth(300);
            this.addColumn(tableColumn4);
            TableColumn tableColumn5 = new TableColumn(columnNames.Description.ordinal());
            tableColumn5.setHeaderValue(columnNames.Description.name());
            this.addColumn(tableColumn5);
        }
    }

    public static enum columnNames {
        Id,
        Date,
        Private,
        Description,
        Tags;

    }
}

