/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.mydragonfly.pj.ui.TagGroup;

public class TagSelector
extends JPanel {
    private static final Logger logger = Logger.getLogger(TagSelector.class);
    private static final long serialVersionUID = -8968260004619115508L;
    private TreeSet<String> unselectedTags = new TreeSet();
    private TreeSet<String> selectedTags = new TreeSet();
    private TreeSet<String> baseTagSet = new TreeSet();
    JLabel tag_lbl;
    JLabel tagSearch_lbl;
    JLabel tagClick_lbl;
    JPanel selectTagDisplay;
    JTextField searchField;
    JPanel selectableTags;
    JButton add_btn;
    private int unselectedTagDisplayCount = 5;
    private int selectedTagDisplayCount = 8;
    private Color TagBackground = Color.LIGHT_GRAY;
    private TagGroup tagOptions;
    private TagGroup tagsSelected;
    public boolean filteredOn = false;

    public TagSelector(Set<String> set) {
        this(set, null);
    }

    public TagSelector(Set<String> set, Set<String> set2) {
        this.unselectedTags = set != null ? new TreeSet<String>(set) : new TreeSet();
        this.selectedTags = set2 != null ? new TreeSet<String>(set2) : new TreeSet();
        this.selectedTags.removeAll(this.unselectedTags);
        this.baseTagSet = (TreeSet)this.unselectedTags.clone();
        this.init();
    }

    private void init() {
        FormLayout formLayout = new FormLayout("4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu");
        this.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.tag_lbl = new JLabel();
        this.tag_lbl.setName("tag_lbl");
        this.tagSearch_lbl = new JLabel();
        this.tagSearch_lbl.setName("tagSearch_lbl");
        this.tagClick_lbl = new JLabel();
        this.tagClick_lbl.setName("tagClick_lbl");
        this.searchField = new JTextField(15);
        this.searchField.addKeyListener(new SearchKeyListener());
        this.tagOptions = new TagGroup(this.unselectedTags);
        this.tagOptions.addPropertyChangeListener("tags", new TagPropertyChangeListener(1));
        this.tagOptions.setTagBackground(this.TagBackground);
        this.tagsSelected = new TagGroup(this.selectedTags);
        this.tagsSelected.addPropertyChangeListener("tags", new TagPropertyChangeListener(-1));
        this.tagsSelected.setTagBackground(this.TagBackground);
        this.add_btn = new JButton();
        this.add_btn.setName("add_btn");
        this.add_btn.setAction(Application.getInstance().getContext().getActionMap(this).get("addNewTag"));
        this.add((Component)this.tag_lbl, cellConstraints.rc(2, 2, CellConstraints.CENTER, CellConstraints.RIGHT));
        this.add((Component)this.tagsSelected, cellConstraints.rcw(2, 4, 5, CellConstraints.CENTER, CellConstraints.LEFT));
        this.add((Component)this.tagSearch_lbl, cellConstraints.rc(4, 2, CellConstraints.CENTER, CellConstraints.RIGHT));
        this.add((Component)this.tagClick_lbl, cellConstraints.rc(6, 2, CellConstraints.CENTER, CellConstraints.RIGHT));
        this.add((Component)this.searchField, cellConstraints.rc(4, 4, CellConstraints.CENTER, CellConstraints.LEFT));
        this.add((Component)this.add_btn, cellConstraints.rc(4, 6, CellConstraints.CENTER, CellConstraints.LEFT));
        this.add((Component)this.tagOptions, cellConstraints.rcw(6, 4, 5, CellConstraints.CENTER, CellConstraints.LEFT));
        Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents(this);
    }

    public void resetAllTags(Set<String> set, Set<String> set2) {
        this.selectedTags = set2 != null ? new TreeSet<String>(set2) : new TreeSet();
        this.unselectedTags = set != null ? new TreeSet<String>(set) : new TreeSet();
        this.unselectedTags.removeAll(this.selectedTags);
        this.baseTagSet = (TreeSet)this.unselectedTags.clone();
        this.tagsSelected.replaceTags(this.selectedTags, true);
        this.tagOptions.replaceTags(this.unselectedTags, true);
        this.searchField.setText("");
    }

    public int getUnselectedTagDisplayCount() {
        return this.unselectedTagDisplayCount;
    }

    public void setUnselectedTagDisplayCount(int n) {
        this.unselectedTagDisplayCount = n;
        this.tagOptions.setTagDisplayCount(n);
    }

    protected TreeSet<String> getSelectedTags() {
        return this.selectedTags;
    }

    public Color getTagBackground() {
        return this.TagBackground;
    }

    public void setTagBackground(Color color) {
        this.TagBackground = color;
    }

    public int getSelectedTagDisplayCount() {
        return this.selectedTagDisplayCount;
    }

    public void setSelectedTagDisplayCount(int n) {
        this.selectedTagDisplayCount = n;
    }

    @Action
    public void addNewTag() {
        String string = this.searchField.getText().trim();
        if (string.length() > 0) {
            if (this.unselectedTags.contains(string)) {
                this.tagOptions.removeTag(string);
            } else {
                this.tagsSelected.addTag(string);
                this.selectedTags.add(string);
            }
            this.searchField.setText("");
        }
    }

    public static void main(String[] stringArray) {
        Logger logger = Logger.getLogger((String)"org.mydragonfly.pj");
        logger.setLevel(Level.DEBUG);
        logger.debug((Object)"Starting Test TegGroup...");
        JFrame jFrame = new JFrame("RoundedLabel Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setBackground(Color.GRAY);
        FormLayout formLayout = new FormLayout("4dlu, pref, 4dlu, pref,8dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref:grow(0.9), 2dlu");
        jFrame.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        final HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("ATag1");
        hashSet.add("Tag2");
        hashSet.add("Tag3");
        hashSet.add("bTag4");
        hashSet.add("Tag5");
        hashSet.add("Tag6");
        hashSet.add("Tag7");
        hashSet.add("Tag88");
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("Tag88");
        hashSet2.add("Tag9");
        final TagSelector tagSelector = new TagSelector(hashSet, hashSet2);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet2.add("ATag1");
                hashSet2.add("Tag3");
                tagSelector.resetAllTags(hashSet, hashSet2);
            }
        };
        JButton jButton = new JButton(abstractAction);
        jButton.setText("New Set");
        jFrame.getContentPane().add((Component)tagSelector, cellConstraints.rc(2, 2, CellConstraints.CENTER, CellConstraints.LEFT));
        jFrame.getContentPane().add((Component)tagSelector, cellConstraints.rc(4, 2, CellConstraints.CENTER, CellConstraints.LEFT));
        jFrame.getContentPane().add((Component)jButton, cellConstraints.rc(6, 2, CellConstraints.CENTER, CellConstraints.LEFT));
        jFrame.setSize(800, 200);
        jFrame.setVisible(true);
    }

    class TagPropertyChangeListener
    implements PropertyChangeListener {
        public static final int ADD_SELECTED_TAG = 1;
        public static final int REMOVE_SELECTED_TAG = -1;
        int selectType = -1;

        public TagPropertyChangeListener(int n) {
            this.selectType = n;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (TagSelector.this.filteredOn) {
                TagSelector.this.filteredOn = false;
                return;
            }
            String string = this.getTagChange(propertyChangeEvent);
            if (string == null) {
                return;
            }
            logger.debug((Object)("tagChanged=" + string));
            switch (this.selectType) {
                case 1: {
                    TagSelector.this.selectedTags.add(string);
                    TagSelector.this.tagsSelected.addTag(string);
                    TagSelector.this.baseTagSet.remove(string);
                    logger.debug((Object)("BaseTagSet(unselected) " + TagSelector.this.baseTagSet));
                    break;
                }
                case -1: {
                    TagSelector.this.unselectedTags.add(string);
                    TagSelector.this.baseTagSet.add(string);
                    TagSelector.this.tagOptions.addTag(string);
                    logger.debug((Object)("BaseTagSet(unselected) " + TagSelector.this.baseTagSet));
                    break;
                }
            }
        }

        private String getTagChange(PropertyChangeEvent propertyChangeEvent) {
            TreeSet treeSet = (TreeSet)propertyChangeEvent.getNewValue();
            TreeSet treeSet2 = (TreeSet)((TreeSet)propertyChangeEvent.getOldValue()).clone();
            treeSet2.removeAll(treeSet);
            String string = null;
            if (!treeSet2.isEmpty()) {
                string = (String)treeSet2.iterator().next();
            }
            return string;
        }
    }

    class SearchKeyListener
    extends KeyAdapter {
        SearchKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            String string;
            TagSelector.this.unselectedTags = (TreeSet)TagSelector.this.baseTagSet.clone();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UNfiltered tags=" + TagSelector.this.unselectedTags));
                logger.debug((Object)("char types=" + keyEvent.getKeyChar()));
            }
            if ((string = TagSelector.this.searchField.getText()).length() > 0) {
                TagSelector.this.filteredOn = true;
                Set<String> set = Collections.synchronizedSet((TreeSet)TagSelector.this.baseTagSet.clone());
                for (String string2 : set) {
                    if (string2.matches("(?i)" + string + ".*")) continue;
                    logger.debug((Object)"No match");
                    TagSelector.this.unselectedTags.remove(string2);
                }
            } else {
                TagSelector.this.filteredOn = false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Filtered tags=" + TagSelector.this.unselectedTags));
            }
            TagSelector.this.tagOptions.replaceTags(TagSelector.this.unselectedTags);
        }
    }
}

