/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mydragonfly.pj.ui.RoundedLabel;

public class TagGroup
extends JPanel {
    public static final String TAGS_BOUND_PROPERTY = "tags";
    private static final Logger logger = Logger.getLogger(TagGroup.class);
    private static final long serialVersionUID = 408830753168570559L;
    private Color TagBackground = Color.LIGHT_GRAY;
    private TreeSet<String> oldTags;
    private TreeSet<String> tags;
    private int tagDisplayCount = 5;
    private FlowLayout flow = new FlowLayout(0);
    private PropertyChangeSupport tagChangeSupport;

    public TagGroup(TreeSet<String> treeSet) {
        logger.debug((Object)"Creating TagGroup");
        this.tags = treeSet != null ? new TreeSet<String>((SortedSet<String>)treeSet) : new TreeSet();
        this.oldTags = this.tags;
        logger.debug((Object)("New Tag Set:" + this.tags));
        this.setLayout(this.flow);
        this.tagChangeSupport = new PropertyChangeSupport(treeSet);
        this.resetTags();
    }

    public void resetTags() {
        logger.debug((Object)"Reseting tags");
        logger.debug((Object)("comp ct=" + this.getComponentCount()));
        this.removeAll();
        this.addTagsToUI();
        this.revalidate();
    }

    private void addTagsToUI() {
        logger.debug((Object)("Adding Tags:" + this.tags));
        int n = 0;
        for (String string : this.tags) {
            if (n >= this.tagDisplayCount) {
                return;
            }
            RoundedLabel roundedLabel = new RoundedLabel(string);
            roundedLabel.setBackground(this.TagBackground);
            roundedLabel.addMouseListener(new TagListener());
            this.add(roundedLabel);
            ++n;
        }
    }

    public void replaceTags(Set<String> set) {
        this.replaceTags(set, false);
    }

    public void replaceTags(Set<String> set, boolean bl) {
        logger.debug((Object)("ressetting to new tag set" + set));
        this.oldTags = (TreeSet)this.tags.clone();
        this.tags = new TreeSet<String>(set);
        this.resetTags();
        if (!bl) {
            this.tagChangeSupport.firePropertyChange(TAGS_BOUND_PROPERTY, this.oldTags, this.tags);
        }
    }

    public void removeTag(String string) {
        this.oldTags = (TreeSet)this.tags.clone();
        this.tags.remove(string);
        this.resetTags();
        this.tagChangeSupport.firePropertyChange(TAGS_BOUND_PROPERTY, this.oldTags, this.tags);
    }

    public void addTag(String string) {
        this.oldTags = (TreeSet)this.tags.clone();
        this.tags.add(string);
        this.resetTags();
        this.tagChangeSupport.firePropertyChange(TAGS_BOUND_PROPERTY, this.oldTags, this.tags);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.tagChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.tagChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Color getTagBackground() {
        return this.TagBackground;
    }

    public void setTagBackground(Color color) {
        this.TagBackground = color;
    }

    public int getTagDisplayCount() {
        return this.tagDisplayCount;
    }

    public void setTagDisplayCount(int n) {
        this.tagDisplayCount = n;
    }

    public static void main(String[] stringArray) {
        Logger logger = Logger.getLogger((String)"org.mydragonfly.pj");
        logger.setLevel(Level.DEBUG);
        logger.debug((Object)"Starting Test TegGroup...");
        JFrame jFrame = new JFrame("TagGropup Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setBackground(Color.GRAY);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("ATagA");
        hashSet.add("TagC");
        hashSet.add("TagD");
        hashSet.add("TagB");
        System.out.println("Original Set=" + hashSet);
        System.out.println("Sorted? Set=" + new TreeSet(hashSet));
        final TagGroup tagGroup = new TagGroup(new TreeSet<String>(hashSet));
        tagGroup.addPropertyChangeListener(TAGS_BOUND_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.out.println("*** Property change event fired.");
                System.out.println("New:" + propertyChangeEvent.getNewValue() + "\nOld" + propertyChangeEvent.getOldValue());
                TreeSet treeSet = (TreeSet)propertyChangeEvent.getNewValue();
                TreeSet treeSet2 = (TreeSet)((TreeSet)propertyChangeEvent.getOldValue()).clone();
                treeSet2.removeAll(treeSet);
                System.out.println("Removed object=" + treeSet2);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("TagD");
                hashSet.add("TagC");
                tagGroup.replaceTags(hashSet, true);
            }
        };
        JButton jButton = new JButton(abstractAction);
        jButton.setText("New Set");
        FormLayout formLayout = new FormLayout("4dlu, pref, 4dlu, 50dlu:grow(0.9),8dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref:grow(0.9), 2dlu");
        jFrame.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        jFrame.getContentPane().add((Component)new JLabel("Testing TagGroup:"), cellConstraints.rc(2, 2, CellConstraints.CENTER, CellConstraints.LEFT));
        jFrame.getContentPane().add((Component)tagGroup, cellConstraints.rc(4, 2, CellConstraints.CENTER, CellConstraints.LEFT));
        jFrame.getContentPane().add((Component)jButton, cellConstraints.rc(6, 2, CellConstraints.CENTER, CellConstraints.LEFT));
        jFrame.setSize(300, 200);
        jFrame.setVisible(true);
    }

    class TagListener
    extends MouseAdapter {
        TagListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            RoundedLabel roundedLabel = (RoundedLabel)mouseEvent.getSource();
            TagGroup.this.removeTag(roundedLabel.getText());
        }
    }
}

