/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

public class SpellDictionaryDichoDisk
extends SpellDictionaryASpell {
    private RandomAccessFile dictFile = null;
    private String encoding = null;

    public SpellDictionaryDichoDisk(File wordList) throws FileNotFoundException, IOException {
        super((File)null);
        this.dictFile = new RandomAccessFile(wordList, "r");
    }

    public SpellDictionaryDichoDisk(File wordList, String encoding) throws FileNotFoundException, IOException {
        super((File)null);
        this.encoding = encoding;
        this.dictFile = new RandomAccessFile(wordList, "r");
    }

    public SpellDictionaryDichoDisk(File wordList, File phonetic) throws FileNotFoundException, IOException {
        super(phonetic);
        this.dictFile = new RandomAccessFile(wordList, "r");
    }

    public SpellDictionaryDichoDisk(File wordList, File phonetic, String encoding) throws FileNotFoundException, IOException {
        super(phonetic, encoding);
        this.encoding = encoding;
        this.dictFile = new RandomAccessFile(wordList, "r");
    }

    @Override
    public void addWord(String word) {
        System.err.println("error: addWord is not implemented for SpellDictionaryDichoDisk");
    }

    private LinkedList dichoFind(String code, long p1, long p2) throws IOException {
        long pm = (p1 + p2) / 2L;
        this.dictFile.seek(pm);
        String l = this.encoding == null ? this.dictFile.readLine() : this.dictReadLine();
        pm = this.dictFile.getFilePointer();
        l = this.encoding == null ? this.dictFile.readLine() : this.dictReadLine();
        long pm2 = this.dictFile.getFilePointer();
        if (pm2 >= p2) {
            return this.seqFind(code, p1, p2);
        }
        int istar = l.indexOf(42);
        if (istar == -1) {
            throw new IOException("bad format: no * !");
        }
        String testcode = l.substring(0, istar);
        int comp = code.compareTo(testcode);
        if (comp < 0) {
            return this.dichoFind(code, p1, pm - 1L);
        }
        if (comp > 0) {
            return this.dichoFind(code, pm2, p2);
        }
        LinkedList l1 = this.dichoFind(code, p1, pm - 1L);
        LinkedList l2 = this.dichoFind(code, pm2, p2);
        String word = l.substring(istar + 1);
        l1.add(word);
        l1.addAll(l2);
        return l1;
    }

    private LinkedList seqFind(String code, long p1, long p2) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        this.dictFile.seek(p1);
        while (this.dictFile.getFilePointer() < p2) {
            String l = this.encoding == null ? this.dictFile.readLine() : this.dictReadLine();
            int istar = l.indexOf(42);
            if (istar == -1) {
                throw new IOException("bad format: no * !");
            }
            String testcode = l.substring(0, istar);
            if (!testcode.equals(code)) continue;
            String word = l.substring(istar + 1);
            list.add(word);
        }
        return list;
    }

    private String dictReadLine() throws IOException {
        int max = 255;
        int b = 0;
        byte[] buf = new byte[max];
        int i = 0;
        try {
            while (b != 10 && b != 13 && i < max - 1) {
                buf[i] = b = (int)this.dictFile.readByte();
                ++i;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (i == 0) {
            return "";
        }
        String s = new String(buf, 0, i - 1, this.encoding);
        return s;
    }

    @Override
    public List getWords(String code) {
        LinkedList list;
        try {
            list = this.dichoFind(code, 0L, this.dictFile.length() - 1L);
        }
        catch (IOException ex) {
            System.err.println("IOException: " + ex.getMessage());
            list = new LinkedList();
        }
        return list;
    }
}

