/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.WordTokenizer;
import java.util.List;

class BasicSpellCheckEvent
implements SpellCheckEvent {
    private List suggestions;
    private String invalidWord;
    private short action = (short)-1;
    private String replaceWord = null;
    private String context;
    private int startPosition;

    public BasicSpellCheckEvent(String invalidWord, List suggestions, WordTokenizer tokenizer) {
        this.invalidWord = invalidWord;
        this.suggestions = suggestions;
        this.context = tokenizer.getContext();
        this.startPosition = tokenizer.getCurrentWordPosition();
    }

    @Override
    public List getSuggestions() {
        return this.suggestions;
    }

    @Override
    public String getInvalidWord() {
        return this.invalidWord;
    }

    @Override
    public String getWordContext() {
        return null;
    }

    @Override
    public int getWordContextPosition() {
        return this.startPosition;
    }

    @Override
    public short getAction() {
        return this.action;
    }

    @Override
    public String getReplaceWord() {
        return this.replaceWord;
    }

    @Override
    public void replaceWord(String newWord, boolean replaceAll) {
        if (this.action != -1) {
            throw new IllegalStateException("The action can can only be set once");
        }
        this.action = replaceAll ? (short)3 : (short)2;
        this.replaceWord = newWord;
    }

    @Override
    public void ignoreWord(boolean ignoreAll) {
        if (this.action != -1) {
            throw new IllegalStateException("The action can can only be set once");
        }
        this.action = ignoreAll ? (short)1 : 0;
    }

    @Override
    public void addToDictionary(String newWord) {
        if (this.action != -1) {
            throw new IllegalStateException("The action can can only be set once");
        }
        this.action = (short)4;
        this.replaceWord = newWord;
    }

    @Override
    public void cancel() {
        if (this.action != -1) {
            throw new IllegalStateException("The action can can only be set once");
        }
        this.action = (short)5;
    }
}

