/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.examples;

import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

public class SpellCheckExample
implements SpellCheckListener {
    private static String dictFile = "dict/english.0";
    private static String phonetFile = "dict/phonet.en";
    private SpellChecker spellCheck = null;

    public SpellCheckExample() {
        try {
            SpellDictionaryHashMap dictionary = new SpellDictionaryHashMap(new File(dictFile), new File(phonetFile));
            this.spellCheck = new SpellChecker(dictionary);
            this.spellCheck.addSpellCheckListener(this);
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.print("Enter text to spell check: ");
                String line = in.readLine();
                if (line.length() > 0) {
                    this.spellCheck.checkSpelling(new StringWordTokenizer(line));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void spellingError(SpellCheckEvent event) {
        List suggestions = event.getSuggestions();
        if (suggestions.size() > 0) {
            System.out.println("MISSPELT WORD: " + event.getInvalidWord());
            Iterator suggestedWord = suggestions.iterator();
            while (suggestedWord.hasNext()) {
                System.out.println("\tSuggested Word: " + suggestedWord.next());
            }
        } else {
            System.out.println("MISSPELT WORD: " + event.getInvalidWord());
            System.out.println("\tNo suggestions");
        }
    }

    public static void main(String[] args) {
        new SpellCheckExample();
    }
}

