/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.WordTokenizer;
import java.text.BreakIterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;

public class DocumentWordTokenizer
implements WordTokenizer {
    private int currentWordPos = 0;
    private int currentWordEnd = 0;
    private int nextWordPos = -1;
    private Document document;
    private Segment text;
    private int wordCount = 0;
    private boolean moreTokens = true;
    private boolean first = true;
    private BreakIterator sentenceIterator;
    private boolean startsSentence = true;

    public DocumentWordTokenizer(Document document) {
        this.document = document;
        this.text = new Segment();
        this.sentenceIterator = BreakIterator.getSentenceInstance();
        try {
            document.getText(0, document.getLength(), this.text);
            this.sentenceIterator.setText(this.text);
            this.currentWordPos = DocumentWordTokenizer.getNextWordStart(this.text, 0);
            if (this.currentWordPos != -1) {
                this.currentWordEnd = DocumentWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
                this.nextWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordEnd);
            } else {
                this.moreTokens = false;
            }
        }
        catch (BadLocationException badLocationException) {
            this.moreTokens = false;
        }
    }

    private static int getNextWordStart(Segment segment, int n) {
        if (n <= segment.getEndIndex()) {
            char c = segment.setIndex(n);
            while (c != '\uffff') {
                if (Character.isLetterOrDigit(c)) {
                    return segment.getIndex();
                }
                c = segment.next();
            }
        }
        return -1;
    }

    private static int getNextWordEnd(Segment segment, int n) {
        char c = segment.setIndex(n);
        while (c != '\uffff') {
            block3: {
                block4: {
                    if (Character.isLetterOrDigit(c)) break block3;
                    if (c != '-' && c != '\'') break block4;
                    char c2 = segment.next();
                    segment.previous();
                    if (c2 != '\uffff' && Character.isLetterOrDigit(c2)) break block3;
                }
                return segment.getIndex();
            }
            c = segment.next();
        }
        return segment.getEndIndex();
    }

    public boolean hasMoreWords() {
        return this.moreTokens;
    }

    public void posStartFullWordFrom(int n) {
        this.currentWordPos = this.text.getBeginIndex();
        if (n > this.text.getEndIndex()) {
            n = this.text.getEndIndex();
        }
        char c = this.text.setIndex(n);
        while (c != '\uffff') {
            block6: {
                block7: {
                    if (Character.isLetterOrDigit(c)) break block6;
                    if (c != '-' && c != '\'') break block7;
                    char c2 = this.text.previous();
                    this.text.next();
                    if (c2 != '\uffff' && Character.isLetterOrDigit(c2)) break block6;
                }
                this.currentWordPos = this.text.getIndex() + 1;
                break;
            }
            c = this.text.previous();
        }
        if (this.currentWordPos == 0) {
            this.first = true;
        }
        this.moreTokens = true;
        this.currentWordEnd = DocumentWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
        this.nextWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordEnd + 1);
    }

    public int getCurrentWordPosition() {
        return this.currentWordPos;
    }

    public int getCurrentWordEnd() {
        return this.currentWordEnd;
    }

    public String nextWord() {
        int n;
        if (!this.first) {
            this.currentWordPos = this.nextWordPos;
            this.currentWordEnd = DocumentWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
            this.nextWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordEnd + 1);
        }
        if ((n = this.sentenceIterator.current()) == this.currentWordPos) {
            this.startsSentence = true;
        } else {
            this.startsSentence = false;
            if (this.currentWordEnd > n) {
                this.sentenceIterator.next();
            }
        }
        String string = null;
        try {
            string = this.document.getText(this.currentWordPos, this.currentWordEnd - this.currentWordPos);
        }
        catch (BadLocationException badLocationException) {
            this.moreTokens = false;
        }
        ++this.wordCount;
        this.first = false;
        if (this.nextWordPos == -1) {
            this.moreTokens = false;
        }
        return string;
    }

    public int getCurrentWordCount() {
        return this.wordCount;
    }

    public void replaceWord(String string) {
        AttributeSet attributeSet = null;
        if (this.currentWordPos != -1) {
            try {
                if (this.document instanceof StyledDocument) {
                    attributeSet = ((StyledDocument)this.document).getCharacterElement(this.currentWordPos).getAttributes();
                }
                this.document.remove(this.currentWordPos, this.currentWordEnd - this.currentWordPos);
                this.document.insertString(this.currentWordPos, string, null);
                this.document.getText(0, this.document.getLength(), this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException.getMessage());
            }
            this.first = true;
            this.currentWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordPos + string.length());
            if (this.currentWordPos != -1) {
                this.currentWordEnd = DocumentWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
                this.nextWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordEnd);
                this.sentenceIterator.setText(this.text);
                this.sentenceIterator.following(this.currentWordPos);
            } else {
                this.moreTokens = false;
            }
        }
    }

    public String getContext() {
        return this.text.toString();
    }

    public boolean isNewSentence() {
        if (this.startsSentence || this.currentWordPos < 2) {
            return true;
        }
        String string = null;
        try {
            string = this.document.getText(this.currentWordPos - 2, 2);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return string != null && ".".equals(string.trim());
    }
}

