/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

public class FontSupport {
    public static final String[] stdNames = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    static final String[] stdValues = new String[]{"", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "\u00a1", "\u00a2", "\u00a3", "/fraction", "\u00a5", "Fflorin", "\u00a7", "\u00a4", "\u00b4quotesingle", "\u201c", "?guillemotleft", "\u2039", "\u203a", "fi", "fl", "--", "\u2020", "\u2021", "\u00b7", "\u00b6", "\u2022", "'quotesinglbase", "\"quotedblbase", "\"quotedblright", "?guillemotright", "...ellipsis", "%perthousand", "?questiondown", "`grave", "'acute", "^circumflex", "~tilde", "-macron", "?breve", "?dotaccent", "?dieresis", "oring", "ccedilla", ":hungarumlaut", "?ogonek", ",caron", "---emdash", "AE", "aordfeminine", "LLslash", "OOslash", "OE", "oordmasculine", "ae", "idotlessi", "llslash", "ooslash", "oe", "Bgermandbls", "1onesuperior", "~logicalnot", "?mu", "(TM)trademark", "?Eth", "1/2", "+/-", "?Thorn", "1/4", "/divide", "|brokenbar", "*degree", "?thorn", "3/4", "2twosuperior", "(R)", "-minus", "?eth", "*multiply", "3threesuperior", "(C)", "AAacute", "AAcircumflex", "AAdieresis", "AAgrave", "AAring", "AAtilde", "CCcedilla", "EEacute", "EEcircumflex", "EEdieresis", "EEgrave", "IIacute", "IIcircumflex", "IIdieresis", "IIgrave", "NNtilde", "OOacute", "OOcircumflex", "OOdieresis", "OOgrave", "OOtilde", "SScaron", "UUacute", "UUcircumflex", "UUdieresis", "UUgrave", "YYacute", "YYdieresis", "ZZcaron", "aaacute", "aacircumflex", "aadieresis", "aagrave", "aaring", "aatilde", "cccedilla", "eeacute", "eecircumflex", "eedieresis", "eegrave", "iiacute", "iicircumflex", "iidieresis", "iigrave", "nntilde", "ooacute", "oocircumflex", "oodieresis", "oograve", "ootilde", "sscaron", "uuacute", "uucircumflex", "uudieresis", "uugrave", "yyacute", "yydieresis", "zzcaron", "!exclamsmall", "?Hungarumlautsmall", "$dollaroldstyle", "$dollarsuperior", "&ampersandsmall", "'Acutesmall", "/parenleftsuperior", "\\parenrightsuperior", "?twodotenleader", "?onedotenleader", "0zerooldstyle", "1oneoldstyle", "2twooldstyle", "3threeoldstyle", "4fouroldstyle", "5fiveoldstyle", "6sixoldstyle", "7sevenoldstyle", "8eightoldstyle", "9nineoldstyle", "'commasuperior", "--threequartersemdash", ".periodsuperior", "?questionsmall", "aasuperior", "bbsuperior", "ccentsuperior", "ddsuperior", "eesuperior", "iisuperior", "llsuperior", "mmsuperior", "nnsuperior", "oosuperior", "rrsuperior", "sssuperior", "ttsuperior", "ff", "ffi", "ffl", "\\parenleftinferior", "/parenrightinferior", "^Circumflexsmall", "-hyphensuperior", "`Gravesmall", "AAsmall", "BBsmall", "CCsmall", "DDsmall", "EEsmall", "FFsmall", "GGsmall", "HHsmall", "IIsmall", "JJsmall", "KKsmall", "LLsmall", "MMsmall", "NNsmall", "OOsmall", "PPsmall", "QQsmall", "RRsmall", "SSsmall", "TTsmall", "UUsmall", "VVsmall", "WWsmall", "XXsmall", "YYsmall", "ZZsmall", ":colonmonetary", "1onefitted", "?rupiah", "~Tildesmall", "!exclamdownsmall", "ccentoldstyle", "LLslashsmall", "SScaronsmall", "ZZcaronsmall", "?Dieresissmall", "?Brevesmall", "^Caronsmall", "?Dotaccentsmall", "?Macronsmall", "--figuredash", "-hypheninferior", "?Ogoneksmall", "oRingsmall", ",Cedillasmall", "?questiondownsmall", "1/8oneeighth", "3/8threeeighths", "5/8fiveeighths", "7/8seveneighths", "1/3onethird", "2/3twothirds", "0zerosuperior", "4foursuperior", "5fivesuperior", "6sixsuperior", "7sevensuperior", "8eightsuperior", "9ninesuperior", "0zeroinferior", "1oneinferior", "2twoinferior", "3threeinferior", "4fourinferior", "5fiveinferior", "6sixinferior", "7seveninferior", "8eightinferior", "9nineinferior", "ccentinferior", "$dollarinferior", ".periodinferior", ",commainferior", "AAgravesmall", "AAacutesmall", "AAcircumflexsmall", "AAtildesmall", "AAdieresissmall", "AAringsmall", "AEAEsmall", "CCcedillasmall", "EEgravesmall", "EEacutesmall", "EEcircumflexsmall", "EEdieresissmall", "IIgravesmall", "IIacutesmall", "IIcircumflexsmall", "IIdieresissmall", "EthEthsmall", "NNtildesmall", "OOgravesmall", "OOacutesmall", "OOcircumflexsmall", "OOtildesmall", "OOdieresissmall", "OEOEsmall", "OOslashsmall", "UUgravesmall", "UUacutesmall", "UUcircumflexsmall", "UUdieresissmall", "YYacutesmall", "?Thornsmall", "YYdieresissmall", "?001.000", "?001.001", "?001.002", "?001.003", " Black", " Bold", " Book", " Light", " Medium", " Regular", " Roman", " Semibold", "?NUL", "?HT", " LF", " CR", "?DLE", "?DC1", "?DC2", "?DC3", "?DC4", "?RS", "?US", "!=", "?DEL", "?infinity", "<=", ">=", "?partialdiff", "?summation", "xproduct", "?pi", "?integral", "?Omega", "?radical", "~=", "?Delta", " nbspace", "?lozenge", "?apple"};
    public static final int[] type1CExpertCharset = new int[]{1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    public static final int[] type1CExpertSubCharset = new int[]{1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    public static final String[] macExtras = new String[]{"NUL", "HT", "LF", "CR", "DLE", "DC1", "DC2", "DC3", "DC4", "RS", "US", "notequal", "DEL", "infinity", "lessequal", "greaterequal", "partialdiff", "summation", "product", "pi", "integral", "Omega", "radical", "approxequal", "Delta", "nbspace", "lozenge", "apple"};
    public static final int[] macRomanEncoding = new int[]{391, 154, 167, 140, 146, 192, 221, 197, 226, 392, 393, 157, 162, 394, 199, 228, 395, 396, 397, 398, 399, 155, 158, 150, 163, 169, 164, 160, 166, 168, 400, 401, 1, 2, 3, 4, 5, 6, 7, 104, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 124, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 403, 173, 175, 177, 178, 186, 189, 195, 200, 203, 201, 202, 205, 204, 206, 207, 210, 208, 209, 211, 214, 212, 213, 215, 216, 219, 217, 218, 220, 222, 225, 223, 224, 112, 161, 97, 98, 102, 116, 115, 149, 165, 170, 153, 125, 131, 402, 138, 141, 404, 156, 405, 406, 100, 152, 407, 408, 409, 410, 411, 139, 143, 412, 144, 147, 123, 96, 151, 413, 101, 414, 415, 106, 120, 121, 416, 174, 176, 191, 142, 148, 111, 137, 105, 119, 65, 8, 159, 417, 227, 198, 99, 103, 107, 108, 109, 110, 113, 114, 117, 118, 122, 172, 179, 171, 180, 181, 182, 183, 184, 185, 187, 188, 418, 190, 193, 194, 196, 145, 126, 127, 128, 129, 130, 132, 133, 134, 135, 136};
    public static final int[] isoLatin1Encoding;
    public static final int[] winAnsiEncoding;
    public static final int[] standardEncoding;

    static {
        int[] nArray = new int[256];
        nArray[32] = 1;
        nArray[33] = 2;
        nArray[34] = 3;
        nArray[35] = 4;
        nArray[36] = 5;
        nArray[37] = 6;
        nArray[38] = 7;
        nArray[39] = 8;
        nArray[40] = 9;
        nArray[41] = 10;
        nArray[42] = 11;
        nArray[43] = 12;
        nArray[44] = 13;
        nArray[45] = 166;
        nArray[46] = 15;
        nArray[47] = 16;
        nArray[48] = 17;
        nArray[49] = 18;
        nArray[50] = 19;
        nArray[51] = 20;
        nArray[52] = 21;
        nArray[53] = 22;
        nArray[54] = 23;
        nArray[55] = 24;
        nArray[56] = 25;
        nArray[57] = 26;
        nArray[58] = 27;
        nArray[59] = 28;
        nArray[60] = 29;
        nArray[61] = 30;
        nArray[62] = 31;
        nArray[63] = 32;
        nArray[64] = 33;
        nArray[65] = 34;
        nArray[66] = 35;
        nArray[67] = 36;
        nArray[68] = 37;
        nArray[69] = 38;
        nArray[70] = 39;
        nArray[71] = 40;
        nArray[72] = 41;
        nArray[73] = 42;
        nArray[74] = 43;
        nArray[75] = 44;
        nArray[76] = 45;
        nArray[77] = 46;
        nArray[78] = 47;
        nArray[79] = 48;
        nArray[80] = 49;
        nArray[81] = 50;
        nArray[82] = 51;
        nArray[83] = 52;
        nArray[84] = 53;
        nArray[85] = 54;
        nArray[86] = 55;
        nArray[87] = 56;
        nArray[88] = 57;
        nArray[89] = 58;
        nArray[90] = 59;
        nArray[91] = 60;
        nArray[92] = 61;
        nArray[93] = 62;
        nArray[94] = 63;
        nArray[95] = 64;
        nArray[96] = 65;
        nArray[97] = 66;
        nArray[98] = 67;
        nArray[99] = 68;
        nArray[100] = 69;
        nArray[101] = 70;
        nArray[102] = 71;
        nArray[103] = 72;
        nArray[104] = 73;
        nArray[105] = 74;
        nArray[106] = 75;
        nArray[107] = 76;
        nArray[108] = 77;
        nArray[109] = 78;
        nArray[110] = 79;
        nArray[111] = 80;
        nArray[112] = 81;
        nArray[113] = 82;
        nArray[114] = 83;
        nArray[115] = 84;
        nArray[116] = 85;
        nArray[117] = 86;
        nArray[118] = 87;
        nArray[119] = 88;
        nArray[120] = 89;
        nArray[121] = 90;
        nArray[122] = 91;
        nArray[123] = 92;
        nArray[124] = 93;
        nArray[125] = 94;
        nArray[126] = 95;
        nArray[144] = 145;
        nArray[145] = 124;
        nArray[146] = 125;
        nArray[147] = 126;
        nArray[148] = 127;
        nArray[149] = 128;
        nArray[150] = 129;
        nArray[151] = 130;
        nArray[152] = 131;
        nArray[154] = 132;
        nArray[155] = 133;
        nArray[157] = 134;
        nArray[158] = 135;
        nArray[159] = 136;
        nArray[160] = 1;
        nArray[161] = 96;
        nArray[162] = 97;
        nArray[163] = 98;
        nArray[164] = 103;
        nArray[165] = 100;
        nArray[166] = 160;
        nArray[167] = 102;
        nArray[168] = 131;
        nArray[169] = 170;
        nArray[170] = 139;
        nArray[171] = 106;
        nArray[172] = 151;
        nArray[173] = 14;
        nArray[174] = 165;
        nArray[175] = 128;
        nArray[176] = 161;
        nArray[177] = 156;
        nArray[178] = 164;
        nArray[179] = 169;
        nArray[180] = 125;
        nArray[181] = 152;
        nArray[182] = 115;
        nArray[183] = 114;
        nArray[184] = 133;
        nArray[185] = 150;
        nArray[186] = 143;
        nArray[187] = 120;
        nArray[188] = 158;
        nArray[189] = 155;
        nArray[190] = 163;
        nArray[191] = 123;
        nArray[192] = 174;
        nArray[193] = 171;
        nArray[194] = 172;
        nArray[195] = 176;
        nArray[196] = 173;
        nArray[197] = 175;
        nArray[198] = 138;
        nArray[199] = 177;
        nArray[200] = 181;
        nArray[201] = 178;
        nArray[202] = 179;
        nArray[203] = 180;
        nArray[204] = 185;
        nArray[205] = 182;
        nArray[206] = 183;
        nArray[207] = 184;
        nArray[208] = 154;
        nArray[209] = 186;
        nArray[210] = 190;
        nArray[211] = 187;
        nArray[212] = 188;
        nArray[213] = 191;
        nArray[214] = 189;
        nArray[215] = 168;
        nArray[216] = 141;
        nArray[217] = 196;
        nArray[218] = 193;
        nArray[219] = 194;
        nArray[220] = 195;
        nArray[221] = 197;
        nArray[222] = 157;
        nArray[223] = 149;
        nArray[224] = 203;
        nArray[225] = 200;
        nArray[226] = 201;
        nArray[227] = 205;
        nArray[228] = 202;
        nArray[229] = 204;
        nArray[230] = 144;
        nArray[231] = 206;
        nArray[232] = 210;
        nArray[233] = 207;
        nArray[234] = 208;
        nArray[235] = 209;
        nArray[236] = 214;
        nArray[237] = 211;
        nArray[238] = 212;
        nArray[239] = 213;
        nArray[240] = 167;
        nArray[241] = 215;
        nArray[242] = 219;
        nArray[243] = 216;
        nArray[244] = 217;
        nArray[245] = 220;
        nArray[246] = 218;
        nArray[247] = 159;
        nArray[248] = 147;
        nArray[249] = 225;
        nArray[250] = 222;
        nArray[251] = 223;
        nArray[252] = 224;
        nArray[253] = 226;
        nArray[254] = 162;
        nArray[255] = 227;
        isoLatin1Encoding = nArray;
        int[] nArray2 = new int[256];
        nArray2[0] = 124;
        nArray2[1] = 125;
        nArray2[2] = 126;
        nArray2[3] = 127;
        nArray2[4] = 128;
        nArray2[5] = 129;
        nArray2[6] = 130;
        nArray2[7] = 131;
        nArray2[8] = 132;
        nArray2[9] = 133;
        nArray2[10] = 134;
        nArray2[11] = 135;
        nArray2[12] = 136;
        nArray2[13] = 145;
        nArray2[32] = 1;
        nArray2[33] = 2;
        nArray2[34] = 3;
        nArray2[35] = 4;
        nArray2[36] = 5;
        nArray2[37] = 6;
        nArray2[38] = 7;
        nArray2[39] = 8;
        nArray2[40] = 9;
        nArray2[41] = 10;
        nArray2[42] = 11;
        nArray2[43] = 12;
        nArray2[44] = 13;
        nArray2[45] = 14;
        nArray2[46] = 15;
        nArray2[47] = 16;
        nArray2[48] = 17;
        nArray2[49] = 18;
        nArray2[50] = 19;
        nArray2[51] = 20;
        nArray2[52] = 21;
        nArray2[53] = 22;
        nArray2[54] = 23;
        nArray2[55] = 24;
        nArray2[56] = 25;
        nArray2[57] = 26;
        nArray2[58] = 27;
        nArray2[59] = 28;
        nArray2[60] = 29;
        nArray2[61] = 30;
        nArray2[62] = 31;
        nArray2[63] = 32;
        nArray2[64] = 33;
        nArray2[65] = 34;
        nArray2[66] = 35;
        nArray2[67] = 36;
        nArray2[68] = 37;
        nArray2[69] = 38;
        nArray2[70] = 39;
        nArray2[71] = 40;
        nArray2[72] = 41;
        nArray2[73] = 42;
        nArray2[74] = 43;
        nArray2[75] = 44;
        nArray2[76] = 45;
        nArray2[77] = 46;
        nArray2[78] = 47;
        nArray2[79] = 48;
        nArray2[80] = 49;
        nArray2[81] = 50;
        nArray2[82] = 51;
        nArray2[83] = 52;
        nArray2[84] = 53;
        nArray2[85] = 54;
        nArray2[86] = 55;
        nArray2[87] = 56;
        nArray2[88] = 57;
        nArray2[89] = 58;
        nArray2[90] = 59;
        nArray2[91] = 60;
        nArray2[92] = 61;
        nArray2[93] = 62;
        nArray2[94] = 63;
        nArray2[95] = 64;
        nArray2[96] = 65;
        nArray2[97] = 66;
        nArray2[98] = 67;
        nArray2[99] = 68;
        nArray2[100] = 69;
        nArray2[101] = 70;
        nArray2[102] = 71;
        nArray2[103] = 72;
        nArray2[104] = 73;
        nArray2[105] = 74;
        nArray2[106] = 75;
        nArray2[107] = 76;
        nArray2[108] = 77;
        nArray2[109] = 78;
        nArray2[110] = 79;
        nArray2[111] = 80;
        nArray2[112] = 81;
        nArray2[113] = 82;
        nArray2[114] = 83;
        nArray2[115] = 84;
        nArray2[116] = 85;
        nArray2[117] = 86;
        nArray2[118] = 87;
        nArray2[119] = 88;
        nArray2[120] = 89;
        nArray2[121] = 90;
        nArray2[122] = 91;
        nArray2[123] = 92;
        nArray2[124] = 93;
        nArray2[125] = 94;
        nArray2[126] = 95;
        nArray2[130] = 117;
        nArray2[131] = 101;
        nArray2[132] = 118;
        nArray2[133] = 121;
        nArray2[134] = 112;
        nArray2[135] = 113;
        nArray2[137] = 122;
        nArray2[138] = 192;
        nArray2[139] = 107;
        nArray2[140] = 142;
        nArray2[145] = 65;
        nArray2[146] = 8;
        nArray2[147] = 105;
        nArray2[148] = 119;
        nArray2[149] = 116;
        nArray2[150] = 111;
        nArray2[151] = 137;
        nArray2[153] = 153;
        nArray2[154] = 221;
        nArray2[155] = 108;
        nArray2[156] = 148;
        nArray2[159] = 198;
        nArray2[160] = 1;
        nArray2[161] = 96;
        nArray2[162] = 97;
        nArray2[163] = 98;
        nArray2[164] = 103;
        nArray2[165] = 100;
        nArray2[166] = 160;
        nArray2[167] = 102;
        nArray2[168] = 131;
        nArray2[169] = 170;
        nArray2[170] = 139;
        nArray2[171] = 106;
        nArray2[172] = 151;
        nArray2[173] = 14;
        nArray2[174] = 165;
        nArray2[175] = 128;
        nArray2[176] = 161;
        nArray2[177] = 156;
        nArray2[178] = 164;
        nArray2[179] = 169;
        nArray2[180] = 125;
        nArray2[181] = 152;
        nArray2[182] = 115;
        nArray2[183] = 114;
        nArray2[184] = 133;
        nArray2[185] = 150;
        nArray2[186] = 143;
        nArray2[187] = 120;
        nArray2[188] = 158;
        nArray2[189] = 155;
        nArray2[190] = 163;
        nArray2[191] = 123;
        nArray2[192] = 174;
        nArray2[193] = 171;
        nArray2[194] = 172;
        nArray2[195] = 176;
        nArray2[196] = 173;
        nArray2[197] = 175;
        nArray2[198] = 138;
        nArray2[199] = 177;
        nArray2[200] = 181;
        nArray2[201] = 178;
        nArray2[202] = 179;
        nArray2[203] = 180;
        nArray2[204] = 185;
        nArray2[205] = 182;
        nArray2[206] = 183;
        nArray2[207] = 184;
        nArray2[208] = 154;
        nArray2[209] = 186;
        nArray2[210] = 190;
        nArray2[211] = 187;
        nArray2[212] = 188;
        nArray2[213] = 191;
        nArray2[214] = 189;
        nArray2[215] = 168;
        nArray2[216] = 141;
        nArray2[217] = 196;
        nArray2[218] = 193;
        nArray2[219] = 194;
        nArray2[220] = 195;
        nArray2[221] = 197;
        nArray2[222] = 157;
        nArray2[223] = 149;
        nArray2[224] = 203;
        nArray2[225] = 200;
        nArray2[226] = 201;
        nArray2[227] = 205;
        nArray2[228] = 202;
        nArray2[229] = 204;
        nArray2[230] = 144;
        nArray2[231] = 206;
        nArray2[232] = 210;
        nArray2[233] = 207;
        nArray2[234] = 208;
        nArray2[235] = 209;
        nArray2[236] = 214;
        nArray2[237] = 211;
        nArray2[238] = 212;
        nArray2[239] = 213;
        nArray2[240] = 167;
        nArray2[241] = 215;
        nArray2[242] = 219;
        nArray2[243] = 216;
        nArray2[244] = 217;
        nArray2[245] = 220;
        nArray2[246] = 218;
        nArray2[247] = 159;
        nArray2[248] = 147;
        nArray2[249] = 225;
        nArray2[250] = 222;
        nArray2[251] = 223;
        nArray2[252] = 224;
        nArray2[253] = 226;
        nArray2[254] = 162;
        nArray2[255] = 227;
        winAnsiEncoding = nArray2;
        int[] nArray3 = new int[256];
        nArray3[32] = 1;
        nArray3[33] = 2;
        nArray3[34] = 3;
        nArray3[35] = 4;
        nArray3[36] = 5;
        nArray3[37] = 6;
        nArray3[38] = 7;
        nArray3[39] = 8;
        nArray3[40] = 9;
        nArray3[41] = 10;
        nArray3[42] = 11;
        nArray3[43] = 12;
        nArray3[44] = 13;
        nArray3[45] = 14;
        nArray3[46] = 15;
        nArray3[47] = 16;
        nArray3[48] = 17;
        nArray3[49] = 18;
        nArray3[50] = 19;
        nArray3[51] = 20;
        nArray3[52] = 21;
        nArray3[53] = 22;
        nArray3[54] = 23;
        nArray3[55] = 24;
        nArray3[56] = 25;
        nArray3[57] = 26;
        nArray3[58] = 27;
        nArray3[59] = 28;
        nArray3[60] = 29;
        nArray3[61] = 30;
        nArray3[62] = 31;
        nArray3[63] = 32;
        nArray3[64] = 33;
        nArray3[65] = 34;
        nArray3[66] = 35;
        nArray3[67] = 36;
        nArray3[68] = 37;
        nArray3[69] = 38;
        nArray3[70] = 39;
        nArray3[71] = 40;
        nArray3[72] = 41;
        nArray3[73] = 42;
        nArray3[74] = 43;
        nArray3[75] = 44;
        nArray3[76] = 45;
        nArray3[77] = 46;
        nArray3[78] = 47;
        nArray3[79] = 48;
        nArray3[80] = 49;
        nArray3[81] = 50;
        nArray3[82] = 51;
        nArray3[83] = 52;
        nArray3[84] = 53;
        nArray3[85] = 54;
        nArray3[86] = 55;
        nArray3[87] = 56;
        nArray3[88] = 57;
        nArray3[89] = 58;
        nArray3[90] = 59;
        nArray3[91] = 60;
        nArray3[92] = 61;
        nArray3[93] = 62;
        nArray3[94] = 63;
        nArray3[95] = 64;
        nArray3[96] = 65;
        nArray3[97] = 66;
        nArray3[98] = 67;
        nArray3[99] = 68;
        nArray3[100] = 69;
        nArray3[101] = 70;
        nArray3[102] = 71;
        nArray3[103] = 72;
        nArray3[104] = 73;
        nArray3[105] = 74;
        nArray3[106] = 75;
        nArray3[107] = 76;
        nArray3[108] = 77;
        nArray3[109] = 78;
        nArray3[110] = 79;
        nArray3[111] = 80;
        nArray3[112] = 81;
        nArray3[113] = 82;
        nArray3[114] = 83;
        nArray3[115] = 84;
        nArray3[116] = 85;
        nArray3[117] = 86;
        nArray3[118] = 87;
        nArray3[119] = 88;
        nArray3[120] = 89;
        nArray3[121] = 90;
        nArray3[122] = 91;
        nArray3[123] = 92;
        nArray3[124] = 93;
        nArray3[125] = 94;
        nArray3[126] = 95;
        nArray3[161] = 96;
        nArray3[162] = 97;
        nArray3[163] = 98;
        nArray3[164] = 99;
        nArray3[165] = 100;
        nArray3[166] = 101;
        nArray3[167] = 102;
        nArray3[168] = 103;
        nArray3[169] = 104;
        nArray3[170] = 105;
        nArray3[171] = 106;
        nArray3[172] = 107;
        nArray3[173] = 108;
        nArray3[174] = 109;
        nArray3[175] = 110;
        nArray3[177] = 111;
        nArray3[178] = 112;
        nArray3[179] = 113;
        nArray3[180] = 114;
        nArray3[182] = 115;
        nArray3[183] = 116;
        nArray3[184] = 117;
        nArray3[185] = 118;
        nArray3[186] = 119;
        nArray3[187] = 120;
        nArray3[188] = 121;
        nArray3[189] = 122;
        nArray3[191] = 123;
        nArray3[193] = 124;
        nArray3[194] = 125;
        nArray3[195] = 126;
        nArray3[196] = 127;
        nArray3[197] = 128;
        nArray3[198] = 129;
        nArray3[199] = 130;
        nArray3[200] = 131;
        nArray3[202] = 132;
        nArray3[203] = 133;
        nArray3[205] = 134;
        nArray3[206] = 135;
        nArray3[207] = 136;
        nArray3[208] = 137;
        nArray3[225] = 138;
        nArray3[227] = 139;
        nArray3[232] = 140;
        nArray3[233] = 141;
        nArray3[234] = 142;
        nArray3[235] = 143;
        nArray3[241] = 144;
        nArray3[245] = 145;
        nArray3[248] = 146;
        nArray3[249] = 147;
        nArray3[250] = 148;
        nArray3[251] = 149;
        standardEncoding = nArray3;
    }

    public static String getName(int i) {
        if (i < stdNames.length) {
            return stdNames[i];
        }
        if ((i -= stdNames.length) < macExtras.length) {
            return macExtras[i];
        }
        return ".notdef";
    }

    public static int findName(String name, String[] table) {
        int i = 0;
        while (i < table.length) {
            if (name.equals(table[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findName(String name, int[] table) {
        int i = 0;
        while (i < table.length) {
            if (name.equals(FontSupport.getName(table[i]))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getStrIndex(String name) {
        int i = 0;
        while (i < stdNames.length) {
            if (name.equals(stdNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

