/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.addons.DefaultXMLExportAddOn;
import org.gtdfree.addons.ExportAddOn;
import org.gtdfree.addons.HTMLExportAddOn;
import org.gtdfree.addons.PDFExportAddOn;
import org.gtdfree.addons.PlainTextExportAddOn;
import org.gtdfree.gui.DatabaseSelectionDialog;
import org.gtdfree.gui.GTDFreePane;
import org.gtdfree.gui.StateMachine;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.journal.JournalModel;
import org.gtdfree.model.GTDDataODB;
import org.gtdfree.model.GTDDataXML;
import org.gtdfree.model.GTDModel;

public class GTDFreeEngine {
    private volatile GTDModel gtdModel;
    private Properties configuration;
    private GlobalProperties globalProperties;
    private JournalModel journalModel;
    private StateMachine stateMachine;
    private ActionMap actionMap;
    private boolean aborting = false;
    private List<ExportAddOn> exportAddOns;
    private GTDFreePane activePane;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private JDialog upgradeImportDialog;
    private Logger logger = Logger.getLogger(GTDFreeEngine.class);

    public Properties getConfiguration() {
        if (this.configuration == null) {
            this.configuration = ApplicationHelper.loadConfiguration();
        }
        return this.configuration;
    }

    public GTDModel getGTDModel() {
        if (this.gtdModel == null) {
            Object db = this.getGlobalProperties().getProperty("database");
            boolean doImport = false;
            if (db == null || !"odb".equalsIgnoreCase(db.toString()) && !"xml".equalsIgnoreCase(db.toString())) {
                DatabaseSelectionDialog d = new DatabaseSelectionDialog(null);
                d.setVisible(true);
                if (!d.isSuccess()) {
                    try {
                        this.close(true, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.exit(0);
                }
                db = d.getDatabase();
                doImport = d.isUpgrade();
                this.getGlobalProperties().putProperty("database", db);
            }
            if ("xml".equalsIgnoreCase(db.toString())) {
                GTDDataXML xml = new GTDDataXML(this.getDataFolder(), this.getGlobalProperties());
                try {
                    this.gtdModel = xml.restore();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        this.close(true, false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.exit(0);
                }
            } else {
                GTDDataODB odb = new GTDDataODB(this.getDataFolder(), this.getGlobalProperties());
                try {
                    this.gtdModel = odb.restore();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        this.close(true, false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.exit(0);
                }
                if (doImport) {
                    final GTDDataXML xml = new GTDDataXML(this.getDataFolder(), this.getGlobalProperties());
                    new Thread("UpgradeImportThread"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                GTDFreeEngine gTDFreeEngine = GTDFreeEngine.this;
                                synchronized (gTDFreeEngine) {
                                    GTDModel gtdXml = xml.restore();
                                    GTDFreeEngine.this.gtdModel.importData(gtdXml);
                                }
                                GTDFreeEngine.this.getUpgradeImportDialog(null).dispose();
                            }
                            catch (IOException e) {
                                GTDFreeEngine.this.getUpgradeImportDialog(null).dispose();
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, Messages.getString("GTDFreeEngine.XMLImport.1") + (e.getCause() != null ? e.getCause().toString() : e.toString()) + Messages.getString("GTDFreeEngine.XMLImport.2"), Messages.getString("GTDFreeEngine.XMLImport.Title"), 0);
                            }
                        }
                    }.start();
                    this.getUpgradeImportDialog(xml.getDataFile().toString()).setVisible(true);
                }
            }
            this.setAutoSave(this.getGlobalProperties().getBoolean("autoSave", true));
        }
        return this.gtdModel;
    }

    private JDialog getUpgradeImportDialog(String file) {
        if (this.upgradeImportDialog == null) {
            this.upgradeImportDialog = new JDialog();
            this.upgradeImportDialog.setTitle(Messages.getString("GTDFreeEngine.Upgrade.title"));
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            p.add((Component)new JLabel(Messages.getString("GTDFreeEngine.Upgrade.1") + file), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(11, 11, 4, 11), 0, 0));
            p.add((Component)new JLabel(Messages.getString("GTDFreeEngine.Upgrade.2")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
            JProgressBar pb = new JProgressBar();
            pb.setIndeterminate(true);
            p.add((Component)pb, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(4, 11, 11, 11), 0, 0));
            this.upgradeImportDialog.setContentPane(p);
            this.upgradeImportDialog.pack();
            this.upgradeImportDialog.setLocationRelativeTo(null);
            this.upgradeImportDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.upgradeImportDialog.setDefaultCloseOperation(0);
            this.upgradeImportDialog.setResizable(false);
        }
        return this.upgradeImportDialog;
    }

    public JournalModel getJournalModel() {
        if (this.journalModel == null) {
            this.journalModel = new JournalModel(this.getDataFolder(), this.getGTDModel());
        }
        return this.journalModel;
    }

    public void save() throws IOException, XMLStreamException, FactoryConfigurationError {
        if (this.isAborting()) {
            return;
        }
        this.gtdModel.getDataRepository().flush();
    }

    public void emergencySave() {
        File save = ApplicationHelper.getShutdownBackupXMLFile();
        if (save.exists() && !save.delete()) {
            new IOException(Messages.getString("GTDFreeEngine.BackupRemoveFailed.1") + save.getAbsolutePath() + Messages.getString("GTDFreeEngine.BackupRemoveFailed.2")).toString();
        }
        try {
            this.gtdModel.exportXML(save);
            this.logger.info(Messages.getString("GTDFreeEngine.BackupSaved") + save.getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("GTDFreeEngine.BackupFailed") + save.getAbsolutePath(), e);
        }
    }

    public File getDataFolder() {
        return ApplicationHelper.getDataFolder();
    }

    public boolean isAutoSave() {
        if (this.gtdModel != null && this.gtdModel.getDataRepository() instanceof GTDDataXML) {
            return ((GTDDataXML)this.gtdModel.getDataRepository()).isAutoSave();
        }
        return true;
    }

    public void setAutoSave(boolean autoSave) {
        if (this.gtdModel != null && this.gtdModel.getDataRepository() instanceof GTDDataXML) {
            ((GTDDataXML)this.gtdModel.getDataRepository()).setAutoSave(autoSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalProperties getGlobalProperties() {
        if (this.globalProperties == null) {
            this.globalProperties = new GlobalProperties();
            File f = new File(this.getDataFolder(), "gtd-free-options.properties");
            if (f.exists()) {
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(f));
                    this.globalProperties.load(r);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (r != null) {
                            r.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.globalProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean terminal, boolean emergencySave) throws IOException, XMLStreamException, FactoryConfigurationError {
        if (this.aborting) {
            return true;
        }
        if (emergencySave || this.getGlobalProperties().getBoolean("shutdownBuckupXML", true)) {
            this.emergencySave();
        }
        if (this.gtdModel != null) {
            try {
                boolean close = this.gtdModel.getDataRepository().close(terminal);
                if (!close && !terminal) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.aborting = true;
        this.firePropertyChange("aborting", true, false);
        File f = new File(this.getDataFolder(), "gtd-free-options.properties");
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(f));
            this.globalProperties.store(w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException e) {}
        }
        return true;
    }

    public StateMachine getStateMachine() {
        if (this.stateMachine == null) {
            this.stateMachine = new StateMachine();
        }
        return this.stateMachine;
    }

    public ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public boolean isAborting() {
        return this.aborting;
    }

    public ExportAddOn[] getExportAddOns() {
        if (this.exportAddOns == null) {
            this.exportAddOns = new ArrayList<ExportAddOn>(10);
            this.exportAddOns.add(new DefaultXMLExportAddOn());
            this.exportAddOns.add(new PDFExportAddOn());
            this.exportAddOns.add(new HTMLExportAddOn());
            this.exportAddOns.add(new PlainTextExportAddOn());
        }
        return this.exportAddOns.toArray(new ExportAddOn[this.exportAddOns.size()]);
    }

    public void setActivePane(GTDFreePane c) {
        if (c == this.activePane) {
            return;
        }
        GTDFreePane old = this.activePane;
        this.activePane = c;
        this.firePropertyChange("activePane", old, this.activePane);
    }

    private void firePropertyChange(String name, Object old, Object val) {
        this.support.firePropertyChange(name, old, val);
    }

    public GTDFreePane getActivePane() {
        return this.activePane;
    }

    public WorkflowPane getActiveWorkflowPane() {
        if (this.activePane instanceof WorkflowPane) {
            return (WorkflowPane)this.activePane;
        }
        return null;
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.support.addPropertyChangeListener(name, l);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.support.removePropertyChangeListener(name, l);
    }
}

