/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import de.wannawork.jcalendar.JCalendarComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.gui.InputTextArea;
import org.gtdfree.gui.PriorityPicker;
import org.gtdfree.gui.ProjectsCombo;
import org.gtdfree.model.Action;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.FolderListener;
import org.gtdfree.model.Priority;

public class ActionPanel
extends JPanel
implements FolderListener {
    private static final long serialVersionUID = -7868587669764300896L;
    private JLabel idLabel;
    private JLabel createdLabel;
    private InputTextArea descText;
    private JTextField urlText;
    private Action[] actions;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private boolean setting = false;
    private AbstractAction deleteAction;
    private AbstractAction resolveAction;
    private JCalendarComboBox datePicker;
    private ProjectsCombo projectCombo;
    private GTDFreeEngine engine;
    private AbstractAction reopenAction;
    private JLabel folderLabel;
    private AbstractAction queuedAction;
    private JToggleButton queueActionButton;
    private AbstractAction openURLAction;
    private JScrollPane descTextScroll;
    private PriorityPicker priorityPanel;
    private JButton selectNextButton;
    private JButton selectPreviousButton;
    private JButton reopenButton;
    private JPanel buttonsPanel;
    private JButton clearDateButton;
    private boolean reopenButtonVisible = false;

    public ActionPanel() {
        this.initialize(true);
    }

    public ActionPanel(boolean packHor) {
        this.initialize(packHor);
    }

    private void initialize(boolean packHorizontal) {
        this.setLayout(new GridBagLayout());
        int row = 0;
        JPanel p = null;
        JLabel jl = new JLabel(Messages.getString("ActionPanel.ID"));
        if (packHorizontal) {
            this.add((Component)jl, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p = new JPanel();
            p.setLayout(new GridBagLayout());
            p.add((Component)jl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.idLabel = new JLabel(Messages.getString("ActionPanel.NA"));
        Dimension d = new Dimension(100, 21);
        this.idLabel.setPreferredSize(d);
        this.idLabel.setMinimumSize(d);
        if (packHorizontal) {
            this.add((Component)this.idLabel, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)this.idLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        jl = new JLabel(Messages.getString("ActionPanel.Created"));
        if (packHorizontal) {
            this.add((Component)jl, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)jl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.createdLabel = new JLabel(Messages.getString("ActionPanel.NA"));
        this.createdLabel.setPreferredSize(d);
        this.createdLabel.setMinimumSize(d);
        if (packHorizontal) {
            this.add((Component)this.createdLabel, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)this.createdLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        jl = new JLabel(Messages.getString("ActionPanel.Folder"));
        if (packHorizontal) {
            this.add((Component)jl, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)jl, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.folderLabel = new JLabel(Messages.getString("ActionPanel.NA"));
        this.folderLabel.setPreferredSize(d);
        this.folderLabel.setMinimumSize(d);
        if (packHorizontal) {
            this.add((Component)this.folderLabel, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)this.folderLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
            this.add((Component)p, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.descText = new InputTextArea();
        this.descText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (ActionPanel.this.setting || ActionPanel.this.actions == null) {
                    return;
                }
                ActionPanel.this.actions[0].setDescription(ActionPanel.this.descText.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ActionPanel.this.setting || ActionPanel.this.actions == null) {
                    return;
                }
                ActionPanel.this.actions[0].setDescription(ActionPanel.this.descText.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (ActionPanel.this.setting || ActionPanel.this.actions == null) {
                    return;
                }
                ActionPanel.this.actions[0].setDescription(ActionPanel.this.descText.getText());
            }
        });
        this.descTextScroll = new JScrollPane(this.descText);
        if (packHorizontal) {
            this.add((Component)this.descTextScroll, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 17));
        } else {
            this.add((Component)this.descTextScroll, new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 17));
        }
        jl = new JLabel(Messages.getString("ActionPanel.URL"));
        if (packHorizontal) {
            this.add((Component)jl, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.urlText = new JTextField();
        this.urlText.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                URL url = null;
                try {
                    String s = ActionPanel.this.urlText.getText().trim();
                    StringBuilder sb = new StringBuilder(s.length());
                    for (int i = 0; i < s.length(); ++i) {
                        char c = s.charAt(i);
                        if (Character.isISOControl(c)) continue;
                        sb.append(c);
                    }
                    url = new URL(sb.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (url != null) {
                    ActionPanel.this.urlText.setForeground(Color.black);
                    if (ActionPanel.this.actions != null) {
                        ActionPanel.this.setting = true;
                        ActionPanel.this.actions[0].setUrl(url);
                        ActionPanel.this.setting = false;
                    }
                } else {
                    ActionPanel.this.urlText.setForeground(Color.red);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        if (packHorizontal) {
            this.add((Component)this.urlText, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        JButton b = new JButton();
        b.setMargin(ApplicationHelper.getDefaulSlimButtonMargin());
        b.setAction(this.getOpenURLAction());
        if (packHorizontal) {
            this.add((Component)b, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p = new JPanel();
            p.setLayout(new GridBagLayout());
            p.add((Component)jl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
            p.add((Component)this.urlText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
            p.add((Component)b, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.add((Component)p, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        jl = new JLabel(Messages.getString("ActionPanel.Project"));
        if (packHorizontal) {
            this.add((Component)jl, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p = new JPanel();
            p.setLayout(new GridBagLayout());
            p.add((Component)jl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.projectCombo = new ProjectsCombo();
        this.projectCombo.addPropertyChangeListener("selectedProject", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ActionPanel.this.setting || ActionPanel.this.actions == null) {
                    return;
                }
                ActionPanel.this.setting = true;
                if (ActionPanel.this.projectCombo.getSelectedProject() != null) {
                    for (Action a : ActionPanel.this.actions) {
                        a.setProject(ActionPanel.this.projectCombo.getSelectedProject().getId());
                    }
                } else {
                    for (Action a : ActionPanel.this.actions) {
                        a.setProject(null);
                    }
                }
                ActionPanel.this.setting = false;
            }
        });
        if (packHorizontal) {
            this.add((Component)this.projectCombo, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)this.projectCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        if (packHorizontal) {
            this.add((Component)new JLabel(Messages.getString("ActionPanel.Reminder")), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)new JLabel(Messages.getString("ActionPanel.Reminder")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        JPanel pp = new JPanel();
        pp.setLayout(new GridBagLayout());
        this.datePicker = new JCalendarComboBox(){
            private static final long serialVersionUID = 1L;
            Dimension d = null;

            @Override
            public Dimension getPreferredSize() {
                int w;
                if (this.d == null) {
                    Insets in = ApplicationHelper.getDefaulSlimButtonMargin();
                    this.d = new Dimension(super.getPreferredSize().width + 6, super.getPreferredSize().height + in.top + in.bottom - 4);
                }
                if ((w = super.getPreferredSize().width + 6) > this.d.width) {
                    this.d = new Dimension(w, this.d.height);
                }
                return this.d;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.datePicker.setDateFormat(ApplicationHelper.defaultDateFormat);
        d = new Dimension(this.datePicker.getPreferredSize().height, this.datePicker.getPreferredSize().height);
        this.datePicker.setDate(null);
        this.datePicker.setSpiningCalendarField(5);
        this.datePicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ActionPanel.this.setting) {
                    return;
                }
                if (ActionPanel.this.actions != null) {
                    for (Action a : ActionPanel.this.actions) {
                        a.setRemind(ActionPanel.this.datePicker.getDate());
                    }
                }
            }
        });
        pp.add((Component)this.datePicker, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 2), 0, 0));
        this.clearDateButton = new JButton();
        this.clearDateButton.setMargin(ApplicationHelper.getDefaulSlimButtonMargin());
        this.clearDateButton.setToolTipText(Messages.getString("ActionPanel.Clear"));
        this.clearDateButton.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_clear));
        this.clearDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionPanel.this.datePicker.setDate(null);
            }
        });
        pp.add((Component)this.clearDateButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (packHorizontal) {
            this.add((Component)pp, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)pp, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        }
        jl = new JLabel(Messages.getString("ActionPanel.Priority"));
        if (packHorizontal) {
            this.add((Component)jl, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            p.add((Component)jl, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.priorityPanel = new PriorityPicker();
        this.priorityPanel.addPropertyChangeListener("priority", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ActionPanel.this.setting || ActionPanel.this.actions == null) {
                    return;
                }
                ActionPanel.this.setting = true;
                for (Action a : ActionPanel.this.actions) {
                    a.setPriority(ActionPanel.this.priorityPanel.getPriority());
                }
                ActionPanel.this.setting = false;
            }
        });
        if (packHorizontal) {
            this.add((Component)this.priorityPanel, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 0, new Insets(4, 1, 4, 1), 0, 0));
        } else {
            p.add((Component)this.priorityPanel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 1, 4, 1), 0, 0));
            this.add((Component)p, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        int buttonIndex = 0;
        jp.add((Component)new JLabel(Messages.getString("ActionPanel.Go")), new GridBagConstraints(buttonIndex++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(1, 1, 1, 4), 0, 0));
        this.selectPreviousButton = new JButton();
        this.selectPreviousButton.setHideActionText(true);
        this.selectPreviousButton.setEnabled(false);
        this.selectPreviousButton.setMargin(ApplicationHelper.getDefaulSlimButtonMargin());
        jp.add((Component)this.selectPreviousButton, new GridBagConstraints(buttonIndex++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.selectNextButton = new JButton();
        this.selectNextButton.setHideActionText(true);
        this.selectNextButton.setEnabled(false);
        this.selectNextButton.setMargin(ApplicationHelper.getDefaulSlimButtonMargin());
        jp.add((Component)this.selectNextButton, new GridBagConstraints(buttonIndex++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        jp.add((Component)new JLabel(Messages.getString("ActionPanel.Move")), new GridBagConstraints(buttonIndex++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(1, 4, 1, 4), 0, 0));
        this.moveDownButton = new JButton();
        this.moveDownButton.setHideActionText(true);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setMargin(ApplicationHelper.getDefaulSlimButtonMargin());
        jp.add((Component)this.moveDownButton, new GridBagConstraints(buttonIndex++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.moveUpButton = new JButton();
        this.moveUpButton.setHideActionText(true);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setMargin(ApplicationHelper.getDefaulSlimButtonMargin());
        jp.add((Component)this.moveUpButton, new GridBagConstraints(buttonIndex++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        if (packHorizontal) {
            this.add((Component)jp, new GridBagConstraints(0, ++row, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            this.add((Component)jp, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridBagLayout());
        buttonIndex = 0;
        this.queueActionButton = new JToggleButton();
        this.queueActionButton.setMargin(ApplicationHelper.getDefaulFatButtonMargin());
        this.queueActionButton.setAction(this.getQueuedAction());
        this.queueActionButton.setRolloverEnabled(false);
        this.queueActionButton.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_queue_off));
        this.queueActionButton.setSelectedIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_queue_on));
        this.queueActionButton.setDisabledSelectedIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_queue_off));
        this.buttonsPanel.add((Component)this.queueActionButton, new GridBagConstraints(buttonIndex++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        b = new JButton();
        b.setMargin(ApplicationHelper.getDefaulFatButtonMargin());
        b.setAction(this.getResolveAction());
        this.buttonsPanel.add((Component)b, new GridBagConstraints(buttonIndex++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        b = new JButton();
        b.setMargin(ApplicationHelper.getDefaulFatButtonMargin());
        b.setAction(this.getDeleteAction());
        this.buttonsPanel.add((Component)b, new GridBagConstraints(buttonIndex++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.reopenButton = new JButton();
        this.reopenButton.setMargin(ApplicationHelper.getDefaulFatButtonMargin());
        this.reopenButton.setAction(this.getReopenAction());
        this.reopenButton.setVisible(false);
        this.buttonsPanel.add((Component)this.reopenButton, new GridBagConstraints(buttonIndex++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        if (packHorizontal) {
            this.add((Component)this.buttonsPanel, new GridBagConstraints(0, ++row, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        } else {
            this.add((Component)this.buttonsPanel, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.setEnabled(false);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.buttonsPanel.getPreferredSize().width, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.buttonsPanel.getMinimumSize().width, super.getMinimumSize().height);
    }

    private javax.swing.Action getOpenURLAction() {
        if (this.openURLAction == null) {
            this.openURLAction = new AbstractAction("", ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_browser)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ActionPanel.this.actions != null && ActionPanel.this.actions[0].getUrl() != null) {
                        try {
                            Desktop.getDesktop().browse(ActionPanel.this.actions[0].getUrl().toURI());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            JOptionPane.showConfirmDialog(ActionPanel.this, Messages.getString("ActionPanel.LinkError.1") + ActionPanel.this.actions[0].getUrl() + Messages.getString("ActionPanel.LinkError.2") + e1.getMessage(), Messages.getString("ActionPanel.LinkError.title"), 0, 0);
                        }
                    }
                }
            };
            this.openURLAction.putValue("ShortDescription", Messages.getString("ActionPanel.Link.desc"));
            this.openURLAction.setEnabled(false);
        }
        return this.openURLAction;
    }

    private javax.swing.Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(Messages.getString("ActionPanel.Delete"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_delete)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action[] aa;
                    for (Action a : aa = ActionPanel.this.actions) {
                        a.setResolution(Action.Resolution.DELETED);
                    }
                }
            };
            this.deleteAction.putValue("ShortDescription", Messages.getString("ActionPanel.Delete.desc"));
            this.deleteAction.setEnabled(false);
        }
        return this.deleteAction;
    }

    private javax.swing.Action getResolveAction() {
        if (this.resolveAction == null) {
            this.resolveAction = new AbstractAction(Messages.getString("ActionPanel.Resolve"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_resolve)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action[] aa;
                    for (Action a : aa = ActionPanel.this.actions) {
                        a.setResolution(Action.Resolution.RESOLVED);
                    }
                }
            };
            this.resolveAction.putValue("ShortDescription", Messages.getString("ActionPanel.Resolve.desc"));
            this.resolveAction.setEnabled(false);
        }
        return this.resolveAction;
    }

    private javax.swing.Action getQueuedAction() {
        if (this.queuedAction == null) {
            this.queuedAction = new AbstractAction(Messages.getString("ActionPanel.Queue")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action[] aa = ActionPanel.this.actions;
                    boolean b = ActionPanel.this.queueActionButton.isSelected();
                    for (Action a : aa) {
                        a.setQueued(b);
                    }
                }
            };
            this.queuedAction.putValue("ShortDescription", Messages.getString("ActionPanel.Queue.desc"));
            this.queuedAction.setEnabled(false);
        }
        return this.queuedAction;
    }

    private javax.swing.Action getReopenAction() {
        if (this.reopenAction == null) {
            this.reopenAction = new AbstractAction(Messages.getString("ActionPanel.Reopen"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_undelete)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action[] aa;
                    for (Action a : aa = ActionPanel.this.actions) {
                        a.setResolution(Action.Resolution.OPEN);
                    }
                }
            };
            this.reopenAction.putValue("ShortDescription", Messages.getString("ActionPanel.Reopen.desc"));
            this.reopenAction.setEnabled(false);
        }
        return this.reopenAction;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public void setActions(Action[] action) {
        if (this.actions != null) {
            for (Action a : this.actions) {
                a.getParent().removeFolderListener(this);
            }
        }
        this.actions = action;
        this.updateGUI();
        this.setEnabled(action != null);
        if (this.actions != null) {
            for (Action a : this.actions) {
                a.getParent().addFolderListener(this);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.descText.setEnabled(enabled);
        this.urlText.setEnabled(enabled);
        this.datePicker.setEnabled(enabled);
        this.clearDateButton.setEnabled(enabled);
        this.projectCombo.setEnabled(enabled);
        this.priorityPanel.setEnabled(enabled);
        boolean hasOpen = Action.hasOpen(this.actions);
        this.getReopenAction().setEnabled(enabled && Action.hasNonOpen(this.actions));
        this.getResolveAction().setEnabled(enabled && hasOpen);
        this.getDeleteAction().setEnabled(enabled && Action.hasNonDeleted(this.actions));
        this.getQueuedAction().setEnabled(enabled && hasOpen);
        this.getOpenURLAction().setEnabled(enabled && this.actions != null && this.actions[0].getUrl() != null);
    }

    private void updateGUI() {
        boolean hasOpen = Action.hasOpen(this.actions);
        this.getReopenAction().setEnabled(Action.hasNonOpen(this.actions));
        this.getResolveAction().setEnabled(hasOpen);
        this.getDeleteAction().setEnabled(Action.hasNonDeleted(this.actions));
        this.getQueuedAction().setEnabled(hasOpen);
        this.getOpenURLAction().setEnabled(this.actions != null && this.actions[0].getUrl() != null);
        if (this.actions == null) {
            this.idLabel.setText(Messages.getString("ActionPanel.NA"));
            this.createdLabel.setText(Messages.getString("ActionPanel.NA"));
            this.folderLabel.setText(Messages.getString("ActionPanel.NA"));
            this.descText.setText("");
            this.descText.clearUndoHistory();
            this.urlText.setText("");
            this.projectCombo.setSelectedProject(null);
            this.datePicker.setDate(null);
            this.priorityPanel.setPriority(Priority.None);
        } else if (this.actions.length == 1) {
            String s = String.valueOf(this.actions[0].getId());
            this.idLabel.setText(s);
            s = ApplicationHelper.toISODateTimeString(this.actions[0].getCreated());
            this.createdLabel.setText(s);
            this.folderLabel.setText(this.actions[0].getParent().getName());
            if (!this.setting) {
                this.setting = true;
                if (this.queueActionButton.isSelected() != this.actions[0].isQueued()) {
                    this.queueActionButton.setSelected(this.actions[0].isQueued());
                }
                s = this.actions[0].getDescription() == null ? "" : this.actions[0].getDescription();
                this.descText.setEditable(true);
                this.descText.setEnabled(true);
                if (!s.equals(this.descText.getText())) {
                    this.descText.setText(s);
                    this.descText.setCaretPosition(0);
                    this.descText.clearUndoHistory();
                }
                if (this.actions[0].getUrl() != null) {
                    this.urlText.setText(this.actions[0].getUrl().toString());
                } else {
                    this.urlText.setText("");
                }
                if (this.actions[0].getRemind() != null) {
                    if (!this.actions[0].getRemind().equals(this.datePicker.getDate())) {
                        this.datePicker.setDate(this.actions[0].getRemind());
                    }
                } else if (this.datePicker.getDate() != null) {
                    this.datePicker.setDate(null);
                }
                if (this.actions[0].getProject() != null) {
                    this.projectCombo.setSelectedProject(this.actions[0].getParent().getParent().getProject(this.actions[0].getProject()));
                } else {
                    this.projectCombo.setSelectedProject(null);
                }
                this.priorityPanel.setPriority(this.actions[0].getPriority());
                this.setting = false;
            }
        } else {
            String s = Messages.getString("ActionPanel.Multi");
            this.idLabel.setText(s);
            this.createdLabel.setText(s);
            this.folderLabel.setText(s);
            this.descText.setEditable(false);
            this.descText.setEnabled(false);
            if (!this.setting) {
                this.setting = true;
                this.descText.setText(s);
                this.urlText.setText("");
                this.datePicker.setDate(null);
                this.projectCombo.setSelectedProject(null);
                this.priorityPanel.setPriority(null);
                this.setting = false;
            }
        }
    }

    public static void main(String[] args) {
        try {
            JFrame f = new JFrame();
            ActionPanel ap = new ActionPanel(false);
            ap.setEnabled(true);
            f.setContentPane(ap);
            f.setSize(300, 300);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.toString();
        }
    }

    @Override
    public void elementAdded(FolderEvent note) {
    }

    @Override
    public void elementModified(org.gtdfree.model.ActionEvent note) {
        if (note.getAction() == this.actions[0]) {
            this.updateGUI();
        }
    }

    @Override
    public void elementRemoved(FolderEvent note) {
    }

    @Override
    public void orderChanged(Folder f) {
    }

    public GTDFreeEngine getEngine() {
        return this.engine;
    }

    public void setEngine(GTDFreeEngine e) {
        this.engine = e;
        this.projectCombo.setGTDModel(this.engine.getGTDModel());
        this.engine.getGlobalProperties().addPropertyChangeListener("showAllActions", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ActionPanel.this.reopenButton.setVisible(ActionPanel.this.engine.getGlobalProperties().getBoolean("showAllActions"));
            }
        });
        this.reopenButton.setVisible(this.reopenButtonVisible || this.engine.getGlobalProperties().getBoolean("showAllActions"));
    }

    public void setDescriptionTextMinimumHeight(int min) {
        this.descTextScroll.setMinimumSize(new Dimension(this.descTextScroll.getMinimumSize().width, min));
    }

    public int getDescriptionTextMinimumHeight() {
        return this.descTextScroll.getMinimumSize().height;
    }

    public void putActions(ActionMap actions) {
        this.moveDownButton.setAction(actions.get("actionTable.moveDown"));
        this.moveUpButton.setAction(actions.get("actionTable.moveUp"));
        this.selectNextButton.setAction(actions.get("actionTable.selectNext"));
        this.selectPreviousButton.setAction(actions.get("actionTable.selectPrevious"));
    }

    public void setReopenButtonVisible(boolean b) {
        this.reopenButtonVisible = b;
        this.reopenButton.setVisible(this.reopenButtonVisible || this.engine.getGlobalProperties().getBoolean("showAllActions"));
    }

    public boolean isReopenButtonVisible() {
        return this.reopenButtonVisible;
    }
}

