/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.BorderLayout;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gtdfree.gui.InputTextArea;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionEvent;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.FolderListener;

public class ActionSpinner
extends JPanel
implements FolderListener {
    private static final long serialVersionUID = -7868587669764300896L;
    private JTextArea descText;
    private Action selectedAction;
    private Folder folder;
    private JSpinner spinner;
    private FolderModel model;
    private boolean setting;

    public ActionSpinner() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.descText = new InputTextArea();
        this.descText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (ActionSpinner.this.setting || ActionSpinner.this.selectedAction == null) {
                    return;
                }
                ActionSpinner.this.selectedAction.setDescription(ActionSpinner.this.descText.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ActionSpinner.this.setting || ActionSpinner.this.selectedAction == null) {
                    return;
                }
                ActionSpinner.this.selectedAction.setDescription(ActionSpinner.this.descText.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (ActionSpinner.this.setting || ActionSpinner.this.selectedAction == null) {
                    return;
                }
                ActionSpinner.this.selectedAction.setDescription(ActionSpinner.this.descText.getText());
            }
        });
        JScrollPane sp = new JScrollPane(this.descText);
        this.spinner = new JSpinner();
        this.spinner.setEditor(sp);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Action a = ActionSpinner.this.selectedAction;
                ActionSpinner.this.selectedAction = (Action)ActionSpinner.this.spinner.getValue();
                ActionSpinner.this.updateGUI();
                ActionSpinner.this.firePropertyChange("selectedAction", a, ActionSpinner.this.selectedAction);
            }
        });
        this.model = new FolderModel();
        this.spinner.setModel(this.model);
        this.add(this.spinner);
        this.updateGUI();
    }

    public Action getSelectedAction() {
        return this.selectedAction;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descText.setEnabled(enabled);
        this.spinner.setEnabled(enabled && this.folder != null && this.folder.size() > 0);
    }

    private void updateGUI() {
        Action a = this.selectedAction;
        if (a == null) {
            this.descText.setEnabled(false);
            this.descText.setEditable(false);
            this.descText.setText("");
        } else {
            String s;
            this.setting = true;
            this.descText.setEnabled(true);
            this.descText.setEditable(true);
            String string = s = a.getDescription() == null ? "" : a.getDescription();
            if (!s.equals(this.descText.getText())) {
                this.descText.setText(s);
                this.descText.setCaretPosition(0);
            }
            this.setting = false;
        }
    }

    public static void main(String[] args) {
        try {
            JFrame f = new JFrame();
            ActionSpinner ap = new ActionSpinner();
            ap.setEnabled(true);
            f.setContentPane(ap);
            f.setSize(300, 300);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.toString();
        }
    }

    @Override
    public void elementAdded(FolderEvent note) {
        if (this.selectedAction == null) {
            this.model.reset();
        }
    }

    @Override
    public void elementModified(ActionEvent note) {
        if (this.model.getValue() == this.selectedAction) {
            this.updateGUI();
        } else {
            this.model.fireStateChanged();
        }
    }

    @Override
    public void elementRemoved(FolderEvent note) {
        this.model.removed(note.getAction());
    }

    @Override
    public void orderChanged(Folder f) {
        int i = this.folder.indexOf(this.selectedAction);
        if (i < 0) {
            this.model.reset();
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void setFolder(Folder f) {
        this.folder = f;
        this.folder.addFolderListener(this);
        this.model.reset();
    }

    class FolderModel
    extends AbstractSpinnerModel {
        private int index;
        private int lastIndex;

        FolderModel() {
        }

        @Override
        public void setValue(Object value) {
            int i = ActionSpinner.this.folder.indexOf((Action)value);
            if (i != this.index) {
                this.index = i;
                this.fireStateChanged();
            }
        }

        @Override
        public Object getValue() {
            Action a;
            if (ActionSpinner.this.folder == null || ActionSpinner.this.folder.size() == 0) {
                return null;
            }
            if (this.index >= ActionSpinner.this.folder.size()) {
                this.index = ActionSpinner.this.folder.size() - 1;
            }
            if (!(a = ActionSpinner.this.folder.get(this.index)).isOpen()) {
                a = (Action)this.getNextValue();
                if (a == null) {
                    a = (Action)this.getPreviousValue();
                }
                this.index = this.lastIndex;
            }
            return a;
        }

        @Override
        public Object getPreviousValue() {
            return this.getPreviousValue(this.index);
        }

        private Object getPreviousValue(int i) {
            if (ActionSpinner.this.folder == null || ActionSpinner.this.folder.size() == 0 || i >= ActionSpinner.this.folder.size() - 1) {
                return null;
            }
            this.lastIndex = i + 1;
            Action a = ActionSpinner.this.folder.get(this.lastIndex);
            if (!a.isOpen()) {
                a = (Action)this.getPreviousValue(this.lastIndex);
            }
            return a;
        }

        @Override
        public Object getNextValue() {
            return this.getNextValue(this.index);
        }

        private Object getNextValue(int i) {
            if (ActionSpinner.this.folder == null || ActionSpinner.this.folder.size() <= 0 || i == 0) {
                return null;
            }
            this.lastIndex = i - 1;
            Action a = ActionSpinner.this.folder.get(this.lastIndex);
            if (!a.isOpen()) {
                a = (Action)this.getNextValue(this.lastIndex);
            }
            return a;
        }

        @Override
        public void fireStateChanged() {
            super.fireStateChanged();
        }

        public void reset() {
            this.index = 0;
            this.fireStateChanged();
        }

        public void removed(Action action) {
            if (action == ActionSpinner.this.selectedAction) {
                Object a = this.getPreviousValue();
                if (a == null) {
                    a = this.getNextValue();
                }
                this.index = this.lastIndex;
                this.fireStateChanged();
            } else {
                int i = ActionSpinner.this.folder.indexOf(ActionSpinner.this.selectedAction);
                if (i < 0) {
                    this.reset();
                }
            }
        }
    }
}

