/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.BorderLayout;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.gui.ActionPanel;
import org.gtdfree.gui.ActionTable;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.Folder;

public class ExecutePane
extends JPanel
implements WorkflowPane {
    private static final long serialVersionUID = 1L;
    private ActionPanel actionPanel;
    private ActionTable queueTable;
    private GTDFreeEngine engine;
    private JSplitPane split;

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane();
        this.split.setOrientation(0);
        this.split.setOneTouchExpandable(true);
        this.actionPanel = new ActionPanel(false);
        this.actionPanel.setBorder(new TitledBorder(Messages.getString("ExecutePane.NextA")));
        this.split.setTopComponent(this.actionPanel);
        this.queueTable = new ActionTable();
        this.queueTable.setCellAction(ActionTable.CellAction.RESOLVE);
        this.queueTable.setMoveEnabled(true);
        this.queueTable.addPropertyChangeListener("selectedActions", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExecutePane.this.actionPanel.setActions(ExecutePane.this.queueTable.getSelectedActions());
            }
        });
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.setBorder(new TitledBorder(Messages.getString("ExecutePane.NextQ")));
        jp.add(new JScrollPane(this.queueTable));
        this.split.setBottomComponent(jp);
        this.actionPanel.putActions(this.queueTable.getActionMap());
        this.add(this.split);
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        this.queueTable.setEngine(engine);
        this.queueTable.setFolder(engine.getGTDModel().getQueue());
        this.actionPanel.setEngine(engine);
    }

    public GTDFreeEngine getEngine() {
        return this.engine;
    }

    public void store(GlobalProperties p) {
        p.putProperty("execute.dividerLocation", this.split.getDividerLocation());
    }

    public void restore(GlobalProperties p) {
        Integer i = p.getInteger("execute.dividerLocation");
        if (i != null) {
            this.split.setDividerLocation(i);
        }
    }

    @Override
    public ActionsCollection getActionsInView() {
        return new ActionsCollection(this.queueTable);
    }

    public void printTable() throws PrinterException {
        this.queueTable.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("GTD-Free Data - Next Action Queue - " + ApplicationHelper.toISODateTimeString(new Date())), new MessageFormat("Page - {0}"));
    }

    @Override
    public void initialize(GTDFreeEngine engine) {
        this.initialize();
        this.setEngine(engine);
        this.restore(engine.getGlobalProperties());
    }

    @Override
    public boolean isInitialized() {
        return this.engine != null;
    }

    @Override
    public Folder getSelectedFolder() {
        return this.queueTable.getFolder();
    }
}

