/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.gui.AbstractFilterPanel;
import org.gtdfree.gui.PriorityPicker;
import org.gtdfree.gui.ProjectsCombo;
import org.gtdfree.model.DescriptionFilter;
import org.gtdfree.model.FilterList;
import org.gtdfree.model.Priority;
import org.gtdfree.model.PriorityFilter;
import org.gtdfree.model.ProjectFilter;

public class FilterPanel
extends AbstractFilterPanel {
    private static final long serialVersionUID = 1L;
    static final Color UNCLEAN = Color.YELLOW;
    JTextField criterionText;
    JButton clearButton;
    Color bg;
    JButton searchOptionsButton;
    JPopupMenu searchOptionsMenu;
    JCheckBoxMenuItem caseSensitiveMenuItem;
    JCheckBox filterProject;
    ProjectsCombo projects;
    JCheckBox filterPriority;
    PriorityPicker priority;

    public FilterPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        int col = 0;
        String tt = Messages.getString("FilterPanel.Desc");
        this.setToolTipText(tt);
        JLabel jl = new JLabel(Messages.getString("FilterPanel.Filter") + " ");
        jl.setToolTipText(tt);
        this.add((Component)jl, new GridBagConstraints(col, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.filterProject = new JCheckBox(Messages.getString("FilterPanel.Project") + " ");
        int w = this.filterProject.getPreferredSize().height - 5;
        this.filterProject.setMinimumSize(new Dimension(w, w));
        tt = Messages.getString("FilterPanel.Project.desc");
        this.filterProject.setToolTipText(tt);
        this.filterProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterPanel.this.projects.setEnabled(FilterPanel.this.filterProject.isSelected());
                FilterPanel.this.fireSearch();
            }
        });
        this.add((Component)this.filterProject, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.projects = new ProjectsCombo();
        this.projects.setEditable(false);
        this.projects.setEnabled(false);
        this.projects.setToolTipText(tt);
        this.projects.addPropertyChangeListener("selectedProject", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (FilterPanel.this.isEnabled() && FilterPanel.this.filterProject.isSelected()) {
                    FilterPanel.this.fireSearch();
                }
            }
        });
        this.add((Component)this.projects, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 8), 0, 0));
        this.filterPriority = new JCheckBox(Messages.getString("FilterPanel.Priority") + " ");
        w = this.filterPriority.getPreferredSize().height - 5;
        this.filterPriority.setMinimumSize(new Dimension(w, w));
        tt = Messages.getString("FilterPanel.Priority.desc");
        this.filterPriority.setToolTipText(tt);
        this.filterPriority.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterPanel.this.priority.setEnabled(FilterPanel.this.filterPriority.isSelected());
                FilterPanel.this.fireSearch();
            }
        });
        this.add((Component)this.filterPriority, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.priority = new PriorityPicker();
        this.priority.setEnabled(false);
        this.priority.addPropertyChangeListener("priority", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (FilterPanel.this.isEnabled() && FilterPanel.this.filterPriority.isSelected()) {
                    FilterPanel.this.fireSearch();
                }
            }
        });
        this.add((Component)this.priority, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 8), 0, 0));
        this.searchOptionsMenu = new JPopupMenu();
        this.caseSensitiveMenuItem = new JCheckBoxMenuItem(Messages.getString("FilterPanel.CaseSensitive"));
        this.searchOptionsMenu.add(this.caseSensitiveMenuItem);
        this.searchOptionsButton = new JButton();
        this.searchOptionsButton.setIcon(new Icon(){
            Icon find = ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_search);
            Icon down = ApplicationHelper.getIcon("icons/gnome/9x9/stock/data/stock_data-down.png");

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.find == null || this.down == null) {
                    return;
                }
                this.find.paintIcon(c, g, x, y);
                this.down.paintIcon(c, g, x + this.find.getIconWidth() + 3, y + (int)((double)(this.find.getIconHeight() - this.down.getIconHeight()) / 2.0));
            }

            @Override
            public int getIconWidth() {
                return this.find.getIconWidth() + 3 + this.down.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.find.getIconHeight();
            }
        });
        this.searchOptionsButton.setDisabledIcon(new Icon(){
            Icon find = new ImageIcon(GrayFilter.createDisabledImage(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_search).getImage()));
            Icon down = new ImageIcon(GrayFilter.createDisabledImage(ApplicationHelper.getIcon("icons/gnome/9x9/stock/data/stock_data-down.png").getImage()));

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.find == null || this.down == null) {
                    return;
                }
                this.find.paintIcon(c, g, x, y);
                this.down.paintIcon(c, g, x + this.find.getIconWidth() + 3, y + (int)((double)(this.find.getIconHeight() - this.down.getIconHeight()) / 2.0));
            }

            @Override
            public int getIconWidth() {
                return this.find.getIconWidth() + 3 + this.down.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.find.getIconHeight();
            }
        });
        this.searchOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterPanel.this.searchOptionsMenu.show(FilterPanel.this.searchOptionsButton, 0, FilterPanel.this.searchOptionsButton.getHeight());
            }
        });
        this.searchOptionsButton.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.searchOptionsButton, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.criterionText = new JTextField(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                if (this.isPreferredSizeSet()) {
                    return super.getPreferredSize();
                }
                Dimension d = this.getUI().getPreferredSize(this);
                if (d.width < 200) {
                    return new Dimension(200, d.height);
                }
                return d;
            }

            @Override
            public Dimension getMinimumSize() {
                if (this.isMinimumSizeSet()) {
                    return super.getMinimumSize();
                }
                Dimension d = this.getUI().getMinimumSize(this);
                if (d.width < 75) {
                    return new Dimension(75, d.height);
                }
                return d;
            }
        };
        this.bg = this.criterionText.getBackground();
        this.criterionText.setOpaque(true);
        this.criterionText.setToolTipText(Messages.getString("FilterPanel.Text"));
        this.criterionText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (FilterPanel.this.criterionText.getBackground() != UNCLEAN) {
                    FilterPanel.this.criterionText.setBackground(UNCLEAN);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterPanel.this.criterionText.setBackground(UNCLEAN);
                if (FilterPanel.this.criterionText.getBackground() != UNCLEAN) {
                    FilterPanel.this.criterionText.setBackground(UNCLEAN);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (FilterPanel.this.criterionText.getBackground() != UNCLEAN) {
                    FilterPanel.this.criterionText.setBackground(UNCLEAN);
                }
            }
        });
        this.criterionText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterPanel.this.fireSearch();
            }
        });
        this.add((Component)this.criterionText, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.clearButton = new JButton();
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterPanel.this.criterionText.setText("");
                FilterPanel.this.fireSearch();
            }
        });
        this.clearButton.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_clear));
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.clearButton, new GridBagConstraints(++col, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 0), 0, 0));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.criterionText.setEditable(enabled);
        this.clearButton.setEnabled(enabled);
        this.searchOptionsButton.setEnabled(enabled);
        this.projects.setEnabled(enabled && this.filterProject.isSelected());
        this.priority.setEnabled(enabled && this.filterPriority.isSelected());
        this.filterPriority.setEnabled(enabled);
        this.filterProject.setEnabled(enabled);
    }

    @Override
    protected void clearFilters() {
        this.filterProject.setSelected(false);
        this.projects.setSelectedIndex(-1);
        this.filterPriority.setSelected(false);
        this.priority.setPriority(Priority.None);
        this.criterionText.setText("");
        this.criterionText.setBackground(this.bg);
    }

    @Override
    public void setEngine(GTDFreeEngine engine) {
        super.setEngine(engine);
        this.projects.setGTDModel(engine.getGTDModel());
    }

    protected void fireSearch() {
        this.criterionText.setBackground(this.bg);
        if (this.getTable() == null) {
            return;
        }
        FilterList l = new FilterList();
        if (this.filterProject.isSelected() && this.projects.getSelectedIndex() != -1) {
            l.add(new ProjectFilter(this.projects.getSelectedProject() != null ? Integer.valueOf(this.projects.getSelectedProject().getId()) : null));
        }
        if (this.filterPriority.isSelected()) {
            l.add(new PriorityFilter(this.priority.getPriority(), false));
        }
        if (this.criterionText.getText() != null && this.criterionText.getText().length() > 0) {
            l.add(new DescriptionFilter(this.criterionText.getText(), this.caseSensitiveMenuItem.isSelected()));
        }
        if (l.size() > 0) {
            this.fireSearch(l);
        } else {
            this.fireSearch(null);
        }
    }
}

