/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gtdfree.Messages;
import org.gtdfree.gui.FolderSelectionList;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDModel;

public class FolderSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private FolderSelectionList folderList;

    public static void main(String[] args) {
        try {
            FolderSelectionDialog d = new FolderSelectionDialog(false);
            System.out.println(d.showFolderSelectionDialog());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FolderSelectionDialog(boolean projects) {
        this.initialize(projects);
    }

    private void initialize(boolean projects) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.folderList = new FolderSelectionList(projects);
        JScrollPane sp = new JScrollPane();
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(20);
        sp.setViewportView(this.folderList);
        p.add((Component)sp, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(11, 11, 11, 11), 0, 0));
        JButton b = new JButton(this.folderList.getSelectMarkedAction());
        p.add((Component)b, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 11, 2, 2), 0, 0));
        b = new JButton(this.folderList.getDeselectMarkedAction());
        p.add((Component)b, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 2, 2, 11), 0, 0));
        b = new JButton(this.folderList.getSelectAllAction());
        p.add((Component)b, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 11, 11, 2), 0, 0));
        b = new JButton(this.folderList.getDeselectAllAction());
        p.add((Component)b, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 2, 11, 11), 0, 0));
        b = new JButton(Messages.getString("FolderSelectionDialog.Close"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderSelectionDialog.this.dispose();
            }
        });
        p.add((Component)b, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 11, 11, 11), 0, 0));
        this.setContentPane(p);
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.setTitle(projects ? Messages.getString("FolderSelectionDialog.Proj") : Messages.getString("FolderSelectionDialog.List"));
        this.setSize(400, 480);
        this.setDefaultCloseOperation(2);
    }

    public void setGtdModel(GTDModel m) {
        this.folderList.setGtdModel(m);
    }

    public Folder[] showFolderSelectionDialog() {
        this.folderList.refresh();
        this.setVisible(true);
        return this.folderList.getSelectedFolders();
    }
}

