/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.gtdfree.Messages;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.GTDModelAdapter;

public class FolderSelectionList
extends JTable {
    private static final long serialVersionUID = 1L;
    private FolderModel folderModel;
    private GTDModel gtdModel;
    private Action selectMarkedAction;
    private Action deselectMarkedAction;
    private boolean projectsMode = false;
    private AbstractAction selectAllAction;
    private AbstractAction deselectAllAction;
    private JPopupMenu popupMenu;
    protected boolean rebuild = true;

    public FolderSelectionList(boolean projects) {
        this.projectsMode = projects;
        this.initialize();
    }

    public boolean isProjectsMode() {
        return this.projectsMode;
    }

    private void initialize() {
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(3);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setBackground(Color.WHITE);
        this.setShowGrid(false);
        this.folderModel = new FolderModel();
        this.setModel(this.folderModel);
        TableColumn c = new TableColumn();
        c.setModelIndex(0);
        c.setMinWidth(25);
        c.setPreferredWidth(25);
        c.setMaxWidth(25);
        c.setResizable(false);
        c.setHeaderValue(this.folderModel.getColumnName(0));
        this.getColumnModel().addColumn(c);
        c = new TableColumn();
        c.setModelIndex(1);
        c.setHeaderValue(this.folderModel.getColumnName(1));
        this.getColumnModel().addColumn(c);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean b = FolderSelectionList.this.getSelectedRowCount() > 0;
                FolderSelectionList.this.getSelectMarkedAction().setEnabled(b);
                FolderSelectionList.this.getDeselectMarkedAction().setEnabled(b);
            }
        });
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String s = null;
                if (value instanceof Folder) {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("   ");
                    Folder f = (Folder)value;
                    sb.append(f.getName());
                    sb.append(" ( ");
                    sb.append(f.getOpenCount());
                    sb.append('/');
                    sb.append(f.size());
                    if (f.isClosed()) {
                        sb.append(", ");
                        sb.append(Messages.getString("FolderSelectionList.Closed"));
                    }
                    sb.append(" )");
                    s = sb.toString();
                } else if (value != null) {
                    s = value.toString();
                }
                super.getTableCellRendererComponent(table, s, isSelected, hasFocus, row, column);
                if (value instanceof String) {
                    this.setFont(this.getFont().deriveFont(1));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                }
                return this;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || e.getClickCount() == 1 && e.getButton() == 3) {
                    FolderSelectionList.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getSelectMarkedAction());
            this.popupMenu.add(this.getDeselectMarkedAction());
            this.popupMenu.add(this.getSelectAllAction());
            this.popupMenu.add(this.getDeselectAllAction());
        }
        return this.popupMenu;
    }

    public void rebuild() {
        if (this.gtdModel != null) {
            this.folderModel.rebild(this.gtdModel);
        }
    }

    public void setGtdModel(GTDModel gtdModel) {
        this.gtdModel = gtdModel;
        gtdModel.addGTDModelListener(new GTDModelAdapter(){

            @Override
            public void folderAdded(Folder folder) {
                FolderSelectionList.this.rebuild = true;
            }

            @Override
            public void folderModified(FolderEvent folder) {
                FolderSelectionList.this.rebuild = true;
            }

            @Override
            public void folderRemoved(Folder folder) {
                FolderSelectionList.this.rebuild = true;
            }
        });
    }

    public GTDModel getGtdModel() {
        return this.gtdModel;
    }

    public Action getSelectMarkedAction() {
        if (this.selectMarkedAction == null) {
            this.selectMarkedAction = new AbstractAction(Messages.getString("FolderSelectionList.SelMarked")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = FolderSelectionList.this.getSelectedRows();
                    FolderSelectionList.this.folderModel.setValueAt(Boolean.TRUE, rows);
                    FolderSelectionList.this.clearSelection();
                }
            };
            this.selectMarkedAction.setEnabled(false);
        }
        return this.selectMarkedAction;
    }

    public Action getSelectAllAction() {
        if (this.selectAllAction == null) {
            this.selectAllAction = new AbstractAction(Messages.getString("FolderSelectionList.SelAll")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderSelectionList.this.folderModel.setValueAtAll(Boolean.TRUE);
                    FolderSelectionList.this.clearSelection();
                }
            };
        }
        return this.selectAllAction;
    }

    public Action getDeselectMarkedAction() {
        if (this.deselectMarkedAction == null) {
            this.deselectMarkedAction = new AbstractAction(Messages.getString("FolderSelectionList.DesMarked")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = FolderSelectionList.this.getSelectedRows();
                    FolderSelectionList.this.folderModel.setValueAt(Boolean.FALSE, rows);
                    FolderSelectionList.this.clearSelection();
                }
            };
            this.deselectMarkedAction.setEnabled(false);
        }
        return this.deselectMarkedAction;
    }

    public Action getDeselectAllAction() {
        if (this.deselectAllAction == null) {
            this.deselectAllAction = new AbstractAction(Messages.getString("FolderSelectionList.DesAll")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderSelectionList.this.folderModel.setValueAtAll(Boolean.FALSE);
                    FolderSelectionList.this.clearSelection();
                }
            };
        }
        return this.deselectAllAction;
    }

    public Folder[] getSelectedFolders() {
        return this.folderModel.getSelectedFolders();
    }

    public void refresh() {
        if (this.rebuild) {
            this.rebuild = false;
            this.folderModel.rebild(this.gtdModel);
        }
    }

    class FolderModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<Folder> actions = new ArrayList<Folder>();
        private List<Folder> defaults = new ArrayList<Folder>();
        private List<Folder> someday = new ArrayList<Folder>();
        private List<Folder> references = new ArrayList<Folder>();
        private Boolean[] selected = new Boolean[]{Boolean.FALSE};
        private boolean suspend;

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("FolderSelectionList.Selected");
                }
                case 1: {
                    return FolderSelectionList.this.projectsMode ? Messages.getString("FolderSelectionList.Projects") : Messages.getString("FolderSelectionList.Lists");
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value instanceof Boolean && rowIndex > -1 && rowIndex < this.getRowCount() && columnIndex == 0) {
                this.setValueAt((Boolean)value, new int[]{rowIndex});
            }
        }

        public void setValueAt(Boolean value, int[] rows) {
            Arrays.sort(rows);
            int first = rows[0];
            int last = rows[rows.length - 1];
            for (int i = 0; i < rows.length; ++i) {
                List<Folder> l;
                this.selected[rows[i]] = value;
                if (last < rows[i]) {
                    last = rows[i];
                }
                if ((l = this.getListIfHeader(rows[i])) != null) {
                    int upto = rows[i] + l.size() + 1;
                    for (int j = rows[i] + 1; j < upto; ++j) {
                        this.selected[j] = value;
                    }
                    while (i + 1 < rows.length && rows[i + 1] < upto) {
                        ++i;
                    }
                    if (upto <= last) continue;
                    last = upto;
                    continue;
                }
                int k = this.getParentListIndex(rows[i]);
                this.selected[k] = Boolean.FALSE;
                if (k >= first) continue;
                first = k;
            }
            if (!this.suspend) {
                this.fireTableChanged(new TableModelEvent(this, first, last, 0));
            }
        }

        public void setValueAtAll(Boolean value) {
            Arrays.fill((Object[])this.selected, value);
            this.fireTableChanged(new TableModelEvent(this, 0, this.selected.length - 1, 0));
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (FolderSelectionList.this.projectsMode) {
                return this.actions.size() + 1;
            }
            int count = this.defaults.size() + 1;
            if (this.actions.size() > 0) {
                count += this.actions.size() + 1;
            }
            if (this.references.size() > 0) {
                count += this.references.size() + 1;
            }
            if (this.someday.size() > 0) {
                count += this.someday.size() + 1;
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.selected[rowIndex];
            }
            if (FolderSelectionList.this.projectsMode) {
                if (rowIndex == 0) {
                    return Messages.getString("FolderSelectionList.Projects");
                }
                return this.actions.get(rowIndex - 1);
            }
            int c = 0;
            if (this.actions.size() > 0) {
                if (c == rowIndex) {
                    return Messages.getString("FolderSelectionList.Actions");
                }
                if (++c + this.actions.size() > rowIndex) {
                    return this.actions.get(rowIndex - c);
                }
                c += this.actions.size();
            }
            if (c == rowIndex) {
                return Messages.getString("FolderSelectionList.Default");
            }
            if (++c + this.defaults.size() > rowIndex) {
                return this.defaults.get(rowIndex - c);
            }
            c += this.defaults.size();
            if (this.someday.size() > 0) {
                if (c == rowIndex) {
                    return Messages.getString("FolderSelectionList.Someday");
                }
                if (++c + this.someday.size() > rowIndex) {
                    return this.someday.get(rowIndex - c);
                }
                c += this.someday.size();
            }
            if (this.references.size() > 0) {
                if (c == rowIndex) {
                    return Messages.getString("FolderSelectionList.References");
                }
                if (++c + this.references.size() > rowIndex) {
                    return this.references.get(rowIndex - c);
                }
                c += this.references.size();
            }
            return null;
        }

        private List<Folder> getListIfHeader(int row) {
            int c = 0;
            if (this.actions.size() > 0) {
                if (c == row) {
                    return this.actions;
                }
                c += this.actions.size() + 1;
            }
            if (c == row) {
                return this.defaults;
            }
            c += this.defaults.size() + 1;
            if (this.someday.size() > 0) {
                if (c == row) {
                    return this.someday;
                }
                c += this.someday.size() + 1;
            }
            if (this.references.size() > 0) {
                if (c == row) {
                    return this.references;
                }
                c += this.references.size() + 1;
            }
            return null;
        }

        private int getParentListIndex(int row) {
            int c = 0;
            if (this.actions.size() > 0) {
                if (c + this.actions.size() >= row) {
                    return c;
                }
                c += this.actions.size() + 1;
            }
            if (c + this.defaults.size() >= row) {
                return c;
            }
            c += this.defaults.size() + 1;
            if (this.someday.size() > 0) {
                if (c + this.someday.size() >= row) {
                    return c;
                }
                ++c;
            }
            if (this.references.size() > 0) {
                if (c + this.references.size() >= row) {
                    return c;
                }
                c += this.references.size() + 1;
            }
            return 0;
        }

        public void rebild(GTDModel m) {
            this.suspend = true;
            this.actions.clear();
            this.defaults.clear();
            this.references.clear();
            this.someday.clear();
            if (FolderSelectionList.this.projectsMode) {
                for (Folder f : m) {
                    if (!f.isProject()) continue;
                    this.actions.add(f);
                }
            } else {
                for (Folder f : m) {
                    if (f.isAction()) {
                        this.actions.add(f);
                        continue;
                    }
                    if (f.isDefault()) {
                        this.defaults.add(f);
                        continue;
                    }
                    if (f.isReference()) {
                        this.references.add(f);
                        continue;
                    }
                    if (!f.isSomeday()) continue;
                    this.someday.add(f);
                }
            }
            HashSet<Folder> sel = new HashSet<Folder>(this.selected.length);
            for (int i = 0; i < this.selected.length; ++i) {
                Object o;
                if (!this.selected[i].booleanValue() || !((o = this.getValueAt(i, 1)) instanceof Folder)) continue;
                sel.add((Folder)o);
            }
            this.selected = new Boolean[this.getRowCount()];
            Arrays.fill((Object[])this.selected, Boolean.FALSE);
            Comparator<Folder> c = new Comparator<Folder>(){

                @Override
                public int compare(Folder o1, Folder o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(this.actions, c);
            if (!FolderSelectionList.this.projectsMode) {
                Collections.sort(this.defaults, c);
                Collections.sort(this.someday, c);
                Collections.sort(this.references, c);
            }
            int count = this.getRowCount();
            for (int i = 0; i < count; ++i) {
                Object o = this.getValueAt(i, 1);
                if (!(o instanceof Folder) || !sel.contains(o)) continue;
                this.setValueAt(Boolean.TRUE, new int[]{i});
            }
            this.suspend = false;
            this.fireTableDataChanged();
        }

        public Folder[] getSelectedFolders() {
            ArrayList<Folder> l = new ArrayList<Folder>(this.selected.length);
            for (int i = 0; i < this.selected.length; ++i) {
                Object o;
                if (!this.selected[i].booleanValue() || !((o = this.getValueAt(i, 1)) instanceof Folder)) continue;
                l.add((Folder)o);
            }
            return l.toArray(new Folder[l.size()]);
        }
    }
}

