/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.gui.AbstractFilterPanel;
import org.gtdfree.gui.ActionPanel;
import org.gtdfree.gui.ActionTable;
import org.gtdfree.gui.FilterPanel;
import org.gtdfree.gui.FolderPanel;
import org.gtdfree.gui.FoldingPanel;
import org.gtdfree.gui.TickleFilterPanel;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.Folder;

public class OrganizePane
extends JPanel
implements WorkflowPane {
    private static final long serialVersionUID = 1L;
    private FolderPanel folders;
    private ActionTable actions;
    private ActionPanel actionPanel;
    private GTDFreeEngine engine;
    private AbstractFilterPanel filterPanel;
    private JSplitPane split;
    private JSplitPane split1;
    private FoldingPanel actionsPanel;
    private JTextArea description;
    private boolean setting = false;
    private TickleFilterPanel ticlePanel;
    private AbstractAction purgeDeletedAction;
    private JButton purgeDeletedButton;

    public GTDFreeEngine getEngine() {
        return this.engine;
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        this.folders.setEngine(engine);
        this.actionPanel.setEngine(engine);
        this.filterPanel.setEngine(engine);
        this.actions.setEngine(engine);
        this.actions.setShowAll(engine.getGlobalProperties().getBoolean("showAllActions"));
        engine.getGlobalProperties().addPropertyChangeListener("showAllActions", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Folder f = OrganizePane.this.actions.getFolder();
                if (f != null) {
                    OrganizePane.this.actions.setShowAll(OrganizePane.this.getEngine().getStateMachine().getShowAllActions(f.getType()) || OrganizePane.this.getEngine().getGlobalProperties().getBoolean("showAllActions"));
                } else {
                    OrganizePane.this.actions.setShowAll(OrganizePane.this.engine.getGlobalProperties().getBoolean("showAllActions"));
                }
            }
        });
        this.folders.setShowClosedFolders(engine.getGlobalProperties().getBoolean("showClosedFolders"));
        engine.getGlobalProperties().addPropertyChangeListener("showClosedFolders", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OrganizePane.this.folders.setShowClosedFolders(OrganizePane.this.engine.getGlobalProperties().getBoolean("showClosedFolders"));
            }
        });
        this.folders.setShowEmptyFolders(engine.getGlobalProperties().getBoolean("showEmptyFolders", true));
        engine.getGlobalProperties().addPropertyChangeListener("showEmptyFolders", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OrganizePane.this.folders.setShowEmptyFolders(OrganizePane.this.engine.getGlobalProperties().getBoolean("showEmptyFolders", true));
            }
        });
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane();
        JPanel jp = new JPanel();
        jp.setBorder(new TitledBorder(Messages.getString("OrganizePane.Lists")));
        jp.setLayout(new GridBagLayout());
        this.folders = new FolderPanel();
        this.folders.addPropertyChangeListener("selectedFolder", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Folder f = OrganizePane.this.folders.getSelectedFolder();
                if (f != null) {
                    if (f.getType() == Folder.FolderType.INBUCKET) {
                        OrganizePane.this.actions.setCellAction(ActionTable.CellAction.DELETE);
                    } else {
                        OrganizePane.this.actions.setCellAction(ActionTable.CellAction.RESOLVE);
                    }
                    OrganizePane.this.actions.setCellAction(ActionTable.CellAction.RESOLVE);
                    OrganizePane.this.actions.setFolder(f, OrganizePane.this.engine.getStateMachine().getShowAllActions(f.getType()) || OrganizePane.this.engine.getGlobalProperties().getBoolean("showAllActions"));
                    int i = OrganizePane.this.folders.getLastDroppedActionIndex();
                    if (i > -1 && OrganizePane.this.actions.getRowCount() > 0) {
                        if (i >= OrganizePane.this.actions.getRowCount()) {
                            i = OrganizePane.this.actions.getRowCount() - 1;
                        }
                        OrganizePane.this.actions.setRowSelectionInterval(i, i);
                    }
                    if (f.isProject()) {
                        OrganizePane.this.actionsPanel.setTitle(Messages.getString("OrganizePane.Project") + " " + f.getName());
                    } else {
                        OrganizePane.this.actionsPanel.setTitle(Messages.getString("OrganizePane.List") + " " + f.getName());
                    }
                    OrganizePane.this.setting = true;
                    OrganizePane.this.description.setText(f.getDescription());
                    OrganizePane.this.setting = false;
                    OrganizePane.this.actionPanel.setReopenButtonVisible(f.getType() == Folder.FolderType.BUILDIN_DELETED || f.getType() == Folder.FolderType.BUILDIN_RESOLVED);
                } else {
                    OrganizePane.this.actions.setFolder(f, OrganizePane.this.engine.getGlobalProperties().getBoolean("showAllActions"));
                    OrganizePane.this.description.setText("");
                    OrganizePane.this.actionsPanel.setTitle("");
                    OrganizePane.this.actions.setCellAction(ActionTable.CellAction.RESOLVE);
                    OrganizePane.this.actionPanel.setReopenButtonVisible(false);
                }
                OrganizePane.this.description.setEditable(f != null && (f.isUserFolder() || f.isProject()));
                OrganizePane.this.purgeDeletedButton.setVisible(f == OrganizePane.this.getEngine().getGTDModel().getDeletedFolder());
            }
        });
        jp.add((Component)this.folders, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.split.setLeftComponent(jp);
        this.split1 = new JSplitPane();
        this.split1.setResizeWeight(1.0);
        this.split.setRightComponent(this.split1);
        this.split.setDividerLocation(250);
        this.actions = new ActionTable();
        this.actions.setMoveEnabled(true);
        this.actions.setCellAction(ActionTable.CellAction.RESOLVE);
        this.actions.addPropertyChangeListener("selectedActions", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OrganizePane.this.actionPanel.setActions(OrganizePane.this.actions.getSelectedActions());
            }
        });
        jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        this.actionsPanel = new FoldingPanel();
        JPanel dp = new JPanel();
        dp.setLayout(new GridBagLayout());
        dp.add((Component)new JLabel(Messages.getString("OrganizePane.Description.1")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.description = new JTextArea();
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setMargin(new Insets(2, 4, 2, 4));
        this.description.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(OrganizePane.this.description.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(OrganizePane.this.description.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(OrganizePane.this.description.getText());
            }

            private void update(String d) {
                if (OrganizePane.this.setting || OrganizePane.this.actions.getFolder() == null) {
                    return;
                }
                OrganizePane.this.setting = true;
                OrganizePane.this.actions.getFolder().setDescription(d);
                OrganizePane.this.setting = false;
            }
        });
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.description);
        jsp.setPreferredSize(new Dimension(100, this.description.getFont().getSize() * 3 + 7 + 8));
        jsp.setMinimumSize(jsp.getPreferredSize());
        dp.add((Component)jsp, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.actionsPanel.addFold(Messages.getString("OrganizePane.Description"), dp, true, false);
        this.filterPanel = new FilterPanel();
        this.filterPanel.setTable(this.actions);
        this.actionsPanel.addFold(Messages.getString("OrganizePane.Filter"), this.filterPanel, false, false);
        this.ticlePanel = new TickleFilterPanel();
        this.ticlePanel.setTable(this.actions);
        this.actionsPanel.addFold(Messages.getString("OrganizePane.Tickler"), this.ticlePanel, false, false);
        jp.add((Component)this.actionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 2, 0, 2), 0, 0));
        JScrollPane jsppp = new JScrollPane(this.actions);
        jp.add((Component)jsppp, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jpp = new JPanel();
        jpp.setLayout(new GridBagLayout());
        this.purgeDeletedButton = new JButton();
        this.purgeDeletedButton.setAction(this.getPurgeDeletedAction());
        this.purgeDeletedButton.setVisible(false);
        jpp.add((Component)this.purgeDeletedButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        jp.add((Component)jpp, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.split1.setLeftComponent(jp);
        this.actionPanel = new ActionPanel();
        this.actionPanel.putActions(this.actions.getActionMap());
        this.actionPanel.setBorder(new TitledBorder(Messages.getString("OrganizePane.Sel")));
        this.split1.setRightComponent(this.actionPanel);
        this.add(this.split);
    }

    private Action getPurgeDeletedAction() {
        if (this.purgeDeletedAction == null) {
            this.purgeDeletedAction = new AbstractAction(Messages.getString("OrganizePane.Rem")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrganizePane.this.getEngine().getGTDModel().purgeDeletedActions();
                }
            };
            this.purgeDeletedAction.putValue("SwingLargeIconKey", ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_delete));
            this.purgeDeletedAction.putValue("ShortDescription", Messages.getString("OrganizePane.Rem.desc"));
        }
        return this.purgeDeletedAction;
    }

    public static void main(String[] args) {
        try {
            JFrame f = new JFrame();
            OrganizePane p = new OrganizePane();
            f.setContentPane(p);
            f.pack();
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void store(GlobalProperties p) {
        p.putProperty("organize.dividerLocation1", this.split.getDividerLocation());
        p.putProperty("organize.dividerLocation2", this.split1.getDividerLocation());
        p.putProperty("organize.tree.openNodes", this.folders.getExpendedNodes());
        p.putProperty("organize.tree.foldingStates", this.folders.getFoldingStates());
    }

    public void restore(GlobalProperties p) {
        boolean[] bb;
        int[] ii;
        Integer i = p.getInteger("organize.dividerLocation1");
        if (i != null) {
            this.split.setDividerLocation(i);
        }
        if ((i = p.getInteger("organize.dividerLocation2")) != null) {
            this.split1.setDividerLocation(i);
        }
        if ((ii = p.getIntegerArray("organize.tree.openNodes")) != null) {
            this.folders.setExpendedNodes(ii);
        }
        if ((bb = p.getBooleanArray("organize.tree.foldingStates")) != null) {
            this.folders.setFoldingStates(bb);
        }
    }

    public void openTicklerForPast() {
        this.folders.setSelectedFolder(this.getEngine().getGTDModel().getRemindFolder());
        this.actionsPanel.setFoldingState(Messages.getString("OrganizePane.Tickler"), true);
        this.ticlePanel.selectPast();
    }

    public void openTicklerForToday() {
        this.folders.setSelectedFolder(this.getEngine().getGTDModel().getRemindFolder());
        this.actionsPanel.setFoldingState(Messages.getString("OrganizePane.Tickler"), true);
        this.ticlePanel.selectToday();
    }

    @Override
    public ActionsCollection getActionsInView() {
        return new ActionsCollection(this.actions);
    }

    public void printTable() throws PrinterException {
        if (this.actions.getFolder() != null) {
            this.actions.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("GTD-Free Data - " + this.actions.getFolder().getName() + " - " + ApplicationHelper.toISODateTimeString(new Date())), new MessageFormat("Page - {0}"));
        }
    }

    @Override
    public void initialize(GTDFreeEngine engine) {
        this.initialize();
        this.setEngine(engine);
        this.restore(engine.getGlobalProperties());
    }

    @Override
    public boolean isInitialized() {
        return this.engine != null;
    }

    @Override
    public Folder getSelectedFolder() {
        return this.folders.getSelectedFolder();
    }
}

