/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class TimeField
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_TIME_OF_DAY = "timeOfDay";
    private int timeOfDay = -1;
    private JButton hourButton;
    private Border buttonBorder;
    private Border emptyBorder;
    private JButton minuteButton;
    private JWindow hourPicker;
    private JWindow minutePicker;

    public static void main(String[] args) {
        TimeField tf = new TimeField();
        tf.addPropertyChangeListener(PROPERTY_TIME_OF_DAY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println(evt.getNewValue());
            }
        });
        JFrame f = new JFrame();
        f.setContentPane(tf);
        f.pack();
        f.setVisible(true);
    }

    public TimeField() {
        this.initialize();
    }

    private void initialize() {
        this.hourButton = new JButton();
        this.minuteButton = new JButton();
        this.hourButton.setOpaque(false);
        this.minuteButton.setOpaque(false);
        this.hourButton.setMargin(new Insets(1, 1, 1, 1));
        this.minuteButton.setMargin(new Insets(1, 1, 1, 1));
        this.buttonBorder = this.hourButton.getBorder();
        this.emptyBorder = new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return TimeField.this.buttonBorder.getBorderInsets(c);
            }
        };
        this.hourButton.setBorder(this.emptyBorder);
        this.minuteButton.setBorder(this.emptyBorder);
        this.hourButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TimeField.this.hourButton.setBorder(TimeField.this.buttonBorder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimeField.this.hourButton.setBorder(TimeField.this.emptyBorder);
            }
        });
        this.minuteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TimeField.this.minuteButton.setBorder(TimeField.this.buttonBorder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimeField.this.minuteButton.setBorder(TimeField.this.emptyBorder);
            }
        });
        this.hourButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeField.this.minutePicker != null) {
                    TimeField.this.minutePicker.setVisible(false);
                }
                if (TimeField.this.getHourPicker().isVisible()) {
                    TimeField.this.getHourPicker().setVisible(false);
                } else {
                    TimeField.this.getHourPicker().setLocation(((TimeField)TimeField.this).hourButton.getLocationOnScreen().x, ((TimeField)TimeField.this).hourButton.getLocationOnScreen().y + TimeField.this.hourButton.getHeight());
                    TimeField.this.getHourPicker().setVisible(true);
                }
            }
        });
        this.minuteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeField.this.hourPicker != null) {
                    TimeField.this.hourPicker.setVisible(false);
                }
                if (TimeField.this.getMinutePicker().isVisible()) {
                    TimeField.this.getMinutePicker().setVisible(false);
                } else {
                    TimeField.this.getMinutePicker().setLocation(((TimeField)TimeField.this).minuteButton.getLocationOnScreen().x, ((TimeField)TimeField.this).minuteButton.getLocationOnScreen().y + TimeField.this.minuteButton.getHeight());
                    TimeField.this.getMinutePicker().setVisible(true);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.hourButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(":"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.minuteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setTimeOfDay(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TimeField.this.hidePickers();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TimeField.this.hidePickers();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                TimeField.this.hidePickers();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TimeField.this.hidePickers();
            }
        });
    }

    protected JWindow getHourPicker() {
        if (this.hourPicker == null) {
            this.hourPicker = new JWindow();
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeField.this.getHourPicker().setVisible(false);
                    int i = Integer.parseInt(e.getActionCommand());
                    TimeField.this.setHour(i);
                }
            };
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(4, 6, 0, 0));
            Insets ins = new Insets(1, 3, 1, 3);
            for (int i = 0; i < 24; ++i) {
                JButton b = new JButton(String.valueOf(i));
                b.setActionCommand(String.valueOf(i));
                b.addActionListener(al);
                b.setMargin(ins);
                p.add(b);
            }
            this.hourPicker.setContentPane(p);
            this.hourPicker.pack();
        }
        return this.hourPicker;
    }

    protected JWindow getMinutePicker() {
        if (this.minutePicker == null) {
            this.minutePicker = new JWindow();
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeField.this.getMinutePicker().setVisible(false);
                    int i = Integer.parseInt(e.getActionCommand());
                    TimeField.this.setMinute(i);
                }
            };
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(2, 6, 0, 0));
            Insets ins = new Insets(1, 3, 1, 3);
            for (int i = 0; i < 60; i += 5) {
                JButton b = new JButton(String.valueOf(i));
                b.setActionCommand(String.valueOf(i));
                b.addActionListener(al);
                b.setMargin(ins);
                p.add(b);
            }
            this.minutePicker.setContentPane(p);
            this.minutePicker.pack();
        }
        return this.minutePicker;
    }

    protected void setMinute(int i) {
        this.setTimeOfDay((this.getHour() * 60 + i) * 60000);
    }

    public void setTimeOfDay(int i) {
        if (i == this.timeOfDay) {
            return;
        }
        this.hidePickers();
        int old = this.timeOfDay;
        this.timeOfDay = i;
        this.hourButton.setText(String.valueOf(this.getHour()));
        this.minuteButton.setText(String.valueOf(this.getMinute()));
        this.firePropertyChange(PROPERTY_TIME_OF_DAY, old, this.timeOfDay);
    }

    private int getMinute() {
        return (int)((long)this.timeOfDay % 3600000L) / 60000;
    }

    private int getHour() {
        return (int)Math.floor((long)this.timeOfDay / 3600000L) % 24;
    }

    protected void setHour(int i) {
        this.setTimeOfDay((i * 60 + this.getMinute()) * 60000);
    }

    private void hidePickers() {
        if (this.hourPicker != null) {
            this.hourPicker.setVisible(false);
        }
        if (this.minutePicker != null) {
            this.minutePicker.setVisible(false);
        }
    }

    public int getTimeOfDay() {
        return this.timeOfDay;
    }
}

