/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.html;

import java.util.Iterator;
import org.gtdfree.html.TAG;

public final class Structure
implements Iterable<Structure> {
    private Structure next;
    private Structure last;
    private ElementType type;
    private TAG tag;
    private String text;

    public static final Structure withStart(TAG tag) {
        return new Structure(tag, ElementType.TAG_START);
    }

    public static final Structure with(TAG tag) {
        return new Structure(tag, ElementType.TAG);
    }

    public static final Structure with(String text) {
        return new Structure(text);
    }

    public static final Structure withEnd() {
        return new Structure(ElementType.TAG_END);
    }

    public static final Structure with(Structure s) {
        if (s.getType() == ElementType.TAG_END) {
            return Structure.withEnd().add(s.next());
        }
        if (s.getType() == ElementType.TAG_START) {
            return Structure.withStart(s.getTag()).add(s.next());
        }
        if (s.getType() == ElementType.TAG) {
            return Structure.with(s.getTag()).add(s.next());
        }
        if (s.getType() == ElementType.TEXT) {
            return Structure.with(s.getText()).add(s.next());
        }
        return null;
    }

    private Structure(TAG t, ElementType type) {
        this.tag = t;
        this.type = type;
    }

    private Structure(String t) {
        this.text = t;
        this.type = ElementType.TEXT;
    }

    private Structure(ElementType t) {
        this.type = t;
    }

    private Structure addLast(Structure s) {
        if (this.last != null) {
            this.last = this.last.addLast(s);
            return this.last;
        }
        if (this.next != null) {
            this.last = this.next.addLast(s);
            return this.last;
        }
        this.last = this.next = s;
        return this.next;
    }

    public Structure add(Structure s) {
        if (s == null) {
            return this;
        }
        for (Structure st : s) {
            if (st.getType() == ElementType.TAG_END) {
                this.addEnd();
                continue;
            }
            if (st.getType() == ElementType.TAG_START) {
                this.addStart(st.getTag());
                continue;
            }
            if (st.getType() == ElementType.TAG) {
                this.add(st.getTag());
                continue;
            }
            if (st.getType() != ElementType.TEXT) continue;
            this.add(st.getText());
        }
        return this;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Structure next() {
        return this.next;
    }

    public ElementType getType() {
        return this.type;
    }

    public TAG getTag() {
        return this.tag;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        if (this.type == ElementType.TEXT) {
            this.text = t;
        } else if (this.next != null) {
            this.next.setText(t);
        }
    }

    public Structure addStart(TAG tag) {
        this.addLast(new Structure(tag, ElementType.TAG_START));
        return this;
    }

    public Structure add(TAG tag) {
        this.addLast(new Structure(tag, ElementType.TAG));
        return this;
    }

    public Structure add(String text) {
        this.addLast(new Structure(text));
        return this;
    }

    public Structure addEnd() {
        this.addLast(new Structure(ElementType.TAG_END));
        return this;
    }

    @Override
    public Iterator<Structure> iterator() {
        return new Iterator<Structure>(){
            Structure s;
            {
                this.s = Structure.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Structure next() {
                Structure n = this.s;
                this.s = this.s.next;
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.s != null;
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Structure s : this) {
            if (s.getType() == ElementType.TAG) {
                sb.append(s.getTag().toString());
                sb.insert(sb.length() - 1, '/');
                continue;
            }
            if (s.getType() == ElementType.TAG_START) {
                sb.append(s.getTag().toString());
                continue;
            }
            if (s.getType() == ElementType.TAG_END) {
                sb.append('<');
                sb.append('/');
                sb.append('>');
                continue;
            }
            if (s.getType() != ElementType.TEXT) continue;
            sb.append(s.getText());
        }
        return sb.toString();
    }

    public static enum ElementType {
        TAG_START,
        TAG_END,
        TAG,
        TEXT;

    }
}

