/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.journal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.journal.Interval;
import org.gtdfree.journal.JournalEntry;
import org.gtdfree.journal.JournalEntryEvent;
import org.gtdfree.journal.JournalModelListener;
import org.gtdfree.journal.JournalTools;
import org.gtdfree.model.Action;
import org.gtdfree.model.GTDModel;

public class JournalModel {
    private static final String EOL = "\n";
    private static final String SKIP = "  ";
    private static final String SKIPSKIP = "    ";
    private final String TAG_GTD_JOURNAL_DATA = "gtd-journal-data";
    private final String ATTR_VERSION = "version";
    private final String ATTR_MODIFIED = "modified";
    private final String TAG_ENTRY = "entry";
    private final String ATTR_ENTRY_COMMENT = "comment";
    private final String ATTR_ENTRY_CHECKED = "checked";
    private final String TAG_INTERVAL = "interval";
    private final String ATTR_INTERVAL_START = "start";
    private final String ATTR_INTERVAL_END = "end";
    private final String TAG_ACTION = "action";
    private final String ATTR_ACTION_ID = "id";
    private final String VERSION_1_0 = "1.0";
    private static final DateFormat JOURNAL_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private File dataFolder;
    private GTDModel gtdModel;
    private Map<Long, List<JournalEntry>> data;
    private EventListenerList listeners = new EventListenerList();
    private EventHandler eventHandler = new EventHandler();
    private Set<Long> dirtyDays = new HashSet<Long>();

    public JournalModel(File dataFolder, GTDModel gtdModel) {
        this.data = new HashMap<Long, List<JournalEntry>>();
        this.dataFolder = dataFolder;
        this.gtdModel = gtdModel;
    }

    public JournalEntry[] getEntries(long day) {
        List<JournalEntry> l = this.data.get(day);
        if (l == null) {
            try {
                l = this.load(day);
            }
            catch (Exception e) {
                e.printStackTrace();
                l = new LinkedList<JournalEntry>();
            }
            this.data.put(day, l);
        }
        return l.toArray(new JournalEntry[l.size()]);
    }

    public JournalEntry addEntry(long day) {
        JournalEntry e = new JournalEntry();
        e.setDay(day);
        List<JournalEntry> l = this.data.get(day);
        if (l == null) {
            l = new ArrayList<JournalEntry>();
            this.data.put(day, l);
        }
        l.add(e);
        e.addJournalEntryListener(this.eventHandler);
        this.eventHandler.journalEntryAdded(e);
        return e;
    }

    public void addJournalModelListener(JournalModelListener l) {
        this.listeners.add(JournalModelListener.class, l);
    }

    public void removeJournalModelListener(JournalModelListener l) {
        this.listeners.remove(JournalModelListener.class, l);
    }

    private File getJournalFile(long day) {
        Date date = JournalTools.toDate(day);
        return new File(this.dataFolder, "journal-" + JOURNAL_DATE_FORMAT.format(date) + ".xml");
    }

    public List<JournalEntry> load(Long day) throws IOException, XMLStreamException, FactoryConfigurationError {
        int eventType;
        XMLStreamReader r;
        LinkedList<JournalEntry> result = new LinkedList<JournalEntry>();
        File file = this.getJournalFile(day);
        if (!file.exists() || !file.canRead()) {
            return result;
        }
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bin = new BufferedInputStream(fis, 8192);
        bin.mark(8191);
        InputStreamReader rr = new InputStreamReader(bin);
        CharBuffer b = CharBuffer.allocate(96);
        ((Reader)rr).read(b);
        b.position(0);
        Pattern pattern = Pattern.compile("<\\?.*?encoding\\s*?=.*?\\?>", 2);
        Matcher matcher = pattern.matcher(b);
        bin.reset();
        if (matcher.find()) {
            r = XMLInputFactory.newInstance().createXMLStreamReader(bin);
            System.out.println("XML declared encoding: " + r.getEncoding() + ", system default encoding: " + Charset.defaultCharset());
        } else {
            r = XMLInputFactory.newInstance().createXMLStreamReader(new InputStreamReader(bin));
            System.out.println("XML assumed system default encoding: " + Charset.defaultCharset());
        }
        boolean INIT = false;
        boolean EXPECT_ENTRY = true;
        int EXPECT_INTERVAL_OR_ACTION = 2;
        int EXPECT_END_INTERVAL = 3;
        int EXPECT_END_ACTION = 4;
        int DONE = 5;
        int status = 0;
        JournalEntry je = null;
        block4: while ((eventType = r.nextTag()) != 8) {
            switch (eventType) {
                case 1: {
                    if (status == 0 && "gtd-journal-data".equals(r.getName().getLocalPart())) {
                        status = 1;
                        String version = r.getAttributeValue(null, "version");
                        if ("1.0".equals(version)) continue block4;
                        throw new IOException("Unrecognized journal file version: " + version);
                    }
                    if (status == 1 && "entry".equals(r.getName().getLocalPart())) {
                        je = new JournalEntry();
                        je.setDay(day);
                        je.setChecked(Boolean.parseBoolean(r.getAttributeValue(null, "checked")));
                        je.setComment(r.getAttributeValue(null, "comment"));
                        status = 2;
                        continue block4;
                    }
                    if (status == 2 && je != null) {
                        if ("interval".equals(r.getName().getLocalPart())) {
                            Interval intr = new Interval(je, JournalModel.timeFromString(r.getAttributeValue(null, "start")), JournalModel.timeFromString(r.getAttributeValue(null, "end")));
                            je.addInterval(intr);
                            status = 3;
                            continue block4;
                        }
                        if ("action".equals(r.getName().getLocalPart())) {
                            List<Action> actions = je.getActions();
                            actions.add(this.gtdModel.getAction(Integer.parseInt(r.getAttributeValue(null, "id"))));
                            je.setActions(actions);
                            status = 4;
                            continue block4;
                        }
                    }
                    throw new IllegalStateException();
                }
                case 2: {
                    if (status == 3 && "interval".equals(r.getName().getLocalPart())) {
                        status = 2;
                        continue block4;
                    }
                    if (status == 4 && "action".equals(r.getName().getLocalPart())) {
                        status = 2;
                        continue block4;
                    }
                    if (status == 2 && "entry".equals(r.getName().getLocalPart())) {
                        if (je == null) {
                            throw new IllegalStateException();
                        }
                        result.add(je);
                        je.addJournalEntryListener(this.eventHandler);
                        this.eventHandler.journalEntryAdded(je);
                        status = 1;
                        je = null;
                        continue block4;
                    }
                    if (status == 1 && "gtd-journal-data".equals(r.getName().getLocalPart())) {
                        status = 5;
                        r.close();
                        fis.close();
                        return result;
                    }
                    throw new IllegalStateException();
                }
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
        HashSet<Long> clearedDays = new HashSet<Long>();
        try {
            for (Long dirtyDay : this.dirtyDays) {
                this.store(this.getJournalFile(dirtyDay), this.data.get(dirtyDay));
                clearedDays.add(dirtyDay);
            }
        }
        catch (Throwable throwable) {
            for (Long clearedDay : clearedDays) {
                this.dirtyDays.remove(clearedDay);
            }
            throw throwable;
        }
        for (Long clearedDay : clearedDays) {
            this.dirtyDays.remove(clearedDay);
        }
    }

    protected void store(File file, List<JournalEntry> list) throws XMLStreamException, FactoryConfigurationError, FileNotFoundException {
        if (list == null) {
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        FileOutputStream fos = new FileOutputStream(file);
        XMLStreamWriter w = XMLOutputFactory.newInstance().createXMLStreamWriter(fos, "UTF-8");
        w.writeStartDocument("UTF-8", "1.0");
        w.writeCharacters(EOL);
        w.writeCharacters(EOL);
        w.writeStartElement("gtd-journal-data");
        w.writeAttribute("version", "1.0");
        w.writeAttribute("modified", ApplicationHelper.formatLongISO(new Date()));
        w.writeCharacters(EOL);
        for (JournalEntry je : list) {
            w.writeCharacters(SKIP);
            w.writeStartElement("entry");
            if (je.getComment() != null) {
                w.writeAttribute("comment", je.getComment());
            }
            w.writeAttribute("checked", Boolean.toString(je.isChecked()));
            w.writeCharacters(EOL);
            for (Interval i : je.getIntervals()) {
                w.writeCharacters(SKIPSKIP);
                w.writeEmptyElement("interval");
                w.writeAttribute("start", JournalModel.timeToString(i.getStart()));
                w.writeAttribute("end", JournalModel.timeToString(i.getEnd()));
                w.writeCharacters(EOL);
            }
            if (je.getActions() != null) {
                for (Action a : je.getActions()) {
                    w.writeCharacters(SKIPSKIP);
                    w.writeEmptyElement("action");
                    w.writeAttribute("id", Integer.toString(a.getId()));
                    w.writeCharacters(EOL);
                }
            }
            w.writeCharacters(SKIP);
            w.writeEndElement();
            w.writeCharacters(EOL);
        }
        w.writeEndElement();
        w.writeEndDocument();
        w.flush();
        w.close();
    }

    public static String timeToString(int time) {
        int sec = time % 60;
        time -= sec;
        int min = (time /= 60) % 60;
        time -= min;
        int hour = time /= 60;
        return String.format("%02d:%02d:%02d", hour, min, sec);
    }

    public static int timeFromString(String str) {
        String[] hourMinSec = str.split(":");
        if (hourMinSec.length == 0 || hourMinSec.length > 3) {
            return -1;
        }
        try {
            int hour = 0;
            int min = 0;
            int sec = 0;
            if (hourMinSec.length == 3) {
                sec = Integer.parseInt(hourMinSec[2].trim());
            }
            if (hourMinSec.length >= 2) {
                min = Integer.parseInt(hourMinSec[1].trim());
            }
            if (hourMinSec.length >= 1) {
                hour = Integer.parseInt(hourMinSec[0].trim());
            }
            if (hour < 0 || min < 0 || min > 60 || sec < 0 || sec > 60) {
                return -1;
            }
            return (hour * 60 + min) * 60 + sec;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    class EventHandler
    implements JournalModelListener {
        EventHandler() {
        }

        private void markDirtyDay(JournalEntry je) {
            if (je != null) {
                JournalModel.this.dirtyDays.add(je.getDay());
            }
        }

        @Override
        public void journalEntryIntervalRemoved(JournalEntryEvent e) {
            JournalModelListener[] l = (JournalModelListener[])JournalModel.this.listeners.getListeners(JournalModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                l[i].journalEntryIntervalRemoved(e);
            }
            this.markDirtyDay(e.getJournalEntry());
        }

        @Override
        public void journalEntryIntervalAdded(JournalEntryEvent e) {
            JournalModelListener[] l = (JournalModelListener[])JournalModel.this.listeners.getListeners(JournalModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                l[i].journalEntryIntervalAdded(e);
            }
            this.markDirtyDay(e.getJournalEntry());
        }

        @Override
        public void journalEntryChanged(JournalEntryEvent e) {
            JournalModelListener[] l = (JournalModelListener[])JournalModel.this.listeners.getListeners(JournalModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                l[i].journalEntryChanged(e);
            }
            if (e.getProperty().equals("day") && e.getOldValue() != null) {
                JournalModel.this.dirtyDays.add((Long)e.getOldValue());
            }
            this.markDirtyDay(e.getJournalEntry());
        }

        @Override
        public void journalEntryAdded(JournalEntryEvent e) {
            JournalModelListener[] l = (JournalModelListener[])JournalModel.this.listeners.getListeners(JournalModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                l[i].journalEntryAdded(e);
            }
            this.markDirtyDay(e.getJournalEntry());
        }

        public void journalEntryAdded(JournalEntry je) {
            JournalEntryEvent e = new JournalEntryEvent(je, "entries", je, null, -1);
            this.journalEntryAdded(e);
        }
    }
}

