/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.Priority;

public final class Action {
    public static final String RESOLUTION_PROPERTY_NAME = "resolution";
    public static final String PROJECT_PROPERTY_NAME = "project";
    public static final String QUEUED_PROPERTY_NAME = "queued";
    public static final String REMIND_PROPERTY_NAME = "remind";
    public static final String PRIORITY_PROPERTY_NAME = "priority";
    private int id;
    private Date created;
    private Date resolved;
    private Date modified;
    private String description;
    private Date start;
    private Date remind;
    private Date due;
    private Integer project;
    private boolean queued = false;
    private transient Resolution resolution = Resolution.OPEN;
    private Integer resolutionId = Resolution.OPEN.ordinal();
    private transient ActionType type;
    private Integer typeId;
    private transient Priority priority = Priority.None;
    private Integer priorityId = Priority.None.ordinal();
    private transient URL url;
    private String urlId;
    private transient GTDData.ActionProxy proxy;

    public static final boolean hasOpen(Action[] actions) {
        if (actions != null) {
            for (Action action : actions) {
                if (!action.isOpen()) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean hasNonOpen(Action[] actions) {
        if (actions != null) {
            for (Action action : actions) {
                if (action.isOpen()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDeleted(Action[] actions) {
        if (actions != null) {
            for (Action action : actions) {
                if (!action.isDeleted()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNonDeleted(Action[] actions) {
        if (actions != null) {
            for (Action action : actions) {
                if (action.isDeleted()) continue;
                return true;
            }
        }
        return false;
    }

    public Action(int id, Date created, Date resolved, String description, Date modified) {
        this.id = id;
        this.created = created;
        this.modified = modified;
        this.resolved = resolved;
        this.description = description;
    }

    public Action(int id, Date created, Date resolved, String description) {
        this(id, created, resolved, description, new Date());
    }

    public boolean isOpen() {
        return this.getResolution() == Resolution.OPEN;
    }

    public int getId() {
        return this.id;
    }

    public Date getCreated() {
        return this.created;
    }

    public Folder getParent() {
        if (this.proxy != null) {
            return this.proxy.getParent();
        }
        return null;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setDescription(String description) {
        if (description != null && description.equals(this.description)) {
            return;
        }
        if (this.description != null && this.description.equals(description)) {
            return;
        }
        String old = this.description;
        this.description = description;
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, "description", old, description);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setResolution(Resolution resolution) {
        if (this.getResolution() == resolution) {
            return;
        }
        Resolution old = this.resolution;
        this.resolution = resolution;
        this.resolutionId = resolution.ordinal();
        if (this.resolved == null && !this.isOpen()) {
            this.resolved = new Date();
        } else if (this.isOpen()) {
            this.resolved = null;
        }
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, RESOLUTION_PROPERTY_NAME, (Object)old, (Object)resolution);
        }
        this.setQueued(false);
    }

    public Resolution getResolution() {
        if (this.resolution == null && this.resolutionId != null) {
            this.resolution = Resolution.values()[this.resolutionId];
        }
        return this.resolution;
    }

    public Date getResolved() {
        return this.resolved;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        Date old = this.start;
        this.start = start;
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, "start", old, start);
        }
    }

    public ActionType getType() {
        if (this.type == null && this.typeId != null) {
            this.type = ActionType.values()[this.typeId];
        }
        return this.type;
    }

    public void setType(ActionType type) {
        if (this.getType() == type) {
            return;
        }
        ActionType old = this.type;
        this.type = type;
        this.typeId = type.ordinal();
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, "type", (Object)old, (Object)type);
        }
    }

    public URL getUrl() {
        if (this.url == null && this.urlId != null) {
            try {
                this.url = new URL(this.urlId);
            }
            catch (MalformedURLException e) {
                this.urlId = null;
                e.printStackTrace();
            }
        }
        return this.url;
    }

    public void setUrl(URL url) {
        if (this.url == null && url == null || this.url != null && url != null && this.url.toString().equals(url.toString())) {
            return;
        }
        URL old = this.url;
        this.url = url;
        this.urlId = url != null ? url.toString() : null;
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, "url", old, url);
        }
    }

    private void modified() {
        this.modified = new Date();
    }

    public Priority getPriority() {
        if (this.priority == null && this.priorityId != null) {
            this.priority = Priority.values()[this.priorityId];
        }
        return this.priority;
    }

    public void setPriority(Priority priority) {
        if (priority == null) {
            priority = Priority.None;
        }
        if (this.priority == priority) {
            return;
        }
        Priority old = this.priority;
        this.priority = priority;
        this.priorityId = priority.ordinal();
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, PRIORITY_PROPERTY_NAME, (Object)old, (Object)priority);
        }
    }

    public Date getRemind() {
        return this.remind;
    }

    public void setRemind(Date remind) {
        Date old = this.remind;
        this.remind = remind;
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, REMIND_PROPERTY_NAME, old, remind);
        }
    }

    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        Date old = this.due;
        this.due = due;
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, "due", old, due);
        }
    }

    void setParent(Folder folder) {
        if (this.proxy != null) {
            this.proxy.setParent(folder);
        } else if (folder != null) {
            this.proxy = folder.getParent().getDataRepository().getProxy(this);
            this.proxy.setParent(folder);
        }
    }

    public void moveUp() {
        this.getParent().moveUp(this);
    }

    public void moveDown() {
        this.getParent().moveDown(this);
    }

    public boolean canMoveUp() {
        return this.getParent().canMoveUp(this);
    }

    public boolean canMoveDown() {
        return this.getParent().canMoveDown(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Action={id=");
        sb.append(this.id);
        sb.append(",resolution=");
        sb.append((Object)this.getResolution());
        sb.append("}");
        return sb.toString();
    }

    public Integer getProject() {
        return this.project;
    }

    public void setProject(Integer project) {
        if (project != null && project.equals(this.project)) {
            return;
        }
        if (this.project != null && this.project.equals(project)) {
            return;
        }
        if (this.project == null && project == null) {
            return;
        }
        Integer old = this.project;
        this.project = project;
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, PROJECT_PROPERTY_NAME, old, project);
        }
    }

    public void copy(Action a) {
        this.setDescription(a.getDescription());
        this.setDue(a.getDue());
        this.setPriority(a.getPriority());
        this.setRemind(a.getRemind());
        this.setResolution(a.getResolution());
        this.setStart(a.getStart());
        this.setType(a.getType());
        this.setUrl(a.getUrl());
        this.setQueued(a.isQueued());
    }

    public boolean isQueued() {
        return this.queued;
    }

    public void setQueued(boolean queued) {
        if (queued == this.queued) {
            return;
        }
        this.queued = queued;
        this.modified();
        if (this.getParent() != null) {
            this.getParent().fireElementModified(this, this.proxy, QUEUED_PROPERTY_NAME, !queued, queued);
        }
    }

    public boolean isResolved() {
        return this.getResolution() == Resolution.RESOLVED;
    }

    public boolean isDeleted() {
        return this.getResolution() == Resolution.DELETED;
    }

    GTDData.ActionProxy getProxy() {
        return this.proxy;
    }

    void setProxy(GTDData.ActionProxy proxy) {
        this.proxy = proxy;
    }

    public static enum Resolution {
        OPEN,
        DELETED,
        RESOLVED,
        STALLED;


        public static Resolution toResolution(String s) {
            if ("TRASHED".equalsIgnoreCase(s)) {
                return DELETED;
            }
            if ("RESOVED".equalsIgnoreCase(s)) {
                return RESOLVED;
            }
            return Resolution.valueOf(s);
        }
    }

    public static enum ActionType {
        Mail,
        Phone,
        Meet,
        Read,
        Watch;

    }
}

