/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionEvent;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.FolderListener;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.Visitor;

public class Folder
implements Iterable<Action> {
    private String name;
    private int id;
    private Comparator<Action> comparator;
    private int openCount = 0;
    private boolean closed = false;
    private GTDData.FolderDataProxy data;
    private Integer typeId;
    private transient EventListenerList listeners;
    private transient FolderType type;
    private transient GTDModel parent;
    private transient boolean suspendedForMultipleChanges;

    GTDData.FolderDataProxy getData() {
        return this.data;
    }

    public Comparator<Action> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<Action> comparator) {
        this.comparator = comparator;
        this.data.store();
    }

    public FolderType getType() {
        if (this.type == null && this.typeId != null) {
            this.type = FolderType.values()[this.typeId];
        }
        return this.type;
    }

    void setType(FolderType type) {
        this.type = type;
        this.typeId = type.ordinal();
        this.data.store();
    }

    public void addFolderListener(FolderListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(FolderListener.class, l);
    }

    public void removeFolderListener(FolderListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.remove(FolderListener.class, l);
    }

    private void fireElementAdded(Action a, GTDData.ActionProxy ap) {
        this.fireElementAdded(new Action[]{a}, new GTDData.ActionProxy[]{ap}, !this.isUserFolder() && !this.isInBucket());
    }

    private void fireElementAdded(Action[] a, GTDData.ActionProxy[] ap) {
        this.fireElementAdded(a, ap, !this.isUserFolder() && !this.isInBucket());
    }

    private void fireElementAdded(Action[] a, GTDData.ActionProxy[] ap, boolean recycled) {
        FolderListener[] l;
        if (a == null || a.length == 0 || ap == null || ap.length == 0) {
            return;
        }
        FolderEvent f = new FolderEvent(this, a, ap, recycled);
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        for (FolderListener listener : l = (FolderListener[])this.listeners.getListeners(FolderListener.class)) {
            try {
                listener.elementAdded(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fireElementRemoved(Action a, GTDData.ActionProxy i) {
        this.fireElementRemoved(new Action[]{a}, new GTDData.ActionProxy[]{i}, !this.isUserFolder() && !this.isInBucket());
    }

    private void fireElementRemoved(Action[] a, GTDData.ActionProxy[] i) {
        this.fireElementRemoved(a, i, !this.isUserFolder() && !this.isInBucket());
    }

    private void fireElementRemoved(Action[] a, GTDData.ActionProxy[] ap, boolean recycled) {
        FolderListener[] l;
        if (a == null || a.length == 0 || ap == null || ap.length == 0) {
            return;
        }
        FolderEvent f = new FolderEvent(this, a, ap, recycled);
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        for (FolderListener listener : l = (FolderListener[])this.listeners.getListeners(FolderListener.class)) {
            try {
                listener.elementRemoved(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void fireElementModified(Action a, GTDData.ActionProxy ap, String property, Object oldVal, Object newVal) {
        this.fireElementModified(a, ap, property, oldVal, newVal, false);
        ap.store();
    }

    public void fireElementModified(Action a, GTDData.ActionProxy ap, String property, Object oldVal, Object newVal, boolean recycled) {
        if (a == null || ap == null) {
            return;
        }
        if (oldVal == null && newVal == null || oldVal != null && oldVal.equals(newVal)) {
            return;
        }
        this.fireElementModified(new ActionEvent(this, a, ap, property, oldVal, newVal, recycled));
    }

    public void fireElementModified(Action[] a, GTDData.ActionProxy[] ap, String property, Object oldVal, Object newVal, boolean recycled) {
        if (a == null || a.length == 0 || ap == null || ap.length == 0) {
            return;
        }
        if (oldVal == null && newVal == null || oldVal != null && oldVal.equals(newVal)) {
            return;
        }
        this.fireElementModified(new ActionEvent(this, a, ap, property, oldVal, newVal, recycled));
    }

    private void fireElementModified(ActionEvent i) {
        FolderListener[] l;
        if (!this.data.contains(i.getActionProxy())) {
            return;
        }
        if (i.getProperty().equals("resolution")) {
            if (Action.Resolution.OPEN == i.getOldValue()) {
                this.decOpentCount();
            } else if (Action.Resolution.OPEN == i.getNewValue()) {
                this.incOpentCount();
            }
        }
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        for (FolderListener listener : l = (FolderListener[])this.listeners.getListeners(FolderListener.class)) {
            try {
                listener.elementModified(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fireOrderChanged() {
        FolderListener[] l;
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        for (FolderListener listener : l = (FolderListener[])this.listeners.getListeners(FolderListener.class)) {
            try {
                listener.orderChanged(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sort() {
        if (this.getComparator() != null && !this.suspendedForMultipleChanges) {
            this.data.sort(this.getComparator());
        }
    }

    synchronized void add(int i, Action a) {
        GTDData.ActionProxy ap = this.parent.getDataRepository().getProxy(a);
        this.add(i, a, ap);
    }

    synchronized void add(int i, Action a, GTDData.ActionProxy ap) {
        if (this.data.contains(ap)) {
            return;
        }
        this.data.suspend(true);
        this.data.add(i, ap);
        if (!this.isMeta()) {
            ap.setParent(this);
        }
        this.sort();
        if (a.isOpen() && this.isClosed()) {
            this.setClosed(false);
        }
        if (a.isOpen()) {
            this.incOpentCount();
        }
        this.data.suspend(false);
        this.fireElementAdded(a, ap);
    }

    synchronized void add(int idx, Action[] ac) {
        if (ac == null || ac.length == 0) {
            return;
        }
        GTDData.ActionProxy[] ap = new GTDData.ActionProxy[ac.length];
        for (int i = 0; i < ap.length; ++i) {
            ap[i] = ac[i].getProxy();
        }
        this.add(idx, ac, ap);
    }

    synchronized void add(int idx, Action[] ac, GTDData.ActionProxy[] ap) {
        if (ac == null || ac.length == 0 || ap == null || ap.length == 0) {
            return;
        }
        ArrayList<Action> aac = new ArrayList<Action>(ac.length);
        ArrayList<GTDData.ActionProxy> aap = new ArrayList<GTDData.ActionProxy>(ac.length);
        this.data.suspend(true);
        int ins = 0;
        for (int i = 0; i < ac.length; ++i) {
            Action a = ac[i];
            GTDData.ActionProxy p = ap[i];
            if (this.data.contains(p)) continue;
            this.data.add(idx + ins, p);
            ++ins;
            if (!this.isMeta()) {
                a.setParent(this);
            }
            if (a.isOpen() && this.isClosed()) {
                this.setClosed(false);
            }
            aac.add(a);
            aap.add(p);
            if (!a.isOpen()) continue;
            this.incOpentCount();
        }
        if (aac.size() == 0) {
            return;
        }
        this.sort();
        this.data.suspend(false);
        this.fireElementAdded(aac.toArray(new Action[aac.size()]), aap.toArray(new GTDData.ActionProxy[aap.size()]));
    }

    synchronized void add(Action a) {
        GTDData.ActionProxy ap = this.parent.getDataRepository().getProxy(a);
        this.add(a, ap);
    }

    synchronized void add(Action a, GTDData.ActionProxy ap) {
        if (this.data.contains(ap)) {
            return;
        }
        this.data.suspend(true);
        this.data.add(ap);
        if (!this.isMeta()) {
            a.setParent(this);
        }
        this.sort();
        if (a.isOpen() && this.isClosed()) {
            this.setClosed(false);
        }
        if (a.isOpen()) {
            this.incOpentCount();
        }
        this.data.suspend(false);
        this.fireElementAdded(a, ap);
    }

    synchronized boolean remove(Action a, GTDData.ActionProxy i) {
        this.data.suspend(true);
        boolean b = this.data.remove(i);
        if (b) {
            if (a.isOpen()) {
                this.decOpentCount();
            }
            this.fireElementRemoved(a, i);
        }
        this.data.suspend(false);
        return b;
    }

    synchronized boolean remove(int i) {
        GTDData.ActionProxy ap = this.data.get(i);
        Action a = ap.get();
        this.data.suspend(true);
        this.data.remove(i);
        if (a != null && a.isOpen()) {
            this.decOpentCount();
        }
        this.data.suspend(false);
        this.fireElementRemoved(a, ap);
        return true;
    }

    public Folder(GTDModel parent, int id, String name, FolderType type, GTDData.FolderDataProxy data) {
        this.id = id;
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.data = data;
        this.typeId = type.ordinal();
    }

    public void rename(String newName) {
        this.data.suspend(true);
        this.parent.renameFolder(this, newName);
        this.data.store();
        this.data.suspend(false);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<Action> iterator() {
        return new Iterator<Action>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Folder.this.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Action next() {
                Folder folder = Folder.this;
                synchronized (folder) {
                    if (this.i < Folder.this.size()) {
                        return Folder.this.data.get(this.i++).get();
                    }
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Action> iterator(final FolderPreset fp) {
        return new Iterator<Action>(){
            Iterator<GTDData.ActionProxy> i;
            {
                this.i = Folder.this.data.iterator(fp);
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Action next() {
                Folder folder = Folder.this;
                synchronized (folder) {
                    if (this.i.hasNext()) {
                        return this.i.next().get();
                    }
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<GTDData.ActionProxy> proxyIterator(FolderPreset fp) {
        return this.data.iterator(fp);
    }

    public Action getActionByID(int id) {
        Iterator<GTDData.ActionProxy> i = this.data.iterator(FolderPreset.ALL);
        while (i.hasNext()) {
            GTDData.ActionProxy a = i.next();
            if (a.getId() != id) continue;
            return a.get();
        }
        return null;
    }

    public GTDModel getParent() {
        return this.parent;
    }

    void setParent(GTDModel p) {
        this.parent = p;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isMeta() {
        return this.isBuildIn() || this.type == FolderType.PROJECT || this.type == FolderType.QUEUE;
    }

    public synchronized void moveUp(Action a) {
        int open = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            if (a.getId() == this.data.get(i).getId()) {
                if (open == i) {
                    return;
                }
                this.data.suspend(true);
                this.data.set(i, this.data.get(open));
                this.data.set(open, this.parent.getDataRepository().getProxy(a));
                this.data.suspend(false);
                this.fireOrderChanged();
                return;
            }
            if (!this.data.get(i).get().isOpen()) continue;
            open = i;
        }
    }

    public boolean canMoveUp(Action a) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (a.getId() == this.data.get(i).getId()) {
                return false;
            }
            if (!this.data.get(i).get().isOpen()) continue;
            return true;
        }
        return false;
    }

    public synchronized void moveDown(Action a) {
        int open = this.data.size() - 1;
        for (int i = this.data.size() - 1; i > -1; --i) {
            if (a.getId() == this.data.get(i).getId()) {
                if (open == i) {
                    return;
                }
                this.data.suspend(true);
                this.data.set(i, this.data.get(open));
                this.data.set(open, this.parent.getDataRepository().getProxy(a));
                this.data.suspend(false);
                this.fireOrderChanged();
                return;
            }
            if (!this.data.get(i).get().isOpen()) continue;
            open = i;
        }
    }

    public boolean canMoveDown(Action a) {
        if (a == null) {
            return false;
        }
        for (int i = this.data.size() - 1; i > -1; --i) {
            if (a.getId() == this.data.get(i).getId()) {
                return false;
            }
            if (!this.data.get(i).get().isOpen()) continue;
            return true;
        }
        return false;
    }

    public Action get(int i) {
        return this.data.get(i).get();
    }

    public GTDData.ActionProxy getProxy(int i) {
        return this.data.get(i);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Folder{ id= ");
        sb.append(this.id);
        sb.append(", name= ");
        sb.append(this.name);
        sb.append(", type= ");
        sb.append((Object)this.type);
        sb.append(", actions= ");
        sb.append(this.data.size());
        sb.append("}");
        return sb.toString();
    }

    void setName(String newName) {
        this.name = newName;
        this.data.store();
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public synchronized void visit(Visitor v) {
        v.meet(this);
        Iterator<GTDData.ActionProxy> i = this.data.iterator(FolderPreset.ALL);
        while (i.hasNext()) {
            v.meet(i.next().get());
        }
        v.depart(this);
    }

    public synchronized int indexOf(Action selectedAction) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data.get(i).getId() != selectedAction.getId()) continue;
            return i;
        }
        return -1;
    }

    public int getId() {
        return this.id;
    }

    public boolean isBuildIn() {
        return this.getType() == FolderType.BUILDIN || this.getType() == FolderType.BUILDIN_REMIND || this.getType() == FolderType.BUILDIN_RESOLVED || this.getType() == FolderType.BUILDIN_DELETED || this.getType() == FolderType.BUILDIN_PRIORITY;
    }

    public boolean contains(GTDData.ActionProxy a) {
        return this.data.contains(a);
    }

    public boolean isUserFolder() {
        return this.getType() == FolderType.ACTION || this.getType() == FolderType.REFERENCE || this.getType() == FolderType.SOMEDAY;
    }

    public boolean isProject() {
        return this.getType() == FolderType.PROJECT;
    }

    public boolean isInBucket() {
        return this.getType() == FolderType.INBUCKET;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        if (this.closed == closed) {
            return;
        }
        this.closed = closed;
        this.data.setResolved(new Date());
        this.parent.fireFolderModified(this, "closed", !closed, closed, false);
    }

    public boolean isSuspentedForMultipleChanges() {
        return this.suspendedForMultipleChanges;
    }

    public void setSuspentedForMultipleChanges(boolean suspentedForMultipleChanges) {
        this.suspendedForMultipleChanges = suspentedForMultipleChanges;
        if (!suspentedForMultipleChanges) {
            this.sort();
        }
    }

    public boolean isQueue() {
        return this.type == FolderType.QUEUE;
    }

    public boolean isReference() {
        return this.getType() == FolderType.REFERENCE;
    }

    public boolean isAction() {
        return this.getType() == FolderType.ACTION;
    }

    public boolean isSomeday() {
        return this.getType() == FolderType.SOMEDAY;
    }

    public boolean isDefault() {
        return this.getType() == FolderType.QUEUE || this.getType() == FolderType.INBUCKET || this.isBuildIn();
    }

    public String getDescription() {
        return this.data.getDescription();
    }

    public void setDescription(String d) {
        if (this.data.getDescription() != null && this.data.getDescription().equals(d) || (this.data.getDescription() == null || this.data.getDescription().length() == 0) && (d == null || d.length() == 0)) {
            return;
        }
        String old = this.data.getDescription();
        this.data.setDescription(d);
        if (this.parent != null) {
            this.parent.fireFolderModified(this, "description", old, d, false);
        }
    }

    public boolean isTickler() {
        return this.type == FolderType.BUILDIN_REMIND;
    }

    void purgeAll() {
        int i;
        GTDData.ActionProxy[] ap = this.data.toArray();
        Action[] ac = new Action[ap.length];
        this.data.suspend(true);
        this.data.clear();
        this.openCount = 0;
        this.data.suspend(false);
        for (i = 0; i < ap.length; ++i) {
            ac[i] = ap[i].get();
        }
        this.fireElementRemoved(ac, ap);
        for (i = 0; i < ap.length; ++i) {
            ap[i].delete();
        }
    }

    void clear() {
        GTDData.ActionProxy[] ap = this.data.toArray();
        Action[] ac = new Action[ap.length];
        this.data.suspend(true);
        this.data.clear();
        this.openCount = 0;
        this.data.suspend(false);
        for (int i = 0; i < ap.length; ++i) {
            ac[i] = ap[i].get();
        }
        this.fireElementRemoved(ac, ap);
    }

    void setOpenCount(int open) {
        this.openCount = open;
        this.data.store();
    }

    void add(Action[] ac, GTDData.ActionProxy[] ap) {
        if (ac == null || ac.length == 0 || ap == null || ap.length == 0) {
            return;
        }
        ArrayList<Action> aac = new ArrayList<Action>(ac.length);
        ArrayList<GTDData.ActionProxy> aap = new ArrayList<GTDData.ActionProxy>(ac.length);
        this.data.suspend(true);
        for (int i = 0; i < ac.length; ++i) {
            Action a = ac[i];
            GTDData.ActionProxy p = ap[i];
            if (this.data.contains(p)) continue;
            this.data.add(p);
            if (!this.isMeta()) {
                a.setParent(this);
            }
            if (a.isOpen() && this.isClosed()) {
                this.setClosed(false);
            }
            aac.add(a);
            aap.add(p);
            if (!a.isOpen()) continue;
            this.incOpentCount();
        }
        if (aac.size() == 0) {
            return;
        }
        this.sort();
        this.data.suspend(false);
        this.fireElementAdded(aac.toArray(new Action[aac.size()]), aap.toArray(new GTDData.ActionProxy[aap.size()]));
    }

    synchronized boolean remove(Action[] ac, GTDData.ActionProxy[] ap) {
        if (ac == null || ac.length == 0 || ap == null || ap.length == 0) {
            return false;
        }
        ArrayList<Action> aac = new ArrayList<Action>(ac.length);
        ArrayList<GTDData.ActionProxy> aap = new ArrayList<GTDData.ActionProxy>(ac.length);
        this.data.suspend(true);
        for (int i = 0; i < ac.length; ++i) {
            Action a = ac[i];
            GTDData.ActionProxy p = ap[i];
            if (!this.data.remove(p)) continue;
            aac.add(a);
            aap.add(p);
            if (!a.isOpen()) continue;
            this.decOpentCount();
        }
        if (aac.size() == 0) {
            return false;
        }
        this.sort();
        this.data.suspend(false);
        this.fireElementRemoved(aac.toArray(new Action[aac.size()]), aap.toArray(new GTDData.ActionProxy[aap.size()]));
        return true;
    }

    private void incOpentCount() {
        if (this.openCount < this.size()) {
            ++this.openCount;
            this.data.store();
        }
    }

    private void decOpentCount() {
        if (this.openCount > 0) {
            --this.openCount;
            this.data.store();
        }
    }

    private int countOpen() {
        int open = 0;
        for (Action a : this) {
            if (!a.isOpen()) continue;
            ++open;
        }
        return open;
    }

    public Date getResolved() {
        return this.data.getResolved();
    }

    public Date getModified() {
        return this.data.getModified();
    }

    public Date getCreated() {
        return this.data.getCreated();
    }

    void setDates(Date created, Date modified, Date resolved) {
        this.data.suspend(true);
        this.data.setCreated(created);
        this.data.setModified(modified);
        this.data.setResolved(resolved);
        this.data.suspend(false);
    }

    public Action getOpenFrom(int i) {
        while (i < this.size()) {
            Action a = this.get(i);
            if (a.isOpen()) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public static enum FolderPreset {
        ALL,
        OPEN;

    }

    public static enum FolderType {
        INBUCKET,
        ACTION,
        REFERENCE,
        BUILDIN,
        PROJECT,
        QUEUE,
        BUILDIN_REMIND,
        BUILDIN_RESOLVED,
        BUILDIN_PRIORITY,
        SOMEDAY,
        BUILDIN_DELETED;

    }
}

