/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree;

import java.util.Iterator;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.OrderByConstants;

public abstract class AbstractBTreeIterator
implements Iterator {
    private IBTree btree;
    protected IBTreeNode currentNode;
    private int currentKeyIndex;
    private int nbReturnedKeys;
    protected int nbReturnedElements;
    private OrderByConstants orderByType;

    public AbstractBTreeIterator(IBTree tree, OrderByConstants orderByType) {
        this.btree = tree;
        this.currentNode = tree.getRoot();
        this.orderByType = orderByType;
        this.currentKeyIndex = orderByType.isOrderByDesc() ? this.currentNode.getNbKeys() : 0;
    }

    public abstract Object getValueAt(IBTreeNode var1, int var2);

    public boolean hasNext() {
        return (long)this.nbReturnedElements < this.btree.getSize();
    }

    public Object next() {
        if (this.currentKeyIndex > this.currentNode.getNbKeys() || (long)this.nbReturnedElements >= this.btree.getSize()) {
            throw new ODBRuntimeException(NeoDatisError.NO_MORE_OBJECTS_IN_COLLECTION);
        }
        if (this.orderByType.isOrderByDesc()) {
            return this.nextDesc();
        }
        return this.nextAsc();
    }

    protected Object nextAsc() {
        while (!this.currentNode.isLeaf()) {
            this.currentNode = this.currentNode.getChildAt(this.currentKeyIndex, true);
            this.currentKeyIndex = 0;
        }
        if (this.currentKeyIndex < this.currentNode.getNbKeys()) {
            ++this.nbReturnedKeys;
            ++this.nbReturnedElements;
            Object nodeValue = this.getValueAt(this.currentNode, this.currentKeyIndex);
            ++this.currentKeyIndex;
            return nodeValue;
        }
        IBTreeNode child = null;
        while (this.currentKeyIndex >= this.currentNode.getNbKeys()) {
            child = this.currentNode;
            this.currentNode = this.currentNode.getParent();
            this.currentKeyIndex = this.indexOfChild(this.currentNode, child);
        }
        ++this.nbReturnedElements;
        ++this.nbReturnedKeys;
        Object value = this.getValueAt(this.currentNode, this.currentKeyIndex);
        ++this.currentKeyIndex;
        return value;
    }

    protected Object nextDesc() {
        while (!this.currentNode.isLeaf()) {
            this.currentNode = this.currentNode.getChildAt(this.currentKeyIndex, true);
            this.currentKeyIndex = this.currentNode.getNbKeys();
        }
        if (this.currentKeyIndex > 0) {
            ++this.nbReturnedElements;
            ++this.nbReturnedKeys;
            --this.currentKeyIndex;
            Object nodeValue = this.getValueAt(this.currentNode, this.currentKeyIndex);
            return nodeValue;
        }
        IBTreeNode child = null;
        while (this.currentKeyIndex == 0) {
            child = this.currentNode;
            this.currentNode = this.currentNode.getParent();
            this.currentKeyIndex = this.indexOfChild(this.currentNode, child);
        }
        ++this.nbReturnedElements;
        ++this.nbReturnedKeys;
        --this.currentKeyIndex;
        Object value = this.getValueAt(this.currentNode, this.currentKeyIndex);
        return value;
    }

    private int indexOfChild(IBTreeNode parent, IBTreeNode child) {
        for (int i = 0; i < parent.getNbChildren(); ++i) {
            if (parent.getChildAt(i, true).getId() != child.getId()) continue;
            return i;
        }
        throw new RuntimeException("parent " + parent + " does not have the specified child : " + child);
    }

    public void remove() {
    }

    public void reset() {
        this.currentNode = this.btree.getRoot();
        this.currentKeyIndex = this.orderByType.isOrderByDesc() ? this.currentNode.getNbKeys() : 0;
        this.nbReturnedElements = 0;
        this.nbReturnedKeys = 0;
    }
}

