/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.main;

import java.math.BigInteger;
import org.neodatis.odb.ClassRepresentation;
import org.neodatis.odb.DatabaseStartupManager;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBExt;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer3.IRefactorManager;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.IValuesQuery;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.server.trigger.ServerDeleteTrigger;
import org.neodatis.odb.core.server.trigger.ServerInsertTrigger;
import org.neodatis.odb.core.server.trigger.ServerSelectTrigger;
import org.neodatis.odb.core.server.trigger.ServerUpdateTrigger;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.values.ValuesCriteriaQuery;
import org.neodatis.odb.impl.main.DefaultClassRepresentation;
import org.neodatis.odb.impl.main.ODBExtImpl;
import org.neodatis.tool.DLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODBAdapter
implements ODB {
    protected IStorageEngine storageEngine;
    protected IClassIntrospector classIntrospector;
    private ODBExt ext;

    public ODBAdapter(IStorageEngine storageEngine) {
        this.storageEngine = storageEngine;
        this.classIntrospector = OdbConfiguration.getCoreProvider().getClassIntrospector();
        DatabaseStartupManager manager = OdbConfiguration.getDatabaseStartupManager();
        if (manager != null) {
            manager.start(this);
        }
    }

    @Override
    public void commit() {
        this.storageEngine.commit();
    }

    @Override
    public void rollback() {
        this.storageEngine.rollback();
    }

    public void commitAndClose() {
        this.storageEngine.commit();
        this.storageEngine.close();
    }

    @Override
    public OID store(Object object) {
        return this.storageEngine.store(object);
    }

    @Override
    public <T> Objects<T> getObjects(Class clazz) {
        return this.storageEngine.getObjects(new CriteriaQuery(clazz), true, -1, -1);
    }

    @Override
    public <T> Objects<T> getObjects(Class clazz, boolean inMemory) {
        return this.storageEngine.getObjects(clazz, inMemory, -1, -1);
    }

    @Override
    public <T> Objects<T> getObjects(Class clazz, boolean inMemory, int startIndex, int endIndex) {
        return this.storageEngine.getObjects(clazz, inMemory, startIndex, endIndex);
    }

    @Override
    public void close() {
        this.storageEngine.commit();
        this.storageEngine.close();
    }

    @Override
    public OID delete(Object object) {
        return this.storageEngine.delete(object, false);
    }

    @Override
    public OID deleteCascade(Object object) {
        return this.storageEngine.delete(object, true);
    }

    @Override
    public void deleteObjectWithId(OID oid) {
        this.storageEngine.deleteObjectWithOid(oid, false);
    }

    @Override
    public <T> Objects<T> getObjects(IQuery query) {
        return this.storageEngine.getObjects(query, true, -1, -1);
    }

    @Override
    public Values getValues(IValuesQuery query) {
        return this.storageEngine.getValues(query, -1, -1);
    }

    @Override
    public BigInteger count(CriteriaQuery query) {
        IValuesQuery q = new ValuesCriteriaQuery(query).count("count");
        q.setPolymorphic(query.isPolymorphic());
        Values values = this.storageEngine.getValues(q, -1, -1);
        BigInteger count = (BigInteger)values.nextValues().getByIndex(0);
        return count;
    }

    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory) {
        return this.storageEngine.getObjects(query, inMemory, -1, -1);
    }

    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory, int startIndex, int endIndex) {
        return this.storageEngine.getObjects(query, inMemory, startIndex, endIndex);
    }

    public ISession getSession() {
        return this.storageEngine.getSession(true);
    }

    @Override
    public OID getObjectId(Object object) {
        return this.storageEngine.getObjectId(object, true);
    }

    @Override
    public Object getObjectFromId(OID id) {
        return this.storageEngine.getObjectFromOid(id);
    }

    @Override
    public void defragmentTo(String newFileName) {
        this.storageEngine.defragmentTo(newFileName);
    }

    @Override
    public ClassRepresentation getClassRepresentation(Class clazz) {
        return this.getClassRepresentation(clazz.getName());
    }

    @Override
    public ClassRepresentation getClassRepresentation(String fullClassName) {
        return this.getClassRepresentation(fullClassName, true);
    }

    @Override
    public ClassRepresentation getClassRepresentation(String fullClassName, boolean loadClass) {
        ClassInfo classInfo = null;
        if (loadClass) {
            classInfo = this.storageEngine.getSession(true).getMetaModel().getClassInfo(fullClassName, false);
            if (classInfo == null) {
                ClassInfoList ciList = this.classIntrospector.introspect(fullClassName, true);
                this.storageEngine.addClasses(ciList);
                classInfo = ciList.getMainClassInfo();
            }
        } else {
            classInfo = new ClassInfo(fullClassName);
        }
        return new DefaultClassRepresentation(this.storageEngine, classInfo);
    }

    public void run() {
        if (!this.storageEngine.isClosed()) {
            DLogger.debug("ODB has not been closed and VM is exiting : force ODB close");
            this.storageEngine.close();
        }
    }

    @Override
    public void addUpdateTrigger(Class clazz, UpdateTrigger trigger) {
        if (trigger instanceof ServerUpdateTrigger) {
            throw new ODBRuntimeException(NeoDatisError.CAN_NOT_ASSOCIATE_SERVER_TRIGGER_TO_LOCAL_OR_CLIENT_ODB.addParameter(trigger.getClass().getName()));
        }
        this.storageEngine.addUpdateTriggerFor(clazz.getName(), trigger);
    }

    @Override
    public void addInsertTrigger(Class clazz, InsertTrigger trigger) {
        if (trigger instanceof ServerInsertTrigger) {
            throw new ODBRuntimeException(NeoDatisError.CAN_NOT_ASSOCIATE_SERVER_TRIGGER_TO_LOCAL_OR_CLIENT_ODB.addParameter(trigger.getClass().getName()));
        }
        this.storageEngine.addInsertTriggerFor(clazz.getName(), trigger);
    }

    @Override
    public void addDeleteTrigger(Class clazz, DeleteTrigger trigger) {
        if (trigger instanceof ServerDeleteTrigger) {
            throw new ODBRuntimeException(NeoDatisError.CAN_NOT_ASSOCIATE_SERVER_TRIGGER_TO_LOCAL_OR_CLIENT_ODB.addParameter(trigger.getClass().getName()));
        }
        this.storageEngine.addDeleteTriggerFor(clazz.getName(), trigger);
    }

    @Override
    public void addSelectTrigger(Class clazz, SelectTrigger trigger) {
        if (trigger instanceof ServerSelectTrigger) {
            throw new ODBRuntimeException(NeoDatisError.CAN_NOT_ASSOCIATE_SERVER_TRIGGER_TO_LOCAL_OR_CLIENT_ODB.addParameter(trigger.getClass().getName()));
        }
        this.storageEngine.addSelectTriggerFor(clazz.getName(), trigger);
    }

    @Override
    public IRefactorManager getRefactorManager() {
        return this.storageEngine.getRefactorManager();
    }

    @Override
    public ODBExt ext() {
        if (this.isClosed()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.getName()));
        }
        if (this.ext == null) {
            this.ext = new ODBExtImpl(this.storageEngine);
        }
        return this.ext;
    }

    @Override
    public void disconnect(Object object) {
        this.storageEngine.disconnect(object);
    }

    @Override
    public void reconnect(Object object) {
        this.storageEngine.reconnect(object);
    }

    @Override
    public boolean isClosed() {
        return this.storageEngine.isClosed();
    }

    @Override
    public CriteriaQuery criteriaQuery(Class clazz, ICriterion criterion) {
        return this.storageEngine.criteriaQuery(clazz, criterion);
    }

    @Override
    public CriteriaQuery criteriaQuery(Class clazz) {
        return this.storageEngine.criteriaQuery(clazz);
    }

    @Override
    public String getName() {
        return this.storageEngine.getBaseIdentification().getIdentification();
    }
}

